<?php
/**
 * Plugin Name:  TemplateMela Plugin - Harvest
 * Plugin URI:   #
 * Description:  This is TemplateMela Plugin - Harvest
 * Version:      3.1.0
 * Author:       TemplateMela
 * Author URI:   #
 * License:      GPL2
 * License URI:  https://www.gnu.org/licenses/gpl-2.0.html
 * Domain Path:  /languages
 * Text Domain:  templatemela-plugin-harvest
 * Requires PHP: 7.0
 *
 * @package TemplateMela
 */

// Block direct access to the main plugin file.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! defined( 'TMTHEME_NAME' ) ) {

	// Plugin Version.
	if ( ! defined( 'TMTHEME_VERSION' ) ) {
		define( 'TMTHEME_VERSION', '3.1.0' );
	}
	
	// Plugin Name.
	if ( ! defined( 'TMTHEME_NAME' ) ) {
		define( 'TMTHEME_NAME', 'Harvest' );
	}

	// Plugin Slug.
	if ( ! defined( 'TMTHEME_SLUG' ) ) {
		define( 'TMTHEME_SLUG', 'harvest' );
	}

	// Theme Group ID.
	if ( ! defined( 'TMTHEME_GROUP_ID' ) ) {
		define( 'TMTHEME_GROUP_ID', 'WCG1' );
	}
	
	// Theme ID.
	if ( ! defined( 'TMTHEME_ID' ) ) {
		define( 'TMTHEME_ID', 'WCM24_harvest' ); 
	}

	// Plugin Folder Path.
	if ( ! defined( 'TMTHEME_PATH' ) ) {
		define( 'TMTHEME_PATH', wp_normalize_path( dirname( __FILE__ ) ) );
	}

	// Plugin Folder URL.
	if ( ! defined( 'TMTHEME_URL' ) ) {
		define( 'TMTHEME_URL', plugin_dir_url( __FILE__ ) );
	}

	// The main plugin file path.
	if ( ! defined( 'TMTHEME_MAIN_PLUGIN_FILE' ) ) {
		define( 'TMTHEME_MAIN_PLUGIN_FILE', __FILE__ );
	}

	// Minimum PHP version required.
	if ( ! defined( 'TMTHEME_MIN_PHP_VER_REQUIRED' ) ) {
		define( 'TMTHEME_MIN_PHP_VER_REQUIRED', '7.0' );
	}

	// Minimum WP version required.
	if ( ! defined( 'TMTHEME_MIN_WP_VER_REQUIRED' ) ) {
		define( 'TMTHEME_MIN_WP_VER_REQUIRED', '5.0' );
	}

	// Minimum TM Core plugin version required.
	if ( ! defined( 'TMTHEME_MIN_TMCORE_VER_REQUIRED' ) ) {
		define( 'TMTHEME_MIN_TMCORE_VER_REQUIRED', '1.0.0' );
	}

} else {
	
	register_activation_hook(__FILE__, function () {
		/* Translators: %s  is the Theme Plugin Name. */
		die( sprintf( esc_html__( 'One of the TemplateMela Theme plugins is already active. Please deactivate the %s plugin and try again.', 'templatemela-plugin-harvest' ) , TMTHEME_NAME ) );
	});
}

if ( ! function_exists('templatemela_check_required_core_plugin') ) {

	function templatemela_check_required_core_plugin() {
		$tmcore_version = '0.0.1';
		if ( in_array( 'templatemela-core/templatemela-core.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
			$plugin_data = get_file_data( WP_PLUGIN_DIR . '/templatemela-core/templatemela-core.php', array('Version'), 'plugin');
			$tmcore_version = isset( $plugin_data[0] ) ?  $plugin_data[0] : '1.0.0';
		}
		return $tmcore_version;
	}
}

if ( ! function_exists('templatemela_check_required_theme') ) {

	function templatemela_check_required_theme() {
		$is_theme_exists = false;
		$current_theme = wp_get_theme();
		if ( get_template_directory() !== get_stylesheet_directory() ) {
			$is_theme_exists = ( 'avanam' === $current_theme->get( 'Template' ) ? true : false );
		} else {
			$is_theme_exists = ( 'Avanam' === $current_theme->get( 'Name' ) ? true : false );
		}
		return $is_theme_exists;
	}

}

/**
 * Compatibility check.
 *
 * Check that the site meets the minimum requirements for the plugin before proceeding.
 *
 * @since 1.0.0
 */
if ( version_compare( $GLOBALS['wp_version'], TMTHEME_MIN_WP_VER_REQUIRED, '<' ) || version_compare( PHP_VERSION, TMTHEME_MIN_PHP_VER_REQUIRED, '<' ) || version_compare( templatemela_check_required_core_plugin(), TMTHEME_MIN_TMCORE_VER_REQUIRED, '<' ) ) {
	require_once TMTHEME_PATH . '/includes/bootstrap-compat.php';
	return;
}

if ( false == templatemela_check_required_theme() ) {
	require_once TMTHEME_PATH . '/includes/bootstrap-compat.php';
}

/**
 * Bootstrap the plugin.
 *
 * @since 1.0.0
 */
require_once TMTHEME_PATH . '/includes/bootstrap.php';
