<?php
/**
 * Default Options Array
 *
 * @package TemplateMela Plugin
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1230,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Lato',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'inherit',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 30,
			'tablet' => 28,
			'mobile' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 25,
			'tablet' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 22,
			'tablet' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.6,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 20,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'color'   => 'palette3',
	),
	//buttons.
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'transform' => 'capitalize',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'buttons_color' => array(
		'color' => 'palette3',
		'hover' => 'palette9',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 0,
		),
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 8, 15, 8, 15 ),
			'mobile' => array( 5, 12, 5, 12 ),
		),
	),
	// Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_left' => array( ),
		),
		'main' => array(
			'main_left' => array( 'logo' ),
			'main_center' => array( 'navigation' ),
			'main_right' => array( 'search' , 'account' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array( ),
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_left' => array(),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'search', 'account', 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array(),
		),
	),
	// Header Main.
	'header_main_height' => array(
		'size' => array(
			'desktop' => 100,
			'tablet' => 80,
			'mobile' => 75,
		),
	),	
	'header_main_background' => array(
		'desktop' => array(
			'color' => 'rgba(22,27,30,1)',
		),
	),
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'primary_navigation_spacing' => array(
		'size' => 50,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 38,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
		'active' => 'palette1',
	),
	'primary_navigation_background' => array(
		'color' => 'transparent',
		'hover' => '#282d30',
		'active' => '#282d30',
	),
	//search
	'header_search_icon_size' => array(
		'size' => array(
			'desktop' => 20,
		),
		'unit' => array(
			'desktop' => 'px',
		),
	),
	'header_search_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	//header cart
	'header_cart_icon_size' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_cart_total_color' => array(
		'color' => '#161b1e',
		'hover' => '#161b1e',
	),
	'header_cart_total_background' => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
	),
	// mobile trigger
	'mobile_trigger_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'mobile_trigger_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	//dropdown
	'dropdown_navigation_typography' => array(
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'weight' => '500',
		'variant' => '500',
	),
	'dropdown_navigation_color'              => array(
		'color'  => 'palette4',
		'hover'  => 'palette6',
		'active' => 'palette6',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array( 'footer-widget1' ),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget3' ),
			'middle_2' => array( 'footer-widget4' ),
			'middle_3' => array( 'footer-widget5' ),
			'middle_4' => array( 'footer-widget6' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-social' ),
			'bottom_2' => array( 'footer-html' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => '#161B1E',
		),
	),
	//footer top
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette7',
		),
	),
	'footer_top_columns' => '1',
	'footer_top_widget_title' => array(
		'size' => array(
			'desktop' => 30,
			'tablet' => 28,
			'mobile' => 26,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Anton',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'footer_top_widget_content' => array(
		'size' => array(
			'desktop' => 16,
		),
		'color' => 'palette4',
	),
	//footer middle
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 17,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'color' => '#cccccc',
	),
	'footer_middle_link_colors' => array(
		'color' => '#cccccc',
		'hover' => 'palette1',
	),
	'footer_middle_columns' => '4',
	'footer_middle_link_style' => 'noline',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'desktop' => 50,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'desktop' => 60,
		),
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 50,
			'desktop' => 30,
		),
	),
	// Footer bottom
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'tablet' => 80,
			'desktop' => 90,
		),
	),
	'footer_bottom_background' => array(
		'desktop' => array(
			'color' => '#0D1012',
		),
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 5,
			'desktop' => 30,
		),
	),
	//footer html
	'footer_html_margin' => array(
		'size' => array( '0', '', '0', '' ),
	),
	'footer_html_link_color' => array(
		'color' => '#cccccc',
		'hover' => 'palette1',
	),
	'footer_html_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	'footer_html_typography' => array(
		'color' => '#cccccc',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id' => 'facebook',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'facebookAlt2',
				'label' => __( 'Facebook', 'templatemeta-plugin-harvest' ),
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'twitterAlt2',
				'label' => __( 'Twitter', 'templatemeta-plugin-harvest' ),
			),
			array(
				'id' => 'instagram',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'instagramAlt',
				'label' => __( 'Instagram', 'templatemeta-plugin-harvest' ),
			),
			array(
				'id' => 'linkedin',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'linkedin',
				'label' => __( 'linkedin', 'templatemeta-plugin-harvest' ),
			),
			array(
				'id' => 'whatsapp',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'whatsapp',
				'label' => __( 'whatsapp', 'templatemeta-plugin-harvest' ),
			),
		),
	),
	'footer_social_align' => array(
		'tablet' => 'center',
		'desktop' => 'left',
	),
	'footer_social_icon_size' => array(
		'size' => 18,
		'unit' => 'px',
	),
	'footer_social_color' => array(
		'color' => '#999999',
		'hover' => 'palette1',
	),
	// Shop
	'product_archive_sidebar_id' => 'sidebar-woocommerce-shop',
	'product_archive_price_font' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '900',
		'variant' => '900',
		'color' => 'palette3',
	),
	'product_archive_button_style' => 'button',
	'product_title_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 23,
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'Lato',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_related_columns' => '4',
	'product_upsell_columns' => '4',
	// Sidebar.
	'sidebar_width' => array(
		'size' => 270,
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'sidebar_widget_content' => array(
		'weight' => '500',
		'variant' => '500',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette6',
	),
	'sidebar_link_style' => 'plain',
	// Breadcrumbs
	'product_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'page_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'post_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'search_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	), 
);
$header_addons = array(
	//header account
	'header_account_in_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_account_in_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
	'header_account_icon_size' => array(
		'size' => 20,
		'unit' => 'px',
	),
	'header_account_color' => array(
		'color' => '#ffffff',
		'hover' => 'palette1',
	),
);
$more_addons = array();
$woo_addons = array(
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'product_archive_shop_filter_padding' => array(
		'size'   => array( 4, 12, 4, 12 ),
		'unit'   => 'px',
		'locked' => false,
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
);