<?php
/**
 * default Options Array
 *
 * @package TemplateMela Plugin
 * @since 1.0
 */

$default_options = array(
	'content_width' => array(
		'size' => 1230,
		'unit' => 'px',
	),
	// Typography.
	'base_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'Lato',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette4',
	),
	'heading_font' => array(
		'family' => 'Lato',
	),
	'h1_font' => array(
		'size' => array(
			'desktop' => 30,
			'tablet' => 25,
			'mobile' => 22,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h2_font' => array(
		'size' => array(
			'desktop' => 28,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
		'color' => 'palette3',
	),
	'h3_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'h4_font' => array(
		'size' => array(
			'desktop' => 20,
			'mobile' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'h5_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'h6_font' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '500',
		'variant' => '500',
		'color'   => 'palette3',
	),
	'title_above_breadcrumb_font' => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family'  => 'inherit',
		'google'  => true,
		'weight'  => '400',
		'variant' => '400',
		'color'   => 'palette3',
	),
	//buttons
	'buttons_color'                     => array(
		'color'  => 'palette9',
		'hover'  => 'palette9',
	),
	'buttons_background' => array(
		'color'  => 'palette1',
		'hover'  => 'palette2',
	),
	'buttons_typography'    => array(
		'size' => array(
			'desktop' => 14,
		),
		'lineHeight' => array(
			'desktop' => 2,
		),
		'transform' => 'capitalize',
		'google' => true,
		'weight' => '400',
		'variant' => '400',
	),
	'buttons_border_radius' => array(
		'size' => array(
			'desktop' => 5,
		),
	),
	'buttons_padding' => array(
		'size' => array( 
			'desktop' => array( 8, 15, 8, 15 ),
			'mobile' => array( 5, 12, 5, 12 ),
		),
	),
	// Logo
	'logo_layout' => array(
		'include' => array(
			'mobile' => 'logo_only',
			'tablet' => 'logo_only',
			'desktop' => 'logo_only',
		),
	),
	// Header.
	'header_desktop_items' => array(
		'top' => array(
			'top_left' => array( 'navigation-2' ),
			'top_right' => array( 'account' ),
		),
		'main' => array(
			'main_left' => array( 'logo' ),
			'main_right' => array( 'contact' , 'cart' ),
		),
		'bottom' => array(
			'bottom_left' => array( 'navigation' ),
			'bottom_right' => array( 'search-advanced' ),
		),
	),
	'header_wrap_background' => array(
		'desktop' => array(
			'color' => 'palette9',
			'image' => array(
				'url' => __(TMTHEME_URL.'layouts/electronics/img/header-bg.png'),
				'size'=> 'auto',
				'attachment' => 'scroll',
				'position' => array(
					'x' => 0.5,
					'y' => 1,
				),					
			),
			'type' => 'image',
		),
	),
	// Mobile Header.
	'header_mobile_items' => array(
		'popup' => array(
			'popup_content' => array( 'mobile-navigation', 'mobile-nav2' ),
		),
		'top' => array(
			'top_left' => array(),
		),
		'main' => array(
			'main_left' => array( 'popup-toggle', 'mobile-logo' ),
			'main_right' => array( 'mobile-account', 'mobile-cart' ),
		),
		'bottom' => array(
			'bottom_center' => array('search-advanced'),
		),
	),
	//header top
	'header_top_background' => array(
		'desktop' => array(
			'color' => 'rgba(255,255,255,0.8)',
		),
	),
	'header_top_height' => array(
		'size' => array(
			'desktop' => 30,
		),
	),
	//header main
	'header_main_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	 ),
	 'header_main_height' => array(
		'size' => array(
			'desktop' => 132,
			'tablet' => 100,
			'mobile' => 80,
		),
	),
	//header bottom
	'header_bottom_background' => array(
		'desktop' => array(
			'color' => 'rgba(0,108,181,1)',
		),
	),
	'header_bottom_padding' => array(
		'size' => array( 
			'desktop' => array( 0, 0, 0, 15 ),
			'tablet' => array( 0, 0, 0, 0 ),
		),
	),
	'header_bottom_height' => array(
		'size' => array(
			'desktop' => 62,
			'tablet' => 55,
		),
	),
	'header_bottom_layout' => array(
		'desktop' => 'contained',
	),
	//secondary navigation
	'secondary_navigation_spacing' => array(
		'size' => 30,
		'unit' => 'px',
	),
	'secondary_navigation_color' => array(
		'color' => '#161b1e',
		'hover' => '#161b1e',
		'active' => '#161b1e',
	),
	'secondary_navigation_vertical_spacing' => array(
		'size' => 0,
		'unit' => 'em',
	),
	// Navigation.
	'primary_navigation_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'primary_navigation_spacing' => array(
		'size' => 40,
		'unit' => 'px',
	),
	'primary_navigation_vertical_spacing' => array(
		'size' => 21,
		'unit' => 'px',
	),
	'primary_navigation_color' => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
		'active' => '#ffffff',
	),
	//header cart
	'header_cart_icon_size' => array(
		'size' => 32,
		'unit' => 'px',
	),
	'header_cart_color' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	'header_cart_background' => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
	),
	'header_cart_total_color' => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
	),
	'header_cart_total_background' => array(
		'color' => '#ef5339',
		'hover' => '#ef5339',
	),
	'header_cart_padding' => array(
		'size' => array( 20, 15, 20, 15 ),
		'unit' => 'px',
		'locked' => false,
	),
	//moble trigger
	'mobile_trigger_icon_size' => array(
		'size' => 22,
		'unit' => 'px',
	),
	'mobile_trigger_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	//mobile 
	'header_mobile_cart_icon_size' => array(
		'size' => 29,
		'unit' => 'px',
	),
	'header_mobile_cart_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_cart_total_color' => array(
		'color' => 'palette9',
		'hover' => 'palette9',
	),
	'header_mobile_cart_total_background' => array(
		'color' => 'palette1',
		'hover' => 'palette1',
	),
	//dropdown
	'dropdown_navigation_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.4,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '500',
		'variant' => '500',
	),
	// Footer.
	'footer_items' => array(
		'top' => array(
			'top_1' => array( 'footer-widget1' ),
		),
		'middle' => array(
			'middle_1' => array( 'footer-widget3' ),
			'middle_2' => array( 'footer-widget4' ),
			'middle_3' => array( 'footer-widget5' ),
			'middle_4' => array( 'footer-widget6' ),
		),
		'bottom' => array(
			'bottom_1' => array( 'footer-social' ),
			'bottom_2' => array( 'footer-html' ),
		),
	),
	'footer_wrap_background' => array(
		'desktop' => array(
			'color' => '#005995',
		),
	),
	//footer top
	'footer_top_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'footer_top_columns' => '1',
	'footer_top_widget_title' => array(
		'size' => array(
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => '#ffffff',
	),
	'footer_top_widget_content' => array(
		'size' => array(
			'desktop' => 16,
		),
		'color' => '#ffffff',
	),
	//footer middle
	'footer_middle_bottom_border' => array(
		'desktop' => array(
			'width' => 0,
		),
	),
	'footer_middle_widget_title' => array(
		'size' => array(
			'desktop' => 17,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '700',
		'variant' => '700',
		'color' => '#ffffff',
	),
	'footer_middle_widget_content' => array(
		'color' => 'palette6',
	),
	'footer_middle_link_colors' => array(
		'color' => 'palette6',
		'hover' => '#ffffff',
	),
	'footer_middle_columns' => '4',
	'footer_middle_link_style' => 'noline',
	'footer_middle_top_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'desktop' => 50,
		),
	),
	'footer_middle_bottom_spacing' => array(
		'size' => array(
			'mobile' => 40,
			'desktop' => 60,
		),
	),
	'footer_middle_layout' => array(
		'mobile' => 'row',
		'tablet' => 'two-grid',
		'desktop' => 'center',
	),
	'footer_middle_column_spacing' => array(
		'size' => array(
			'mobile' => 30,
			'tablet' => 50,
			'desktop' => 30,
		),
	),
	// Footer bottom
	'footer_bottom_bottom_spacing' => array(
		'size' => array(
			'tablet' => 80,
			'desktop' => 90,
		),
	),
	'footer_bottom_background' => array(
		'desktop' => array(
			'color' => 'palette1',
		),
	),
	'footer_bottom_columns' => '2',
	'footer_bottom_link_style' => 'noline',
	'footer_bottom_column_spacing' => array(
		'size' => array(
			'tablet' => 5,
			'desktop' => 30,
		),
	),
	//footer html
	'footer_html_margin' => array(
		'size' => array( '0', '', '0', '' ),
	),
	'footer_html_link_color' => array(
		'color' => 'palette6',
		'hover' => '#ffffff',
	),
	'footer_html_align' => array(
		'tablet' => 'center',
		'desktop' => 'right',
	),
	'footer_html_typography' => array(
		'color' => '#cccccc',
	),
	// Footer Social.
	'footer_social_items' => array(
		'items' => array(
			array(
				'id' => 'facebook',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'facebookAlt2',
				'label' => __( 'Facebook', 'templatemela-plugin-harvest' ),
			),
			array(
				'id' => 'twitter',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'twitterAlt2',
				'label' => __( 'Twitter', 'templatemela-plugin-harvest' ),
			),
			array(
				'id' => 'instagram',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'instagramAlt',
				'label' => __( 'Instagram', 'templatemela-plugin-harvest' ),
			),
			array(
				'id' => 'linkedin',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'linkedin',
				'label' => __( 'linkedin', 'templatemela-plugin-harvest' ),
			),
			array(
				'id' => 'whatsapp',
				'enabled' => true,
				'source' => 'icon',
				'url' => '',
				'imageid' => '',
				'width' => 24,
				'icon' => 'whatsapp',
				'label' => __( 'whatsapp', 'templatemela-plugin-harvest' ),
			),
		),
	),
	'footer_social_align' => array(
		'tablet' => 'center',
		'desktop' => 'left',
	),
	'footer_social_icon_size' => array(
		'size' => 18,
		'unit' => 'px',
	),
	'footer_social_color' => array(
		'color' => 'palette6',
		'hover' => '#ffffff',
	),
	// Shop
	'product_archive_sidebar_id' => 'sidebar-woocommerce-shop',
	'product_archive_price_font' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '900',
		'variant' => '900',
		'color' => 'palette3',
	),
	'product_archive_button_style' => 'button',
	'product_title_font' => array(
		'size' => array(
			'mobile' => 20,
			'tablet' => 23,
			'desktop' => 25,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	//post archive
	'post_archive_item_title_font' => array(
		'size' => array(
			'desktop' => 24,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'lineType' => 'em',
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	// Sidebar.
	'sidebar_width' => array(
		'size' => 250,
		'unit' => 'px',
	),
	'sidebar_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'sidebar_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'sidebar_link_style' => 'plain',
	// Breadcrumbs
	'product_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'page_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'post_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	),
	'post_archive_title_height' => array(
		'size' => array(
			'desktop' => 130,
		),
	),
	'search_archive_title_height' => array(
		'size' => array(
			'mobile' => 70,
			'tablet' => 100,
			'desktop' => 130,
		),
	), 
	// Shop
	'product_archive_sidebar_id' => 'sidebar-woocommerce-shop',
);
$header_addons = array(
	//header account
	'header_account_in_style' => 'label',
	'header_account_in_label' => __( 'Logout / Register', 'templatemela-plugin-harvest' ),
	'header_account_in_typography_color' => array(
		'color' => '#161b1e',
		'hover' => '#161b1e',
	),
	'header_account_in_padding' => array(
		'size' => array( 0, 0, 0, 0 ),
		'unit' => 'em',
		'locked' => true,
	),
	'header_account_style' => 'label',
	'header_account_label' => __( 'Login / Register', 'templatemela-plugin-harvest' ),
	'header_account_typography_color' => array(
		'color' => '#161b1e',
		'hover' => '#161b1e',
	),
	'header_account_padding' => array(
		'size' => array( 0, 0, 0, 0 ),
		'unit' => 'em',
		'locked' => true,
	),
	// Header Contact.
	'header_contact_items' => array(
		'items' => array(
			array(
				'id' => 'phone',
				'enabled' => true,
				'source' => 'image',
				'url' => __(TMTHEME_URL.'layouts/electronics/img/call.png'),
				'imageid' => '',
				'width' => 30,
				'link' => '(+91) 121 21212 35',
				'icon' => 'phone',
				'title' => 'Call now',
				'label' => '01-2345-678',
			),
		),
	),
	'header_contact_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_contact_typography' => array(
		'size' => array(
			'desktop' => 15,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
	),
	'header_contact_margin' => array(
		'size' => array( 0, 15, 0, 0 ),
		'unit' => 'px',
		'locked' => false,
	),
	//header mobile account
	'header_mobile_account_in_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_mobile_account_in_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
	'header_mobile_account_icon_size' => array(
		'size' => 25,
		'unit' => 'px',
	),
	'header_mobile_account_color' => array(
		'color' => 'palette3',
		'hover' => 'palette1',
	),
);
$more_addons = array(
	//search avdanced
	'header_search_advanced_width' => array(
		'size' => array(
			'desktop' => 288,
			'tablet' => 480,
		),
	),
	'header_search_advanced_border' => array(
		'width' => '0',
		'unit' => 'px',
		'style' => 'solid',
	),
	'header_search_advanced_buttons_background' => array(
		'color' => '-webkit-linear-gradient(top, #fd5c41 0%,#e6492f 100%)',
		'hover' => '-webkit-linear-gradient(top, #fd5c41 0%,#e6492f 100%)',
	),
	'header_search_advanced_button_radius' => array(
		'size' => array( 0, 5, 5, 0 ),
		'unit' => 'px',
		'locked' => true,
	),
	'header_search_advanced_input_padding' => array(
		'size' => array( 0, 50, 0, 15 ),
		'unit' => 'px',
		'locked' => false,
	),
	'header_search_advanced_buttons_color' => array(
		'color' => '#ffffff',
		'hover' => '#ffffff',
	),
	'header_search_advanced_background' => array(
		'color' => '#ffffff',
	),
);
$woo_addons = array(
	'product_filter_widget_link_colors' => array(
		'color' => 'palette4',
		'hover' => 'palette1',
	),
	'product_filter_widget_title' => array(
		'size' => array(
			'desktop' => 18,
		),
		'lineHeight' => array(
			'desktop' => 1.5,
		),
		'family' => 'inherit',
		'google' => true,
		'weight' => '600',
		'variant' => '600',
		'color' => 'palette3',
	),
	'product_archive_shop_filter_padding' => array(
		'size'   => array( 4, 12, 4, 12 ),
		'unit'   => 'px',
		'locked' => false,
	),
);
$dark_mode_addons = array(
	'dark_mode_custom_logo' => true,
 );