<?php


add_filter( 'tmc_recommended_plugins', 'theme_required_plugins_register');

function theme_required_plugins_register() {
	
	if ( class_exists( 'TemplateMelaCore_Settings' ) ) {
		$tmc_options = TemplateMelaCore_Settings::get_setting_option( 'tm_core_api_manager' ) ;
	}
	$lkey = ( isset( $tmc_options['tm_core_api_key'] ) ) ? $tmc_options['tm_core_api_key'] : '';

	$merge_plugins = array();
	

	$merge_plugins = array(
		array(
			'order'         => 10,
			'name'          => esc_html__( 'WooCommerce', 'templatemela-core' ),
			'slug'          => 'woocommerce',
			'image'         => 'https://data.templatemela.com/plugins/wp/images/woocommerce.png',
			'required'      => true,
			'preselected'   => true,
			'is_callable'   => true,
		),

		array(
			'order'         => 15,
			'name'          => esc_html__( 'Elementor Page Builder', 'templatemela-core' ),
			'slug'          => 'elementor',
			'image'         => 'https://data.templatemela.com/plugins/wp/images/elementor.png',
			'required'      => true,
			'preselected'   => false,
			'is_callable'   => true,
		),
		array(
			'order'         => 20,
			'name'      => esc_html__( 'Mailchimp Newsletter', 'templatemela-core' ),
			'slug'      => 'mailchimp-for-wp',
			'required'  => false,
		),
		array(
			'order'         => 25,
			'name'      => esc_html__( 'WPC Smart Compare for WooCommerce', 'templatemela-core' ),
			'slug'      => 'woo-smart-compare',
			'required'  => false,
		),
		array(
			'order'         => 30,
			'name'      => esc_html__( 'WPC Smart Quick View for WooCommerce', 'templatemela-core' ),
			'slug'      => 'woo-smart-quick-view',
			'required'  => false,
		),
		array(
			'order'         => 35,
			'name'      => esc_html__( 'WPC Smart Wishlist for WooCommerce', 'templatemela-core' ),
			'slug'      => 'woo-smart-wishlist',
			'required'  => false,
		),
		array(
			'order'         => 40,
			'name'      => esc_html__( 'Contact Form 7', 'templatemela-core' ),
			'slug'      => 'contact-form-7',
			'required'      => false,
		),
		array(
			'order'         => 50,
			'name'          => esc_html__( 'Slider Revolution', 'templatemela-core' ),
			'slug'          => 'revslider',
			'source'        => 'https://data.templatemela.com/plugins/wp/download/?plugin=revslider&key=tmcore_'.$lkey,
			'image'         => 'https://data.templatemela.com/plugins/wp/revslider/revslider.png',
			'required'      => false,
			'preselected'   => true,
			'version'       => '6.6.11',
			'is_callable'   => true,
		),
	);

	return $merge_plugins;

}
