<?php
/**
 * Build Admin Page with settings.
 *
 * @package Base
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}


/**
 * Build Admin Page class
 *
 * @category class
 */
class TemplateMela_Plugin_Admin_Settings {

	/**
	 * Settings of this class
	 *
	 * @var array
	 */
	public static $settings = array();

	/**
	 * Instance of this class
	 *
	 * @var null
	 */
	private static $instance = null;
	/**
	 * Static var active plugins
	 *
	 * @var $active_plugins
	 */
	private static $active_plugins;

	/**
	 * This file
	 *
	 * @var string
	 */
	private $file = '';

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Class Constructor.
	 */
	public function __construct() {
		
		$this->file = __FILE__;

		// only load if admin.
		if ( is_admin() ) {
			//add_action( 'admin_menu', array( $this, 'add_menu' ) );
		
			// Load the TGM Config.
			require_once dirname( $this->file ) . '/plugins.php';

			// Import Data.
			require_once dirname( $this->file ) . '/import-content.php';

		}
		add_action( 'init', array( $this, 'load_api_settings' ) );
		//add_action( 'after_setup_theme', array( $this, 'theme_admin_required' ) );
		
	}

	/**
	 * Add option page menu
	 */
	public function add_menu() {}


	/**
	 * Register settings
	 */
	public function load_api_settings() {

		register_setting(
			TMTHEME_ID.'_theme_config',
			TMTHEME_ID.'_theme_config',
			array(
				'type'              => 'string',
				'description'       => __( 'Config Theme Modules', 'templatemela-plugin-harvest' ),
				'sanitize_callback' => 'sanitize_text_field',
				'show_in_rest'      => true,
				'default'           => '',
			)
		);

	}

	/**
	 * Loads admin style sheets and scripts
	 */
	public function scripts() {}

}
TemplateMela_Plugin_Admin_Settings::get_instance();
