<?php

use function Base\webapp;

/**
 * Checks if the current page is a product archive
 *
 * @return boolean
 */
function tmcore_is_product_archive() {
    if (is_shop() || is_product_taxonomy() || is_product_category() || is_product_tag()) {
        return true;
    } else {
        return false;
    }
}

/**
 * Checks if the current page is a product archive
 *
 * @return boolean
 */
function tmcore_is_product_taxonomy() {
    $taxonomies = get_object_taxonomies( 'product' );

    return empty( $taxonomies ) ? false : is_tax( $taxonomies );
}

/**
 * @param $product WC_Product
 */
function tmcore_product_get_image($product){
	return $product->get_image();
}

/**
 * @param $product WC_Product
 */
function tmcore_product_get_price_html($product){
	return $product->get_price_html();
}

/**
 * Retrieves the previous product.
 *
 * @param bool $in_same_term Optional. Whether post should be in a same taxonomy term. Default false.
 * @param array|string $excluded_terms Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param string $taxonomy Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
function tmcore_get_previous_product($in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat') {
    $product = new TMCore_WooCommerce_Adjacent_Products($in_same_term, $excluded_terms, $taxonomy, true);
    return $product->get_product();
}

/**
 * Retrieves the next product.
 *
 * @param bool $in_same_term Optional. Whether post should be in a same taxonomy term. Default false.
 * @param array|string $excluded_terms Optional. Comma-separated list of excluded term IDs. Default empty.
 * @param string $taxonomy Optional. Taxonomy, if $in_same_term is true. Default 'product_cat'.
 * @return WC_Product|false Product object if successful. False if no valid product is found.
 * @since 2.4.3
 *
 */
function tmcore_get_next_product($in_same_term = false, $excluded_terms = '', $taxonomy = 'product_cat') {
    $product = new TMCore_WooCommerce_Adjacent_Products($in_same_term, $excluded_terms, $taxonomy);
    return $product->get_product();
}


function tmcore_woocommerce_pagination_args($args) {
    $args['prev_text'] = '<span>' . __('Previous', 'templatemela-core').'</span>';
    $args['next_text'] ='<span>'. __('Next', 'templatemela-core') . '</span>';
    return $args;
}
add_filter('woocommerce_pagination_args', 'tmcore_woocommerce_pagination_args', 10, 1);

/**
 * Check if a product is a deal
 *
 * @param int|object $product
 *
 * @return bool
 */
if(!function_exists('tmcore_ajax_search_products')) {
    function tmcore_ajax_search_products() {
        global $woocommerce;

        $search_keyword = $_REQUEST['query'];

        $ordering_args = $woocommerce->query->get_catalog_ordering_args('date', 'desc');
        $suggestions   = array();

        $args = array(
            's'                   => apply_filters('tmcore_ajax_search_products_search_query', $search_keyword),
            'post_type'           => 'product',
            'post_status'         => 'publish',
            'ignore_sticky_posts' => 1,
            'orderby'             => $ordering_args['orderby'],
            'order'               => $ordering_args['order'],
            'posts_per_page'      => apply_filters('tmcore_ajax_search_products_posts_per_page', 8),

        );

        $products = new WP_Query($args);
        if ($products->have_posts()) {
            while ( $products->have_posts() ) {
                $products->the_post();
                $product       = wc_get_product(get_the_ID());
                $product_image = wp_get_attachment_image_src(get_post_thumbnail_id($product->get_id()));

                $suggestions[] = apply_filters('tmcore_suggestion', array(
                    'id'    => $product->get_id(),
                    'value' => strip_tags($product->get_title()),
                    'url'   => $product->get_permalink(),
                    'img'   => esc_url($product_image[0]),
                    'price' => $product->get_price_html(),
                ), $product);
            }
        } else {
            $suggestions[] = array(
                'id'    => -1,
                'value' => __('No results', 'templatemela-core'),
                'url'   => '',
            );
        }
        wp_reset_postdata();

        echo json_encode($suggestions);
        die();
    }
}
add_action('wp_ajax_tmcore_ajax_search_products','tmcore_ajax_search_products');
add_action('wp_ajax_nopriv_tmcore_ajax_search_products','tmcore_ajax_search_products');


if (!function_exists('tmcore_single_product_pagination')) {
    /**
     * Single Product Pagination
     *
     * @since 2.3.0
     */
    function tmcore_single_product_pagination() {
//		if ( get_theme_mod( 'tmcore_product_pagination' ) !== true ) {
//			return;
//		}

        // Show only products in the same category?
        $in_same_term   = apply_filters('tmcore_single_product_pagination_same_category', true);
        $excluded_terms = apply_filters('tmcore_single_product_pagination_excluded_terms', '');
        $taxonomy       = apply_filters('tmcore_single_product_pagination_taxonomy', 'product_cat');

        $previous_product = tmcore_get_previous_product($in_same_term, $excluded_terms, $taxonomy);
        $next_product     = tmcore_get_next_product($in_same_term, $excluded_terms, $taxonomy);

        if ((!$previous_product && !$next_product) || !is_product()) {
            return;
        }

        ?>
        <div class="tmcore-product-pagination-wrap">
            <nav class="tmcore-product-pagination" aria-label="<?php esc_attr_e('More products', 'templatemela-core'); ?>">
                <?php if ($previous_product) : ?>
                    <a href="<?php echo esc_url($previous_product->get_permalink()); ?>" rel="prev">
                        <i class="tmcore-icon-arrow-circle-left"></i>
                        <div class="product-item">
                            <?php echo wp_kses_post($previous_product->get_image()); ?>
                            <div class="tmcore-product-pagination-content">
                                <span class="tmcore-product-pagination__title"><?php echo wp_kses_post($previous_product->get_name()); ?></span>
                                <?php if ($price_html = $previous_product->get_price_html()) : ?>
                                    <span class="price"><?php printf('%s',$price_html); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endif; ?>
                <a href="<?php echo esc_url(get_permalink(get_option('woocommerce_shop_page_id'))) ?>"><i class="tmcore-icon-grip-horizontal shop-tooltip" title="<?php esc_attr_e('Back to shop', 'templatemela-core') ?>"></i></a>
                <?php if ($next_product) : ?>
                    <a href="<?php echo esc_url($next_product->get_permalink()); ?>" rel="next">
                        <i class="tmcore-icon-arrow-circle-right"></i>
                        <div class="product-item">
                            <?php echo wp_kses_post($next_product->get_image()); ?>
                            <div class="tmcore-product-pagination-content">
                                <span class="tmcore-product-pagination__title"><?php echo wp_kses_post($next_product->get_name()); ?></span>
                                <?php if ($price_html = $next_product->get_price_html()) : ?>
                                    <span class="price"><?php printf('%s',$price_html); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </a>
                <?php endif; ?>
            </nav><!-- .tmcore-product-pagination -->
        </div>
        <?php

    }
}



if (!function_exists('tmcore_woocommerce_product_loop_image')) {
    function tmcore_woocommerce_product_loop_image() {
        ?>
        <div class="product-transition"><?php do_action('tmcore_woocommerce_product_loop_image') ?></div>
        <?php
    }
}

if (!function_exists('tmcore_woocommerce_get_product_category')) {
    function tmcore_woocommerce_get_product_category() {
        global $product;
        echo wc_get_product_category_list($product->get_id(), ' ', '<div class="posted-in">', '</div>');
    }
}


if (!function_exists('tmcore_woocommerce_get_product_short_description')) {
    function tmcore_woocommerce_get_product_short_description() {
        global $post;
        $short_description = wp_trim_words(apply_filters('woocommerce_short_description', $post->post_excerpt), 15);
        if ($short_description) {
            ?>
            <div class="short-description">
                <?php echo wp_kses_post($short_description); ?>
            </div>
            <?php
        }
    }
}



if (!function_exists('tmcore_header_wishlist')) {
    function tmcore_header_wishlist() {
        if (function_exists('yith_wcwl_count_all_products')) {
            ?>
            <div class="site-header-wishlist">
                <a class="header-wishlist" href="<?php echo esc_url(get_permalink(get_option('yith_wcwl_wishlist_page_id'))); ?>">
                    <i class="tmcore-icon-heart"></i>
                    <span class="count"><?php echo esc_html(yith_wcwl_count_all_products()); ?></span>
                </a>
            </div>
            <?php
        } elseif (function_exists('woosw_init')) {
            $key = WPCleverWoosw::get_key();

            ?>
            <div class="site-header-wishlist">
                <a class="header-wishlist" href="<?php echo esc_url(WPCleverWoosw::get_url( $key, true )); ?>">
                    <i class="tmcore-icon-heart"></i>
                    <span class="count"><?php echo esc_html(WPCleverWoosw::get_count($key)); ?></span>
                </a>
            </div>
            <?php
        }
    }
}


if (!function_exists('tmcore_woocommerce_change_template_path')) {
    function tmcore_woocommerce_change_template_path($template, $slug, $name) {
        wc_get_template('content-widget-product.php', apply_filters('tmcore_product_template_arg', array('show_rating' => false)));
    }
}

if (!function_exists('tmcore_woocommerce_list_show_rating_arg')) {
    function tmcore_woocommerce_list_show_rating_arg($arg) {
        $arg['show_rating'] = true;

        return $arg;
    }
}


if (!function_exists('tmcore_woocommerce_list_get_rating')) {
    function tmcore_woocommerce_list_show_rating() {
        global $product;
        echo wc_get_rating_html($product->get_average_rating());
    }
}

if (!function_exists('tmcore_single_product_quantity_label')) {
    function tmcore_single_product_quantity_label() {
        echo '<label class="quantity_label">' . __('Quantity', 'templatemela-core') . ' </label>';
    }
}

