<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
//add_action( 'after_setup_theme ', 'bt_variation_swatches_plugin_loaded' );

bt_variation_swatches_plugin_loaded();

function bt_variation_swatches_plugin_loaded() {

	class bt_variation_swatches {

		public function __construct() {
			require TMCORE_WOO_PATH . '/lib/swatches/bt-variations-swatches-output.php';
			add_action( 'woocommerce_product_write_panel_tabs', array( $this, 'bt_variation_swatches_panel_tabs' ), 99 );
			add_action( 'woocommerce_product_data_panels', array( $this, 'bt_variation_swatches_panel_output' ), 99 );
			add_action( 'woocommerce_process_product_meta', array( $this, 'bt_variation_swatches_process_meta' ), 1, 2 );
			add_action( 'wp_enqueue_scripts', array( $this, 'bt_variation_swatches_enqueue_scripts' ), 101 );
			add_action( 'admin_enqueue_scripts', array( $this, 'bt_variation_swatches_admin_enqueue_scripts' ) );
			add_action( 'admin_init', array( $this, 'bt_woo_extras_register_taxonomy_meta_boxes' ) );
			add_filter( 'body_class', array( $this, 'single_product_body_classes' ) );

			add_filter( 'product_attributes_type_selector', array( $this, 'add_attribute_select_types' ), 100 );
			add_action( 'woocommerce_product_option_terms', array( $this, 'manage_attribute_options'), 20, 3 );
		}
		public function manage_attribute_options( $attribute_taxonomy, $i, $attribute ) {
			if ( 'select' !== $attribute_taxonomy->attribute_type ) {
				?>
				<select multiple="multiple" data-placeholder="<?php esc_attr_e( 'Select terms', 'woocommerce' ); ?>" class="multiselect attribute_values wc-enhanced-select" name="attribute_values[<?php echo esc_attr( $i ); ?>][]">
					<?php
					$args      = array(
						'orderby'    => ! empty( $attribute_taxonomy->attribute_orderby ) ? $attribute_taxonomy->attribute_orderby : 'name',
						'hide_empty' => 0,
					);
					$all_terms = get_terms( $attribute->get_taxonomy(), apply_filters( 'woocommerce_product_attribute_terms', $args ) );
					if ( $all_terms ) {
						foreach ( $all_terms as $term ) {
							$options = $attribute->get_options();
							$options = ! empty( $options ) ? $options : array();
							echo '<option value="' . esc_attr( $term->term_id ) . '"' . wc_selected( $term->term_id, $options ) . '>' . esc_html( apply_filters( 'woocommerce_product_attribute_term_name', $term->name, $term ) ) . '</option>';
						}
					}
					?>
				</select>
				<button class="button plus select_all_attributes"><?php esc_html_e( 'Select all', 'woocommerce' ); ?></button>
				<button class="button minus select_no_attributes"><?php esc_html_e( 'Select none', 'woocommerce' ); ?></button>
				<button class="button fr plus add_new_attribute"><?php esc_html_e( 'Add new', 'woocommerce' ); ?></button>
				<?php
			}
		}
		public function add_attribute_select_types( $types ) {
			$types = array(
				'select' => __( 'Default', 'templatemela-core' ),
				'dropdown' => __( 'Dropdown Select', 'templatemela-core' ),
				'radio_box' => __( 'Radio Boxes', 'templatemela-core' ),
				'color_image' => __( 'Image and Color swatches', 'templatemela-core' ),
			);
			return $types;
		}
		/**
		 * Adds custom classes to indicate the button size for the single products.
		 *
		 * @param array $classes Classes for the body element.
		 * @return array Filtered body classes.
		 */
		public function single_product_body_classes( $classes ) {
			if ( is_product() ) {
				global $bt_woo_extras;
				if ( isset( $bt_woo_extras['variation_label'] ) && true == $bt_woo_extras['variation_label'] ) {
					$classes[] = 'base-sk-variation-above';
				}
			}
			return $classes;
		}
		public function bt_variation_swatches_panel_tabs() {
			?>
			<li class="bt-variation-swatches-tab show_if_variable"><a href="#bt_swatches"><span><?php echo __( 'Variation Swatches', 'templatemela-core' ); ?></span></a></li>
			<?php
		}

		public function bt_variation_swatches_panel_output() {
			?>
			<div id="bt_swatches" class="panel bt-variation-swatches-content woocommerce_options_panel wc-metaboxes-wrapper">
				<div class="bt_swatches_container">
					<div class="bt_swatches_label">
						<?php echo __( 'Product variation attributes', 'templatemela-core' ); ?> 
					</div>
					<?php $this->bt_variation_swatches_tab_output(); ?>
				</div>
			</div>
			<?php
		}

		public function bt_variation_swatches_tab_output() {
			global $woocommerce, $post, $bt_woo_extras;
			if ( function_exists( 'wc_get_product' ) ) {
				$product = wc_get_product( $post->ID );
			} else {
				$product = new WC_Product( $post->ID );
			}
			if ( ! $product->is_type( 'variable' ) && ! $product->is_type( 'variable-subscription' ) ) {
				return;
			}
			$bt_variation_swatch_type           = get_post_meta( $post->ID, '_bt_variation_swatch_type', true );
			$bt_variation_swatch_type_options   = get_post_meta( $post->ID, '_bt_variation_swatch_type_options', true );

			if ( ! $bt_variation_swatch_type_options ) {
				$bt_variation_swatch_type_options = array();
			}

			if ( ! $bt_variation_swatch_type ) {
				$bt_variation_swatch_type = array();
			}

			$var_product = new WC_Product_Variable( $post->ID );

			$attributes = $var_product->get_variation_attributes();

			if ( $attributes && count( $attributes ) ) :
				// Start foreach with the product attributres
				$attribute_names = array_keys( $attributes );
				foreach ( $attribute_names as $attribute_name ) {
					$key = md5( sanitize_title( $attribute_name ) );
					if ( isset( $bt_variation_swatch_type[ $key ]['display_type'] ) ) {
						$value = $bt_variation_swatch_type[ $key ]['display_type'];
					} else {
						$value = 'default';
					}
					if ( isset( $bt_variation_swatch_type[ $key ]['display_label'] ) ) {
						$label = $bt_variation_swatch_type[ $key ]['display_label'];
					} else {
						$label = 'default';
					}
					if ( isset( $bt_variation_swatch_type[ $key ]['display_size'] ) ) {
						$size = $bt_variation_swatch_type[ $key ]['display_size'];
					} else {
						$size = 'default';
					}
					if ( isset( $bt_woo_extras['swatches_type'] ) ) {
						$bt_default_type = $bt_woo_extras['swatches_type'];
					} else {
						$bt_default_type = 'dropdown';
					}
					if ( isset( $bt_woo_extras['swatches_size'] ) ) {
						$bt_default_size = $bt_woo_extras['swatches_size'];
					} else {
						$bt_default_size = '50';
					}
					// echo Each attribute label and swatch type.
					echo '<div class="bt_swatches_attribute_panel" data-default-type="' . $bt_default_type . '" data-default-size="' . $bt_default_size . '">';
						echo '<a class="bt_attribute_label">' . wc_attribute_label( $attribute_name ) . '</a>';
						echo '<div class="bt_attribute_panel">';
							woocommerce_wp_select(
								array(
									'id'      => '_bt_variation_swatch_type[' . $key . '][display_type]',
									'class'   => 'select short bt_select_swatches_type',
									'label'   => __( 'Variation Style', 'templatemela-core' ),
									'options' => array(
										'default'       => __( 'Default', 'templatemela-core' ),
										'dropdown'      => __( 'Dropdown', 'templatemela-core' ),
										'radio_box'     => __( 'Radio Box', 'templatemela-core' ),
										'color_image'   => __( 'Color and image swatches', 'templatemela-core' ),
										'taxonomy'      => __( 'Taxonomy defined', 'templatemela-core' ),
									),
									'value' => $value,
								)
							);
							echo '<div class="bt_attribute_extra_settings ';
					if ( $value != 'default' ) {
						echo $value == 'color_image' ? 'panel_open' : ' ';
					} else {
						echo $bt_default_type == 'color_image' ? 'panel_open' : ' ';
					}
							echo '">';
								woocommerce_wp_select(
									array(
										'id'      => '_bt_variation_swatch_type[' . $key . '][display_label]',
										'class'   => 'select short bt_select_swatches_label',
										'label'   => __( 'Display Label', 'templatemela-core' ),
										'options' => array(
											'default'       => __( 'Default', 'templatemela-core' ),
											'false'         => __( 'No label', 'templatemela-core' ),
											'above'         => __( 'Show above', 'templatemela-core' ),
											'below'         => __( 'Show below', 'templatemela-core' ),
											'tooltip'       => __( 'Show above on hover', 'templatemela-core' ),
										),
										'value' => $label,
									)
								);
								woocommerce_wp_select(
									array(
										'id'      => '_bt_variation_swatch_type[' . $key . '][display_size]',
										'label'   => __( 'Swatch Size', 'templatemela-core' ),
										'class'   => 'select short bt_select_swatches_size',
										'options' => array(
											'default'       => __( 'Default', 'templatemela-core' ),
											'16'            => __( '16x16px', 'templatemela-core' ),
											'30'            => __( '30x30px', 'templatemela-core' ),
											'40'            => __( '40x40px', 'templatemela-core' ),
											'50'            => __( '50x50px', 'templatemela-core' ),
											'60'            => __( '60x60px', 'templatemela-core' ),
											'75'            => __( '75x75px', 'templatemela-core' ),
											'90'            => __( '90x90px', 'templatemela-core' ),
											'120'           => __( '120x120px', 'templatemela-core' ),
											'150'           => __( '150x150px', 'templatemela-core' ),
										),
										'value' => $size,
									)
								);
							echo '</div>';
							// Get all attribute terms selected
							$attribute_terms = array();
					if ( taxonomy_exists( $attribute_name ) ) :
						$terms = get_terms( $attribute_name, array( 'hide_empty' => false ) );
						$selected_terms = isset( $attributes[ $attribute_name ] ) ? $attributes[ $attribute_name ] : array();
						foreach ( $terms as $term ) {
							if ( in_array( $term->slug, $selected_terms ) ) {
								$attribute_terms[] = array(
									'id' => md5( $term->slug ),
									'label' => $term->name,
								);
							}
						}
							else :
								foreach ( $attributes[ $attribute_name ] as $term ) {
									$attribute_terms[] = array(
										'id' => ( md5( sanitize_title( strtolower( $term ) ) ) ),
										'label' => esc_html( $term ),
									);
								}
							endif;
							echo '<div class="bt_swatches_attribute_table bt_swatches_clearfix ';
							if ( $value != 'default' ) {
								echo $value == 'color_image' ? 'panel_open' : ' ';
							} else {
								echo $bt_default_type == 'color_image' ? 'panel_open' : ' ';
							}
							echo '">';
								echo '<div class="bt_swatches_attribute_table_head bt_swatches_clearfix">';
									echo '<div class="bt_sa_preview">' . __( 'Preview', 'templatemela-core' ) . '</div>';
									echo '<div class="bt_sa_name">' . __( 'Attribute', 'templatemela-core' ) . '</div>';
									echo '<div class="bt_sa_type">' . __( 'Type', 'templatemela-core' ) . '</div>';
								echo '</div>';
								echo '<div class="bt_swatches_attribute_table_body bt_swatches_clearfix">';
									// Loop through terms
							foreach ( $attribute_terms as $attribute_term ) :
								$attribute_term['id'] = ( $attribute_term['id'] );
								// Get image
								if ( isset( $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['image'] ) ) {
									$this_attribute_image = $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['image'];
								} else {
									$this_attribute_image = wc_placeholder_img_src();
								}
								// get ID
								if ( isset( $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['image_id'] ) ) {
									$this_attribute_image_id = $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['image_id'];
								} else {
									$this_attribute_image_id = null;
								}
								// Get thumbnail
								if ( isset( $this_attribute_image_id ) && ! empty( $this_attribute_image_id ) ) {
									$this_attribute_image_thumb = wp_get_attachment_image_src( $this_attribute_image_id, 'thumbnail' );
									$this_attribute_image_thumb = $this_attribute_image_thumb[0];
								} else {
									$this_attribute_image_thumb = wc_placeholder_img_src();
								}
								// Get color
								if ( isset( $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['color'] ) ) {
									$this_attribute_color = $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['color'];
								} else {
									$this_attribute_color = '#ffffff';
								}
								// Get type
								if ( isset( $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['type'] ) ) {
									$this_attribute_type = $bt_variation_swatch_type_options[ $key ][ $attribute_term['id'] ]['type'];
								} else {
									$this_attribute_type = 'color';
								}
								// Get type label
								if ( $this_attribute_type == 'image' ) {
									$this_attribute_type_label = __( 'Image', 'templatemela-core' );
								} else {
									$this_attribute_type_label = __( 'Color', 'templatemela-core' );
								}
								echo '<div class="bt_swatches_attribute_single">';
									echo '<div class="bt_swatches_attribute_table_subhead bt_swatches_clearfix"';
								if ( $size == 'default' ) {
									if ( isset( $bt_woo_extras['swatch_size'] ) ) {
										echo 'style="line-height:' . esc_attr( $bt_woo_extras['swatch_size'] ) . 'px"';
									} else {
										// do nothing
									}
								} else {
									echo 'style="line-height:' . esc_attr( $size ) . 'px"';
								}
									echo '">';
										echo '<div class="bt_sas_preview">';
											echo '<div class="bt_sas_preview_item"';
								if ( $this_attribute_type == 'image' ) {
									echo 'style="background-image:url(' . $this_attribute_image_thumb . ');';
								} else {
									echo 'style="background-color:' . $this_attribute_color . ';';
								}
								if ( $size == 'default' ) {
									if ( isset( $bt_woo_extras['swatches_size'] ) ) {
										echo 'width:' . esc_attr( $bt_woo_extras['swatches_size'] ) . 'px;';
										echo 'height:' . esc_attr( $bt_woo_extras['swatches_size'] ) . 'px;';
									} else {
										// do nothing
									}
								} else {
									echo 'width:' . esc_attr( $size ) . 'px;';
									echo 'height:' . esc_attr( $size ) . 'px;';
								}
											echo '"></div>';
												echo '</div>';
												echo '<div class="bt_sas_name">' . $attribute_term['label'] . '</div>';
												echo '<div class="bt_sas_type">' . $this_attribute_type_label . '</div>';
												echo '</div>';
												echo '<div class="bt_swatches_attribute_single_options bt_swatches_clearfix">';
												echo '<div class="bt_swatches_attribute_single_row bt_sas_option_type">';
											woocommerce_wp_select(
												array(
													'id'      => '_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][type]',
													'class'   => 'select short bt_select_swatches_type_single',
													'label'   => __( 'Attribute Color or Image', 'templatemela-core' ),
													'options' => array(
														'color'         => __( 'Color', 'templatemela-core' ),
														'image'         => __( 'Image', 'templatemela-core' ),
													),
													'value' => $this_attribute_type,
												)
											);
										echo '</div>';
										echo '<div class="bt_swatches_attribute_single_row bt_sas_option_color" style="';
											echo $this_attribute_type == 'color' ? '' : 'display:none';
										echo '">';
											echo '<p class="form-field _bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][color]_field">';
												echo '<label for="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][color]">' . __( 'Color', 'templatemela-core' ) . '</label>';
												echo '<input class="bt_swatch_color" id="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][color]" type="text" class="text" name="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][color]" value="' . $this_attribute_color . '" />';
											echo '</p>';
										echo '</div>';
										echo '<div class="bt_swatches_attribute_single_row bt_sas_option_image" style="';
											echo $this_attribute_type == 'image' ? '' : 'display:none';
										echo '">';
											echo '<p class="form-field _bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image]_field">';
												echo '<label for="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image]">' . __( 'Image', 'templatemela-core' ) . '</label>';
												echo '<input class="bt_swatch_image" id="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image]" type="text" class="text" name="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image]" value="' . $this_attribute_image . '" />';
												echo '<input class="bt_swatch_image_id" id="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image_id]" type="hidden" class="text" name="_bt_variation_swatch_type_options[' . $key . '][' . $attribute_term['id'] . '][image_id]" value="' . $this_attribute_image_id . '" />';
												echo '<a class="bt_swatches_upload_button button">' . __( 'Upload/Add image', 'templatemela-core' ) . '</a>';
											echo '</p>';
										echo '</div>';
									echo '</div>';
								echo '</div>';
									endforeach;
								echo '</div>';
							echo '</div>';
							echo '</div>';
							echo '</div>';

				}

			endif;
		}

		public function bt_variation_swatches_process_meta( $post_id, $post ) {
			if ( isset( $_POST['_bt_variation_swatch_type'] ) ) {
				update_post_meta( $post_id, '_bt_variation_swatch_type', $_POST['_bt_variation_swatch_type'] );
			}
			if ( isset( $_POST['_bt_variation_swatch_type_options'] ) ) {
				update_post_meta( $post_id, '_bt_variation_swatch_type_options', $_POST['_bt_variation_swatch_type_options'] );
			}

		}
		public function bt_variation_swatches_enqueue_scripts() {
			if ( apply_filters( 'base_shop_kit_swatches_scripts_enqueue', true ) ) {
				if ( wp_script_is( 'bt-wc-add-to-cart-variation', 'enqueued' ) ) {
					wp_dequeue_script( 'bt-wc-add-to-cart-variation' );
				}
				if ( wp_script_is( 'bt-add-to-cart-variation-radio', 'enqueued' ) ) {
					wp_dequeue_script( 'bt-add-to-cart-variation-radio' );
				}
				wp_deregister_script( 'bt-add-to-cart-variation-radio' );
				wp_enqueue_style( 'base_variation_swatches_css', TMCORE_WOO_URL . 'lib/swatches/css/bt_variation_swatches.css', false, TMCORE_VERSION );
				wp_register_script( 'base_variation_swatches', TMCORE_WOO_URL . 'lib/swatches/js/bt_variation_swatches.js', array( 'jquery' ), TMCORE_VERSION, true );
				wp_enqueue_script( 'base_variation_swatches' );
			}
		}
		public function bt_variation_swatches_admin_enqueue_scripts() {
			global $pagenow;
			if ( is_admin() && ( $pagenow == 'post-new.php' || $pagenow == 'post.php' || $pagenow == 'edit.php' || 'edit-tags.php' ) ) {
				wp_enqueue_media();
				wp_enqueue_style( 'wp-color-picker' );
				wp_enqueue_style( 'base_admin_swatches_css', TMCORE_WOO_URL . 'lib/swatches/css/bt_admin_swatches.css', false, TMCORE_VERSION );
				wp_register_script( 'base_admin_swatches', TMCORE_WOO_URL . 'lib/swatches/js/bt_admin_swatches.js', array( 'jquery', 'wp-color-picker' ), TMCORE_VERSION, true );
				wp_enqueue_script( 'base_admin_swatches' );
			}
		}
		public function bt_woo_extras_register_taxonomy_meta_boxes() {
			if ( ! class_exists( 'TemplateMelaCore_Taxonomy_Meta' ) ) {
				return;
			}

			$meta_sections = array();
			$prefix = 'bt_woo_extras_';
			if ( function_exists( 'wc_get_attribute_taxonomies' ) ) {
				$attributes = wc_get_attribute_taxonomies();
				$attribute_array = array();
				foreach ( $attributes as $tax ) {
					$attribute_array[] = 'pa_' . $tax->attribute_name;
				}
				// First meta section
				$meta_sections[] = array(
					'title'      => 'Swatch Taxonomy Image or Color Setup',
					'taxonomies' => $attribute_array,
					'id'         => 'bt_woo_extras_tax_swatch_type',

					'fields' => array(
						array(
							'name'    => __( 'Swatch Type', 'templatemela-core' ),
							'id'      => $prefix . 'swatch_type',
							'type'    => 'select',
							'options' => array(
								'color' => __( 'Color', 'templatemela-core' ),
								'image' => __( 'Image', 'templatemela-core' ),
							),
						),
						array(
							'name' => __( 'Swatch Color', 'templatemela-core' ),
							'id'   => $prefix . 'swatch_color',
							'type' => 'color',
						),
						array(
							'name' => __( 'Swatch Image', 'templatemela-core' ),
							'id' => $prefix . 'swatch_image',
							'type' => 'image',
						),
					),
				);

				foreach ( $meta_sections as $meta_section ) {
					new TemplateMelaCore_Taxonomy_Meta( $meta_section );
				}
			}
		}

	}
	$GLOBALS['bt_variation_swatches'] = new bt_variation_swatches();
}

