<?php
/**
 * This overrides woocommerce.
 *
 * @package Base Woo Extras
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Class to build out snackbar notices.
 *
 * @category class
 */
class Base_Shop_Kit_Snackbar_Notice {

	/**
	 * Instance of this class
	 *
	 * @var null
	 */
	private static $instance = null;

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Build snackbar.
	 */
	public function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'enqueue_scripts' ), 150 );
	}
	/**
	 * Add in the snackbar scripts and styles.
	 */
	public function enqueue_scripts() {
		$add = false;
		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}
		if ( is_cart() ) {
			if ( isset( $shopkit_settings['snackbar_cart'] ) && true === $shopkit_settings['snackbar_cart'] ) {
				$add = true;
			}
		} elseif ( is_checkout() ) {
			if ( isset( $shopkit_settings['snackbar_checkout'] ) && true === $shopkit_settings['snackbar_checkout'] ) {
				$add = true;
			}
		} else {
			$add = true;
		}
		if ( $add ) {
			wp_enqueue_style( 'base-snackbar-notice', TMCORE_WOO_URL . 'lib/snackbar/css/base-snackbar-notice.css', false, TMCORE_VERSION );
			if ( is_cart() || is_checkout() ) {
				wp_enqueue_script( 'base-snackbar-notice-cart', TMCORE_WOO_URL . 'lib/snackbar/js/min/base-snackbar-notice-cart.min.js', array( 'jquery' ), TMCORE_VERSION, true );
				$snackbar_translation_array = array(
					'close'    => __( 'Dismiss Notice', 'templatemela-core' ),
				);
				wp_localize_script( 'base-snackbar-notice-cart', 'base_wsb', $snackbar_translation_array );
			} else {
				wp_enqueue_script( 'base-snackbar-notice', TMCORE_WOO_URL . 'lib/snackbar/js/min/base-snackbar-notice.min.js', array(), TMCORE_VERSION, true );
				$snackbar_translation_array = array(
					'close'    => __( 'Dismiss Notice', 'templatemela-core' ),
				);
				wp_localize_script( 'base-snackbar-notice', 'base_wsb', $snackbar_translation_array );
			}
		}
	}
}
Base_Shop_Kit_Snackbar_Notice::get_instance();
