<?php
// This overrides woocommerce
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

add_action( 'after_setup_theme', 'bt_size_chart_plugin_loaded' );

function bt_size_chart_plugin_loaded() {

	class bt_size_chart {

		public function __construct() {
			add_action( 'init', array( $this, 'bt_woo_size_chart_post' ), 10 );
			if ( is_admin() ) {
				add_action( 'do_meta_boxes', array( $this, 'bt_woo_remove_revolution_slider_meta_boxes' ), 10 );
			}
			require_once TMCORE_WOO_PATH . 'lib/sizechart/class-size-chart-widget.php';
			add_action( 'admin_menu', array( $this, 'bt_size_chart_menu' ) );
			add_filter( 'cmb2_admin_init', array( $this, 'bt_woo_size_chart_metaboxes' ) );
			add_action( 'wp_enqueue_scripts', array( $this, 'bt_size_chart_enqueue_scripts' ) );
			add_action( 'woocommerce_before_single_product', array( $this, 'bt_product_size_chart' ) );
			add_action( 'widgets_init', array( $this, 'widgets_init' ) );
			add_shortcode( 'bt_size_chart', array( $this, 'output_shortcode' ) );

		}
		public function bt_size_chart_enqueue_scripts() {
			if ( is_singular( 'product' ) ) {
				wp_enqueue_style( 'base_size_chart_css', TMCORE_WOO_URL . 'lib/sizechart/css/bt_size_chart.css', false, TMCORE_VERSION );
				wp_enqueue_script( 'base-modal', TMCORE_WOO_URL . 'lib/sizechart/js/min/bt-modal-init.min.js', array(), TMCORE_VERSION, true );
				// wp_register_script( 'base_size_chart', TMCORE_WOO_URL . 'lib/sizechart/js/min/bt_size_chart-min.js', array( 'jquery' ), TMCORE_VERSION, true );
				// wp_enqueue_script( 'base_size_chart' );
			}
			add_filter( 'bt_size_chart_content', 'do_blocks', 9 );
			add_filter( 'bt_size_chart_content', 'wptexturize' );
			add_filter( 'bt_size_chart_content', 'convert_smilies' );
			add_filter( 'bt_size_chart_content', 'convert_chars' );
			add_filter( 'bt_size_chart_content', 'wpautop' );
			add_filter( 'bt_size_chart_content', 'shortcode_unautop' );
			add_filter( 'bt_size_chart_content', 'prepend_attachment' );
		}
		public function widgets_init() {
			if ( class_exists( 'Base_Woo_Template_Builder' ) ) {
				register_widget( 'kwt_size_chart_widget' );
			}
		}
		public function bt_woo_size_chart_post() {
			$sizechartlabels = array(
				'name'               => __( 'Size Chart', 'templatemela-core' ),
				'singular_name'      => __( 'Size Chart Item', 'templatemela-core' ),
				'add_new'            => __( 'Add New Chart', 'templatemela-core' ),
				'add_new_item'       => __( 'Add New Chart', 'templatemela-core' ),
				'edit_item'          => __( 'Edit Chart', 'templatemela-core' ),
				'new_item'           => __( 'New Chart', 'templatemela-core' ),
				'all_items'          => __( 'All Charts', 'templatemela-core' ),
				'view_item'          => __( 'View Chart', 'templatemela-core' ),
				'search_items'       => __( 'Search Chart', 'templatemela-core' ),
				'not_found'          => __( 'No Chart found', 'templatemela-core' ),
				'not_found_in_trash' => __( 'No Charts found in Trash', 'templatemela-core' ),
				'parent_item_colon'  => '',
				'menu_name'          => __( 'Size Chart', 'templatemela-core' ),
			);

			$chartargs = array(
				'labels'              => $sizechartlabels,
				'public'              => true,
				'show_ui'             => true,
				'exclude_from_search' => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'rewrite'             => false,
				'has_archive'         => false,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'menu_position'       => null,
				'show_in_rest'        => true,
				'menu_icon'           => 'dashicons-media-spreadsheet',
				'supports'            => array( 'title', 'editor' ),
			);

			register_post_type( 'bt_size_chart', $chartargs );
		}
		public function bt_size_chart_menu() {
			add_submenu_page(
				'edit.php?post_type=product',
				__( 'Size Chart', 'templatemela-core' ),
				__( 'Size Charts', 'templatemela-core' ),
				'manage_woocommerce',
				'edit.php?post_type=bt_size_chart',
				false
			);
		}
		public function bt_woo_remove_revolution_slider_meta_boxes() {
			remove_meta_box( 'mymetabox_revslider_0', 'bt_size_chart', 'normal' );
		}

		public function bt_woo_hex2rgb( $hex ) {
			$hex = str_replace( '#', '', $hex );

			if ( strlen( $hex ) == 3 ) {
				$r = hexdec( substr( $hex, 0, 1 ) . substr( $hex, 0, 1 ) );
				$g = hexdec( substr( $hex, 1, 1 ) . substr( $hex, 1, 1 ) );
				$b = hexdec( substr( $hex, 2, 1 ) . substr( $hex, 2, 1 ) );
			} else {
				$r = hexdec( substr( $hex, 0, 2 ) );
				$g = hexdec( substr( $hex, 2, 2 ) );
				$b = hexdec( substr( $hex, 4, 2 ) );
			}
			$rgb = array( $r, $g, $b );
			// return implode(",", $rgb); // returns the rgb values separated by commas
			return $rgb; // returns an array with the rgb values
		}
		public function bt_product_size_chart() {
			global $post, $bt_woo_extras;
			$chart_id = get_post_meta( $post->ID, '_bt_woo_size_chart_assign', true );
			if ( ! empty( $chart_id ) && $chart_id != '0' ) {
				$chartid = $chart_id;
			} else {
				$chartid = $this->get_size_chart_from_cat( $post->ID );
			}
			if ( ! empty( $chartid ) && $chartid != false ) {
				$chart_placement = get_post_meta( $chartid, '_bt_woo_size_placement', true );
				if ( $chart_placement == 'aftercart' ) {
					add_action( 'woocommerce_after_add_to_cart_form', array( $this, 'size_chart_output' ), 10 );
				} elseif ( $chart_placement == 'beforecart' ) {
					add_action( 'woocommerce_before_add_to_cart_button', array( $this, 'size_chart_before_cart' ), 10 );
				} elseif ( $chart_placement == 'afterdesc' ) {
					add_action( 'woocommerce_single_product_summary', array( $this, 'size_chart_output' ), 25 );
					add_action( 'base_after_short_description_block', array( $this, 'size_chart_output' ), 15 );
				} elseif ( $chart_placement == 'beforedesc' ) {
					add_action( 'woocommerce_single_product_summary', array( $this, 'size_chart_output' ), 15 );
					add_action( 'base_before_short_description_block', array( $this, 'size_chart_output' ), 15 );
				} elseif ( $chart_placement == 'aftermeta' ) {
					add_action( 'woocommerce_single_product_summary', array( $this, 'size_chart_output' ), 45 );
					add_action( 'base_after_product_meta_block', array( $this, 'size_chart_output' ), 15 );
				} elseif ( $chart_placement == 'builder' ) {
					add_action( 'base_woocommerce_builder_sizechart', array( $this, 'size_chart_output' ), 45 );
				} elseif ( $chart_placement == 'after_attribute' ) {
					add_filter( 'woocommerce_dropdown_variation_attribute_options_html', array( $this, 'size_chart_after_attribute' ), 90, 2 );
				} elseif ( $chart_placement == 'before_attribute' ) {
					if ( isset( $bt_woo_extras['variation_label'] ) && true == $bt_woo_extras['variation_label'] ) {
						add_filter( 'base_variation_attribute_label_html', array( $this, 'size_chart_after_attribute' ), 90, 2 );
					} else {
						if ( isset( $bt_woo_extras['variation_swatches'] ) && true == $bt_woo_extras['variation_swatches'] ) {
							add_filter( 'base_variation_attribute_options_html_before', array( $this, 'size_chart_before_attribute' ), 90, 2 );
						} else {
							add_filter( 'woocommerce_dropdown_variation_attribute_options_html', array( $this, 'size_chart_before_attribute' ), 90, 2 );
						}
					}
				} elseif ( $chart_placement == 'tab' ) {
					add_filter( 'woocommerce_product_tabs', array( $this, 'size_chart_tab' ) );
				}
			}
		}
		/**
		 * Add Size Chart before cart.
		 */
		public function size_chart_before_cart() {
			echo '<div class="bt-size-chart-btn-wrap">' . $this->size_chart_output( null, false, false ) . '</div>';
		}
		/**
		 * Add Size Chart before attribute select
		 *
		 * @param string $html the product select.
		 * @param array  $args the select args.
		 */
		public function size_chart_before_attribute( $html, $args ) {
			global $post;
			$chart_id = get_post_meta( $post->ID, '_bt_woo_size_chart_assign', true );
			if ( ! empty( $chart_id ) && $chart_id != '0' ) {
				$chartid = $chart_id;
			} else {
				$chartid = $this->get_size_chart_from_cat( $post->ID );
			}
			if ( ! empty( $chartid ) && ! empty( $args['attribute'] ) ) {
				$attribute = get_post_meta( $chartid, '_bt_woo_chart_attribute_placement', true );
				if ( $attribute === $args['attribute'] ) {
					$html = '<div class="bt-size-chart-attribute">' . $this->size_chart_output( $chartid, false, false ) . '</div>' . $html;
				}
			}
			return $html;
		}
		/**
		 * Add Size Chart after attribute select
		 *
		 * @param string $html the product select.
		 * @param array  $args the select args.
		 */
		public function size_chart_after_attribute( $html, $args ) {
			global $post;
			$chart_id = get_post_meta( $post->ID, '_bt_woo_size_chart_assign', true );
			if ( ! empty( $chart_id ) && $chart_id != '0' ) {
				$chartid = $chart_id;
			} else {
				$chartid = $this->get_size_chart_from_cat( $post->ID );
			}
			if ( ! empty( $chartid ) && ! empty( $args['attribute'] ) ) {
				$attribute = get_post_meta( $chartid, '_bt_woo_chart_attribute_placement', true );
				if ( $attribute === $args['attribute'] ) {
					$html .= '<div class="bt-size-chart-attribute">' . $this->size_chart_output( $chartid, false, false ) . '</div>';
				}
			}
			return $html;
		}
		/**
		 * Output Shortcode
		 *
		 * @param array $atts shortcode attributes
		 */
		public function output_shortcode( $atts ) {
			$chart = shortcode_atts(
				array(
					'id' => '',
				),
				$atts
			);
			ob_start();
			$this->size_chart_output( $chart['id'] );
			$output = ob_get_clean();
			return '<div class="bt_size_chart_shortcode">' . $output . '</div>';
		}
		/**
		 * Output chart
		 *
		 * @param string $id specific chart id.
		 */
		public function size_chart_output( $id = null, $echo = true, $button = true ) {
			global $product;
			if ( ! empty( $id ) ) {
				$chartid = $id;
			} else {
				if ( isset( $product ) && ! empty( $product ) ) {
					$chart_id = get_post_meta( $product->get_id(), '_bt_woo_size_chart_assign', true );
					if ( ! empty( $chart_id ) && '0' != $chart_id ) {
						$chartid = $chart_id;
					} else {
						$chartid = $this->get_size_chart_from_cat( $product->get_id() );
					}
				} else {
					$chartid = '';
				}
			}
			if ( empty( $chartid ) || false === $chartid ) {
				return '';
			}
			$btn_text             = get_post_meta( $chartid, '_bt_woo_btn_text', true );
			$modal_title          = get_post_meta( $chartid, '_bt_woo_modal_title', true );
			$modal_close_text     = get_post_meta( $chartid, '_bt_woo_modal_close_text', true );
			$btn_color            = get_post_meta( $chartid, '_bt_woo_btn_txt_color', true );
			$btn_background       = get_post_meta( $chartid, '_bt_woo_btn_background_color', true );
			$btn_color_hover      = get_post_meta( $chartid, '_bt_woo_btn_txt_color_hover', true );
			$btn_background_hover = get_post_meta( $chartid, '_bt_woo_btn_background_color_hover', true );
			$btn_border           = get_post_meta( $chartid, '_bt_woo_btn_border', true );
			$btn_radius           = get_post_meta( $chartid, '_bt_woo_btn_radius', true );
			$btn_border_color     = get_post_meta( $chartid, '_bt_woo_btn_border_color', true );
			$btn_border_hover     = get_post_meta( $chartid, '_bt_woo_btn_border_color_hover', true );
			$responsive_table     = get_post_meta( $chartid, '_bt_woo_responsive_table', true );
			$title_color          = get_post_meta( $chartid, '_bt_woo_header_txt_color', true );
			$content_color        = get_post_meta( $chartid, '_bt_woo_content_txt_color', true );
			$background_color     = get_post_meta( $chartid, '_bt_woo_background_color', true );
			$b_overlay_color      = get_post_meta( $chartid, '_bt_woo_background_overlay_color', true );
			$elementor_page       = get_post_meta( $chartid, '_elementor_edit_mode', true );
			if ( ! empty( $btn_radius ) ) {
				$btn_radius = 'border-radius:' . $btn_radius . 'px;';
			} else {
				$btn_radius = '';
			}
			if ( ! empty( $btn_border ) ) {
				$btn_border = 'border-width:' . $btn_border . 'px;';
			} else {
				$btn_border = '';
			}
			if ( ! empty( $b_overlay_color ) ) {
				$b_overlay_color = $this->bt_woo_hex2rgb( $b_overlay_color );
				$b_overlay_color = 'rgba(' . $b_overlay_color[0] . ', ' . $b_overlay_color[1] . ', ' . $b_overlay_color[2] . ', 0.5);';
				$b_overlay_color = 'background:' . $b_overlay_color;
			} else {
				$b_overlay_color = 'background: rgba(0,0,0,.5)';
			}
			if ( ! empty( $background_color ) ) {
				$background_color = 'background:' . $background_color;
			} else {
				$background_color = '';
			}
			if ( ! empty( $content_color ) ) {
				$content_color = 'color:' . $content_color;
			} else {
				$content_color = '';
			}
			if ( ! empty( $title_color ) ) {
				$title_color = 'color:' . $title_color;
			} else {
				$title_color = '';
			}
			if ( isset( $responsive_table ) && $responsive_table == 'false' ) {
				$table_class = 'bt-size-table-nonresponsive';
			} else {
				$table_class = 'bt-size-table-responsive';
			}
			if ( empty( $modal_close_text ) ) {
				$modal_close_text = __( 'Close', 'bt_woo_extras' );
			}
			if ( empty( $btn_text ) ) {
				$btn_text = __( 'Size Chart', 'bt_woo_extras' );
			}
			// $js_out = 'onMouseOver="';
			// if ( ! empty( $btn_background_hover ) ) {
			// 	$js_out .= 'this.style.background=\'' . esc_attr( $btn_background_hover ) . '\'';
			// }
			// if ( ! empty( $btn_background_hover ) && ( ! empty( $btn_color_hover ) || ! empty( $btn_border_hover ) ) ) {
			// 	$js_out .= ',';
			// }
			// if ( ! empty( $btn_color_hover ) ) {
			// 	$js_out .= 'this.style.color=\'' . esc_attr( $btn_color_hover ) . '\'';
			// }
			// if ( ! empty( $btn_color_hover ) && ! empty( $btn_border_hover ) ) {
			// 	$js_out .= ',';
			// }
			// if ( ! empty( $btn_border_hover ) ) {
			// 	$js_out .= 'this.style.borderColor=\'' . esc_attr( $btn_border_hover ) . '\'';
			// }
			// $js_out .= '" onMouseOut="';
			// if ( ! empty( $btn_background ) ) {
			// 	$js_out .= 'this.style.background=\'' . esc_attr( $btn_background ) . '\'';
			// 	$backcolor = $btn_background;
			// } else {
			// 	$js_out .= 'this.style.background=\'#777\'';
			// 	$backcolor = '#777';
			// }
			// if ( ! empty( $btn_color ) ) {
			// 	$js_out .= ',this.style.color=\'' . esc_attr( $btn_color ) . '\'';
			// 	$color = $btn_color;
			// } else {
			// 	$js_out .= ',this.style.color=\'#fff\'';
			// 	$color = '#fff';
			// }
			// if ( ! empty( $btn_border_color ) ) {
			// 	$js_out .= ',this.style.borderColor=\'' . esc_attr( $btn_border_color ) . '\'';
			// 	$border_color = $btn_border_color;
			// } else {
			// 	$js_out .= ',this.style.borderColor=\'transparent\'';
			// 	$border_color = 'transparent';
			// }
			// $js_out .= '"';
			if ( $button ) {
				$html_tag = 'button';
			} else {
				$html_tag = 'a';
			}
			ob_start();
			//echo '<' . esc_attr( $html_tag ) . ' class="bas-btn bt-size-btn wp-block-button__link bas-btn-primary bt-modal-btn" style="background-color:' . esc_attr( $backcolor ) . '; color:' . esc_attr( $color) . '; border-color:' . esc_attr( $border_color ) . '; ' . esc_attr( $btn_border ) . ' ' . esc_attr( $btn_radius ) . '" data-modal-open="bt-modal-' . esc_attr( $chartid ) . '" ' . $js_out . '>' . esc_html( $btn_text ) . '</' . esc_attr( $html_tag ) . '>';
			echo '<' . esc_attr( $html_tag ) . ' class="bas-btn bt-size-btn wp-block-button__link bas-btn-primary bt-modal-btn" data-modal-open="bt-modal-' . esc_attr( $chartid ) . '">' . esc_html( $btn_text ) . '</' . esc_attr( $html_tag ) . '>';
			$output = ob_get_contents();
			ob_end_clean();
			// Output content.
			ob_start(); ?>
				<div class="bt-size-modal <?php echo esc_attr( $table_class ); ?>" id="bt-modal-<?php echo esc_attr( $chartid ); ?>" tabindex="-1" role="dialog" aria-labelledby="#bt-modal-label-<?php echo esc_attr( $chartid ); ?>" aria-hidden="true">
					<div class="bt-modal-overlay" tabIndex="-1" data-modal-close style="<?php echo esc_attr( $b_overlay_color ); ?>">
						<div class="modal-dialog">
						<div class="modal-content" style="<?php echo esc_attr( $background_color ); ?>">
							<div class="modal-header">
							<button type="button" class="close" data-modal-close aria-hidden="true"></button>
							<div style="<?php echo esc_attr( $title_color ); ?>" class="modal-title" id="bt-modal-label-<?php echo esc_attr( $chartid ); ?>"><?php echo ( ! empty( $modal_title ) ? $modal_title : get_the_title( $chartid ) ); ?></div>
							</div>
							<div class="modal-body" style="<?php echo esc_attr( $content_color ); ?>">
							<?php
							if ( $elementor_page && is_callable( 'Elementor\Plugin::instance' ) ) {
								$elementor_instance = Elementor\Plugin::instance();
								echo $elementor_instance->frontend->get_builder_content_for_display( $chartid );
							} else {
								echo apply_filters( 'bt_size_chart_content', do_shortcode( get_post_field( 'post_content', $chartid ) ) );
							}
							?>
							</div>
							
						</div>
						</div>
					</div>
				</div>
			<?php
			$modal_output = ob_get_contents();
			ob_end_clean();
			add_action(
				'wp_footer',
				function() use( $modal_output, $chartid ) {
					echo '<!-- [size-chart-modal-' . esc_attr( $chartid ) . '] -->';
					echo apply_filters( 'base_shopkit_size_chart_modal_output', $modal_output );
					echo '<!-- [/size-chart-modal-' . esc_attr( $chartid ) . '] -->';
				},
				9
			);
			if ( $echo ) {
				echo $output;
			} else {
				return $output;
			}
		}
		public function size_chart_tab_content() {
			global $post;
			$chart_id = get_post_meta( $post->ID, '_bt_woo_size_chart_assign', true );
			if ( ! empty( $chart_id ) && $chart_id != '0' ) {
				$chartid = $chart_id;
			} else {
				$chartid = $this->get_size_chart_from_cat( $post->ID );
			}
			if ( ! empty( $chartid ) && $chartid != false ) {
				$responsive_table = get_post_meta( $chartid, '_bt_woo_responsive_table', true );
			}
			if ( isset( $responsive_table ) && $responsive_table == false ) {
				$table_class = 'bt-size-table-nonresponsive';
			} else {
				$table_class = 'bt-size-table-responsive';
			}
			echo '<div class="' . esc_attr( $table_class ) . ' size_chart_tab_content">';
			echo apply_filters( 'bt_size_chart_content', get_post_field( 'post_content', $chartid ) );
			echo '</div>';
		}
		public function size_chart_tab( $tabs ) {
			global $post;
			$chart_id = get_post_meta( $post->ID, '_bt_woo_size_chart_assign', true );
			if ( ! empty( $chart_id ) && $chart_id != '0' ) {
				$chartid = $chart_id;
			} else {
				$chartid = $this->get_size_chart_from_cat( $post->ID );
			}
			$priority = get_post_meta( $chartid, '_bt_woo_tab_priority', true );
			$label = get_post_meta( $chartid, '_bt_woo_tab_label', true );
			if ( ! empty( $label ) ) {
				$tab_label = $label;
			} else {
				$tab_label = get_the_title( $chartid );
			}
			if ( ! empty( $priority ) ) {
				$tab_priority = $priority;
			} else {
				$tab_priority = 35;
			}
			$tabs['bt_size_chart_tab'] = array(
				'title' => $tab_label,
				'priority' => $tab_priority,
				'callback' => array( $this, 'size_chart_tab_content' ),
			);
			return $tabs;
		}
		/**
		 * Output Shortcode
		 *
		 * @param string $id Post ID.
		 */
		public function get_size_chart_from_cat( $id ) {
			$product_cats   = wp_get_post_terms( $id, 'product_cat' );
			$pterms         = array();
			$final_chart_id = false;
			if ( $product_cats && ! is_wp_error( $product_cats ) ) {
				foreach ( $product_cats as $product_cat ) {
					$pterms[] = $product_cat->term_id;
				}
			}
			if ( empty( $pterms ) ) {
				return false;
			}
			$charts = get_posts(
				array(
					'post_type'      => 'bt_size_chart',
					'posts_per_page' => '100',
					'posts_status'   => 'publish',
					'orderby'        => 'ID',
					'order'          => 'DESC',
				)
			);
			if ( ! empty( $charts ) ) {
				foreach ( $charts as $chart ) {
					$chart_cats = get_the_terms( $chart->ID, 'product_cat' );
					$cterms     = array();
					if ( $chart_cats && ! is_wp_error( $chart_cats ) ) {
						foreach ( $chart_cats as $chart_cat ) {
							$cterms[] = $chart_cat->term_id;
						}
					}
					if ( ! empty( $cterms ) ) {
						if ( is_array( $cterms ) && is_array( $pterms ) ) {
							if ( array_intersect( $pterms, $cterms ) ) {
								$final_chart_id = $chart->ID;
							}
							if ( false !== $final_chart_id ) {
								break;
							}
						}
					}
				}
			}
			return $final_chart_id;
		}

		public function bt_woo_size_chart_metaboxes() {

			$prefix = '_bt_woo_';
			$bt_woo_size_chart = new_cmb2_box(
				array(
					'id'            => $prefix . 'size_chart',
					'title'         => __( 'Size Chart Settings', 'templatemela-core' ),
					'object_types'  => array( 'bt_size_chart' ), // Post type
				)
			);
			$placement_options = array(
				'aftercart'     => __( 'Button after "add to cart"', 'templatemela-core' ),
				'beforecart'    => __( 'Button before "add to cart"', 'templatemela-core' ),
				'afterdesc'     => __( 'Button after "product short description"', 'templatemela-core' ),
				'beforedesc'    => __( 'Button before "product short description"', 'templatemela-core' ),
				'before_attribute' => __( 'Before Attribute Selection', 'templatemela-core' ),
				'after_attribute' => __( 'After Attribute Selection', 'templatemela-core' ),
				'aftermeta'     => __( 'Button after "product meta"', 'templatemela-core' ),
				'tab'           => __( 'Add as Tab, no button', 'templatemela-core' ),
				'builder'       => __( 'None', 'templatemela-core' ),
			);
			$attributes = wc_get_attribute_taxonomies();
			$attribute_options = array();
			if ( ! empty( $attributes ) && is_array( $attributes ) ) {
				foreach ( $attributes as $attribute ) {
					$name = wc_attribute_taxonomy_name( $attribute->attribute_name );
					if ( 'select' === $attribute->attribute_type && $name ) {
						$attribute_options[ $name ] = $attribute->attribute_label;
					}
				}
			}
			if ( class_exists( 'Base_Woo_Template_Builder' ) ) {
				$placement_options['builder'] = __( 'Template builder widget', 'templatemela-core' );
			}
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Placement', 'templatemela-core' ),
					'id'            => $prefix . 'size_placement',
					'type'          => 'select',
					'options'          => $placement_options,
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'      => __( 'Chart Attribute Selection', 'templatemela-core' ),
					'desc'      => __( 'Select the attribute this chart should appear with', 'templatemela-core' ),
					'id'        => $prefix . 'chart_attribute_placement',
					'type'      => 'select',
					'options'          => $attribute_options,
					'attributes' => array(
						'data-base-condition-id'    =>  $prefix . 'size_placement',
						'data-base-condition-value' => 'after_attribute,before_attribute',
					),
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Title Color', 'templatemela-core' ),
					'id'            => $prefix . 'header_txt_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Text Color', 'templatemela-core' ),
					'id'            => $prefix . 'content_txt_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Background Color', 'templatemela-core' ),
					'id'            => $prefix . 'background_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Overlay Background Color', 'templatemela-core' ),
					'id'            => $prefix . 'background_overlay_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Text Color', 'templatemela-core' ),
					'id'            => $prefix . 'btn_txt_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Hover Text Color', 'templatemela-core' ),
					'id'            => $prefix . 'btn_txt_color_hover',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Background', 'templatemela-core' ),
					'id'            => $prefix . 'btn_background_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Hover Background', 'templatemela-core' ),
					'id'            => $prefix . 'btn_background_color_hover',
					'type'          => 'colorpicker',
					'attributes' => array(
						'data-colorpicker' => json_encode(
							array(
								// Iris Options set here as values in the 'data-colorpicker' array
								'color' => true,
							)
						),
					),
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Border Radius', 'templatemela-core' ),
					'id'            => $prefix . 'btn_radius',
					'default'       => '0',
					'type'          => 'bt_woo_text_number',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Border Width', 'templatemela-core' ),
					'id'            => $prefix . 'btn_border',
					'default'       => '0',
					'type'          => 'bt_woo_text_number',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Border Color', 'templatemela-core' ),
					'id'            => $prefix . 'btn_border_color',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Hover Border Color', 'templatemela-core' ),
					'id'            => $prefix . 'btn_border_color_hover',
					'type'          => 'colorpicker',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Button Text', 'templatemela-core' ),
					'id'            => $prefix . 'btn_text',
					'type'          => 'text',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal Heading Title', 'templatemela-core' ),
					'id'            => $prefix . 'modal_title',
					'type'          => 'text',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'Modal "Close" Text', 'templatemela-core' ),
					'id'            => $prefix . 'modal_close_text',
					'type'          => 'text',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'If tab, set priority', 'templatemela-core' ),
					'desc'      => __( 'This determines where the tab is placed in your product tabs', 'templatemela-core' ),
					'id'            => $prefix . 'tab_priority',
					'default'       => '35',
					'type'          => 'bt_woo_text_number',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'          => __( 'If tab, set tab label', 'templatemela-core' ),
					'desc'      => __( 'This sets the label for the tab.', 'templatemela-core' ),
					'id'            => $prefix . 'tab_label',
					'type'          => 'text',
				)
			);
			$bt_woo_size_chart->add_field(
				array(
					'name'      => __( 'Chart Categories', 'templatemela-core' ),
					'desc'      => __( 'Select categories for chart to auto appear on', 'templatemela-core' ),
					'id'        => $prefix . 'chart_cats',
					'type'      => 'taxonomy_multicheck',
					'taxonomy'  => 'product_cat', // Taxonomy Slug
					'inline'    => true, // Toggles display to inline
				)
			);
			if ( base_woo_extras_is_classic_editor_active() ) {
				$bt_woo_size_chart->add_field(
					array(
						'name'          => __( 'Responsive tables?', 'templatemela-core' ),
						'id'            => $prefix . 'responsive_table',
						'desc'      => __( 'This adds css to attempt to make any html tables responsive.', 'templatemela-core' ),
						'type'          => 'select',
						'options'          => array(
							'true'     => __( 'True', 'templatemela-core' ),
							'false'    => __( 'False', 'templatemela-core' ),
						),
					)
				);
			}

			$bt_woo_size_chart_list  = new_cmb2_box(
				array(
					'id'            => $prefix . 'size_chart_list',
					'title'         => __( 'Product Size Chart', 'templatemela-core' ),
					'object_types'  => array( 'product' ),
					'context'    => 'side',
					'priority'   => 'low',
				)
			);
			$bt_woo_size_chart_list->add_field(
				array(
					'name'          => __( 'Assign Size Chart', 'templatemela-core' ),
					'desc'      => __( 'Choose a size chart to assign to product.', 'templatemela-core' ),
					'id'            => $prefix . 'size_chart_assign',
					'type'          => 'select',
					'default'       => '0',
					'options_cb'    => 'bt_woo_size_chart_posts_options',
				)
			);

		}
	}

	$GLOBALS['bt_size_chart'] = new bt_size_chart();
}
