<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
add_action( 'after_setup_theme', 'bt_add_to_cart_text_plugin_loaded' );

function bt_add_to_cart_text_plugin_loaded() {

	class bt_add_to_cart_text {

		public function __construct() {
			add_filter( 'woocommerce_product_add_to_cart_text', array( $this, 'bt_add_to_cart_text' ), 15, 2 );
			add_filter( 'woocommerce_product_single_add_to_cart_text', array( $this, 'bt_single_add_to_cart_text' ), 10, 2 );
		}
		public function bt_single_add_to_cart_text( $text, $product ) {
			global $bt_woo_extras;
			if ( !empty($bt_woo_extras['single_add_to_cart_text'] ) && !$product->is_type( 'external' ) ) {
				return $bt_woo_extras['single_add_to_cart_text'];
			}

			return $text;

		}

		public function bt_add_to_cart_text( $text, $product ) {
			global $bt_woo_extras;
			// out of stock
			if ( !empty($bt_woo_extras['out_add_to_cart_text'] ) && !$product->is_in_stock() ) {

				return $bt_woo_extras['out_add_to_cart_text'];
			}

			if ( !empty($bt_woo_extras['add_to_cart_text'] ) && $product->is_type( 'simple' ) ) {
				// simple 
				return $bt_woo_extras['add_to_cart_text'];

			} elseif ( !empty($bt_woo_extras['variable_add_to_cart_text'] ) && $product->is_type( 'variable') )  {

				// variable 
				return $bt_woo_extras['variable_add_to_cart_text'];

			} elseif ( !empty($bt_woo_extras['grouped_add_to_cart_text'] ) && $product->is_type( 'grouped' ) ) {

				// grouped 
				return $bt_woo_extras['grouped_add_to_cart_text'];

			}

			return $text;
		}

	}
	$GLOBALS['bt_add_to_cart_text'] = new bt_add_to_cart_text();
}

