<?php
/**
 * Custom Functions
 *
 * @package Base Woo Extras.
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * Checks if Theme is Base is enabled
 */
function theme_is_themename() {
	if ( class_exists( 'Base_API_Manager' ) ) {
		return true;
	}
	return false;
}

function bt_woo_get_srcset( $width, $height, $url, $id ) {
	if ( empty( $id ) || empty( $url ) ) {
		return;
	}
	$image_meta = get_post_meta( $id, '_wp_attachment_metadata', true );
	if ( empty( $image_meta['file'] ) ) {
		return;
	}
	// If possible add in our images on the fly sizes
	$ext = substr( $image_meta['file'], strrpos( $image_meta['file'], '.' ) );
	$pathflyfilename = str_replace( $ext, '-' . $width . 'x' . $height . '' . $ext, $image_meta['file'] );
	$pathretinaflyfilename = str_replace( $ext, '-' . $width . 'x' . $height . '@2x' . $ext, $image_meta['file'] );
	$flyfilename = basename( $image_meta['file'], $ext ) . '-' . $width . 'x' . $height . '' . $ext;
	$retinaflyfilename = basename( $image_meta['file'], $ext ) . '-' . $width . 'x' . $height . '@2x' . $ext;

	$upload_info = wp_upload_dir();
	$upload_dir = $upload_info['basedir'];

	$flyfile = trailingslashit( $upload_dir ) . $pathflyfilename;
	$retinafile = trailingslashit( $upload_dir ) . $pathretinaflyfilename;
	if ( empty( $image_meta['sizes'] ) ) {
		$image_meta['sizes'] = array();}
	if ( file_exists( $flyfile ) ) {
		$bt_add_imagesize = array(
			'bt_on_fly' => array(
				'file' => $flyfilename,
				'width' => $width,
				'height' => $height,
				'mime-type' => $image_meta['sizes']['thumbnail']['mime-type'],
			),
		);
		$image_meta['sizes'] = array_merge( $image_meta['sizes'], $bt_add_imagesize );
	}
	if ( file_exists( $retinafile ) ) {
		$size = getimagesize( $retinafile );
		if ( ( $size[0] === 2 * $width ) && ( $size[1] === 2 * $height ) ) {
			$bt_add_imagesize_retina = array(
				'bt_on_fly_retina' => array(
					'file' => $retinaflyfilename,
					'width' => 2 * $width,
					'height' => 2 * $height,
					'mime-type' => $image_meta['sizes']['thumbnail']['mime-type'],
				),
			);
			$image_meta['sizes'] = array_merge( $image_meta['sizes'], $bt_add_imagesize_retina );
		}
	}
	if ( function_exists( 'wp_calculate_image_srcset' ) ) {
		$output = wp_calculate_image_srcset( array( $width, $height ), $url, $image_meta, $id );
	} else {
		$output = '';
	}
	return $output;
}
function bt_woo_get_srcset_output( $width, $height, $url, $id ) {
	$img_srcset = bt_woo_get_srcset( $width, $height, $url, $id );
	if ( ! empty( $img_srcset ) ) {
		$output = 'srcset="' . esc_attr( $img_srcset ) . '" sizes="(max-width: ' . esc_attr( $width ) . 'px) 100vw, ' . esc_attr( $width ) . 'px"';
	} else {
		$output = '';
	}
	return $output;
}


add_action( 'cmb2_render_bt_woo_text_number', 'bt_woo_small_render_text_number', 10, 5 );
function bt_woo_small_render_text_number( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {
	echo $field_type_object->input(
		array(
			'class' => 'cmb2-text-small',
			'type' => 'number',
			'step' => 'any',
		)
	);
}
add_filter( 'cmb2_sanitize_bt_woo_text_number', 'bt_woo_small_sanitize_text_number', 10, 2 );
function bt_woo_small_sanitize_text_number( $null, $new ) {
	// $new = preg_replace( "/[^0-9]/", "", $new );
	return $new;
}
function bt_woo_small_render_text_vote_up( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {
	echo $field_type_object->input(
		array(
			'class' => 'cmb2-text-small',
			'type' => 'number',
		)
	);
}
add_action( 'cmb2_render_text_vote_up', 'bt_woo_small_render_text_vote_up', 10, 5 );
function bt_woo_sanitize_text_vote_up_callback( $override_value, $value, $post_id ) {
	$votes = get_post_meta( $post_id, '_bt_review_votes', true );
	$old = get_post_meta( $post_id, '_bt_review_upvotes', true );
	if ( $old >= $value ) {
		$new = $old - $value;
		$newvotes = $votes - $new;
	} else {
		$new = $value - $old;
		$newvotes = $votes + $new;
	}
	update_post_meta( $post_id, '_bt_review_votes', $newvotes );
	return $value;
}
add_filter( 'cmb2_sanitize_text_vote_up', 'bt_woo_sanitize_text_vote_up_callback', 10, 3 );
function bt_woo_small_render_text_vote_down( $field, $escaped_value, $object_id, $object_type, $field_type_object ) {
	echo $field_type_object->input(
		array(
			'class' => 'cmb2-text-small',
			'type' => 'number',
		)
	);
}
add_action( 'cmb2_render_text_vote_down', 'bt_woo_small_render_text_vote_down', 10, 5 );
function bt_woo_sanitize_text_vote_down_callback( $override_value, $value, $post_id ) {
	$votes = get_post_meta( $post_id, '_bt_review_votes', true );
	$old = get_post_meta( $post_id, '_bt_review_downvotes', true );
	if ( $old >= $value ) {
		$new = $old - $value;
		$newvotes = $votes + $new;
	} else {
		$new = $value - $old;
		$newvotes = $votes - $new;
	}
	update_post_meta( $post_id, '_bt_review_votes', $newvotes );
	return $value;
}
add_filter( 'cmb2_sanitize_text_vote_down', 'bt_woo_sanitize_text_vote_down_callback', 10, 3 );

function bt_woo_get_post_options( $query_args ) {

	$args = wp_parse_args(
		$query_args,
		array(
			'post_type'   => 'post',
			'numberposts' => -1,
		)
	);

	$posts = get_posts( $args );

	$post_options = array();
	if ( $posts ) {
		foreach ( $posts as $post ) {
			$post_options[ $post->ID ] = $post->post_title;
		}
	}

	return $post_options;
}

function bt_woo_coupon_posts_options() {
	$posts = bt_woo_get_post_options(
		array(
			'post_type' => 'shop_coupon',
			'numberposts' => -1,
		)
	);
	$posts['0'] = __( 'Select a Coupon', 'templatemela-core' );
	return $posts;
}
function bt_woo_product_posts_options() {
	$posts = bt_woo_get_post_options(
		array(
			'post_type' => 'product',
			'numberposts' => -1,
		)
	);
	$posts['0'] = __( 'Select a Product', 'templatemela-core' );
	return $posts;
}
function bt_woo_product_posts_options_muiti() {
	$posts = bt_woo_get_post_options(
		array(
			'post_type' => 'product',
			'numberposts' => -1,
		)
	);
	return $posts;
}
function bt_woo_size_chart_posts_options() {
	$posts = bt_woo_get_post_options(
		array(
			'post_type' => 'bt_size_chart',
			'numberposts' => -1,
		)
	);
	$posts['0'] = __( 'None', 'templatemela-core' );
	return $posts;
}
function bt_woo_change_cmb2_styles() {
	wp_deregister_style( 'cmb2-styles' );
	wp_register_style( 'cmb2-styles', TMCORE_WOO_URL . '/cmb/css/cmb2.css' );
}
// add_action('init', 'bt_woo_change_cmb2_styles', 20);

function bt_get_term_options( $field ) {
	$args = $field->args( 'get_terms_args' );
	$args = is_array( $args ) ? $args : array();

	$args = wp_parse_args( $args, array( 'taxonomy' => 'category' ) );

	$taxonomy = $args['taxonomy'];

	$terms = (array) cmb2_utils()->wp_at_least( '4.5.0' )
		? get_terms( $args )
		: get_terms( $taxonomy, $args );

	// Initate an empty array
	$term_options = array();
	if ( ! empty( $terms ) ) {
		foreach ( $terms as $term ) {
			$term_options[ $term->term_id ] = $term->name;
		}
	}

	return $term_options;
}
function bt_woo_default_placeholder_image() {
	return apply_filters( 'bt_woo_default_placeholder_image', 'http://placehold.it/' );
}

function bt_woo_get_image_array( $width = null, $height = null, $crop = true, $class = null, $alt = null, $id = null, $placeholder = false, $fallback = 'full' ) {
	if ( empty( $id ) ) {
		$id = get_post_thumbnail_id();
	}
	if ( ! empty( $id ) ) {
		$bt_woo_get_image = BT_WOO_Get_Image::getInstance();
		$image = $bt_woo_get_image->process( $id, $width, $height, $fallback );
		if ( empty( $alt ) ) {
			$alt = get_post_meta( $id, '_wp_attachment_image_alt', true );
		}
		$return_array = array(
			'src' => $image[0],
			'width' => $image[1],
			'height' => $image[2],
			'srcset' => $image[3],
			'class' => $class,
			'alt' => $alt,
			'full' => $image[4],
			'id' => ( isset( $image[5] ) ? $image[5] : '' ),
			'full_width' => ( isset( $image[6] ) ? $image[6] : '' ),
			'full_height' => ( isset( $image[7] ) ? $image[7] : '' ),
			'src_set' => ( isset( $image[8] ) ? $image[8] : '' ),
			'sizes' => ( isset( $image[9] ) ? $image[9] : '' ),
		);
	} else if ( empty( $id ) && $placeholder == true ) {
		if ( empty( $height ) ) {
			$height = $width;
		}
		if ( empty( $width ) ) {
			$width = $height;
		}
		$return_array = array(
			'src' => bt_woo_default_placeholder_image() . $width . 'x' . $height . '?text=Image+Placeholder',
			'width' => $width,
			'height' => $height,
			'srcset' => '',
			'sizes' => '',
			'src_set' => '',
			'id' => '',
			'class' => $class,
			'alt' => $alt,
			'full' => bt_woo_default_placeholder_image() . $width . 'x' . $height . '?text=Image+Placeholder',
			'full_width' => '',
			'full_height' => '',
		);
	} else {
		$return_array = array(
			'src' => '',
			'width' => '',
			'height' => '',
			'srcset' => '',
			'sizes' => '',
			'id' => '',
			'src_set' => '',
			'class' => '',
			'alt' => '',
			'full' => '',
			'full_width' => '',
			'full_height' => '',
		);
	}

	return $return_array;
}

function bt_woo_get_full_image_output( $width = null, $height = null, $crop = true, $class = null, $alt = null, $id = null, $placeholder = false, $lazy = false, $schema = true, $extra = null ) {
	$img = bt_woo_get_image_array( $width, $height, $crop, $class, $alt, $id, $placeholder );
	if ( $lazy ) {
		   $image_src_output = 'src="' . esc_url( $img['src'] ) . '"';
	} else {
		$image_src_output = 'src="' . esc_url( $img['src'] ) . '"';
	}
	$extras = '';
	if ( is_array( $extra ) ) {
		foreach ( $extra as $key => $value ) {
			$extras .= esc_attr( $key ) . '="' . esc_attr( $value ) . '" ';
		}
	} else {
		$extras = $extra;
	}
	if ( ! empty( $img['src'] ) && $schema == true ) {
		$output = '<div itemprop="image" itemscope itemtype="http://schema.org/ImageObject">';
		$output .= '<img ' . $image_src_output . ' width="' . esc_attr( $img['width'] ) . '" height="' . esc_attr( $img['height'] ) . '" ' . $img['srcset'] . ' class="' . esc_attr( $img['class'] ) . '" itemprop="contentUrl" alt="' . esc_attr( $img['alt'] ) . '" ' . $extras . '>';
		$output .= '<meta itemprop="url" content="' . esc_url( $img['src'] ) . '">';
		$output .= '<meta itemprop="width" content="' . esc_attr( $img['width'] ) . 'px">';
		$output .= '<meta itemprop="height" content="' . esc_attr( $img['height'] ) . 'px">';
		$output .= '</div>';
		return $output;

	} elseif ( ! empty( $img['src'] ) ) {
		return '<img ' . $image_src_output . ' width="' . esc_attr( $img['width'] ) . '" height="' . esc_attr( $img['height'] ) . '" ' . $img['srcset'] . ' class="' . esc_attr( $img['class'] ) . '" alt="' . esc_attr( $img['alt'] ) . '" ' . $extras . '>';
	} else {
		return null;
	}
}
/**
 * Get an SVG Icon
 *
 * @param string $icon the icon name.
 * @param string $icon_title the icon title for screen readers.
 * @param bool   $base if the baseline class should be added.
 */
function base_woo_extras_get_icon( $icon = 'search', $icon_title = '', $base = true, $aria = false ) {
	$display_title = apply_filters( 'base_svg_icons_have_title', true );
	$output = '<span class="base-svg-iconset' . ( $base ? ' svg-baseline' : '' ) . '">';
	switch ( $icon ) {
		case 'play':
			$output .= '<svg'. ( ! $aria ? ' aria-hidden="true"' : '' ) . ' class="base-svg-icon base-play-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20">';
			if ( $display_title ) {
				$output .= '<title>' . ( ! empty( $icon_title ) ? $icon_title : esc_html__( 'Play', 'templatemela-core' ) ) . '</title>';
			}
			$output .= '<path d="M15 10.001c0 0.299-0.305 0.514-0.305 0.514l-8.561 5.303c-0.624 0.409-1.134 0.106-1.134-0.669v-10.297c0-0.777 0.51-1.078 1.135-0.67l8.561 5.305c-0.001 0 0.304 0.215 0.304 0.514z"></path>
			</svg>';
			break;
		case 'play-circle':
			$output .= '<svg'. ( ! $aria ? ' aria-hidden="true"' : '' ) . ' class="base-svg-icon base-play-circle-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">';
			if ( $display_title ) {
				$output .= '<title>' . ( ! empty( $icon_title ) ? $icon_title : esc_html__( 'Play', 'templatemela-core' ) ) . '</title>';
			}
			$output .= '<path d="M8 0c-4.418 0-8 3.582-8 8s3.582 8 8 8 8-3.582 8-8-3.582-8-8-8zM8 14.5c-3.59 0-6.5-2.91-6.5-6.5s2.91-6.5 6.5-6.5 6.5 2.91 6.5 6.5-2.91 6.5-6.5 6.5zM6 4.5l6 3.5-6 3.5z"></path>
			</svg>';
			break;
		case 'header-wishlist':
			$output .= '<svg'. ( ! $aria ? ' aria-hidden="true"' : '' ) . ' class="base-svg-icon base-header-wishlist-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24">';
			if ( $display_title ) {
				$output .= '<title>' . ( ! empty( $icon_title ) ? $icon_title : esc_html__( 'Wishlist', 'templatemela-core' ) ) . '</title>';
			}
			$output .= '<path d="M20.425 7.71875C20.9458 7.77083 21.2844 8.04427 21.4406 8.53906C21.5969 9.03385 21.4927 9.46354 21.1281 9.82812L16.9875 13.8516L17.9641 19.5547C18.0422 20.0495 17.8729 20.4401 17.4562 20.7266C17.0396 21.0391 16.6099 21.0781 16.1672 20.8438L11.05 18.1875L5.93281 20.8438C5.4901 21.1042 5.06042 21.0781 4.64375 20.7656C4.22708 20.4531 4.05781 20.0495 4.13594 19.5547L5.1125 13.8516L0.971875 9.82812C0.607292 9.46354 0.503125 9.03385 0.659375 8.53906C0.815625 8.04427 1.15417 7.77083 1.675 7.71875L7.37812 6.85938L9.91719 1.70312C10.1516 1.23438 10.5292 1 11.05 1C11.5708 1 11.9484 1.23438 12.1828 1.70312L14.7219 6.85938L20.425 7.71875ZM14.9953 13.1875L18.9016 9.35938L13.4719 8.57812L11.05 3.65625L8.62812 8.57812L3.19844 9.35938L7.10469 13.1875L6.20625 18.6172L11.05 16.0391L15.8937 18.6172L14.9953 13.1875Z"></path>
			</svg>';
			break;
		default:
			$output .= '';
			break;
	}
	$output .= '</span>';

	$output = apply_filters( 'base_svg_icon', $output, $icon, $icon_title, $base );

	return $output;
}
/**
 * Print an SVG Icon
 *
 * @param string $icon the icon name.
 * @param string $icon_title the icon title for screen readers.
 * @param bool   $base if the baseline class should be added.
 */
function base_woo_extras_print_icon( $icon = 'search', $icon_title = '', $base = true, $aria = false ) {
	echo base_woo_extras_get_icon( $icon, $icon_title, $base, $aria ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
}
