<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('TemplateMelaCore_WooCommerce_Clever')) :


    class TemplateMelaCore_WooCommerce_Clever {
        private $suffix = '';

        public function __construct() {
            $this->suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

            $this->check_activate();
            $this->add_hook();

            add_action( 'wp_enqueue_scripts', array( $this, 'action_enqueue_scripts' ) );

        }

        private function check_activate() {
            if (is_admin() && current_user_can('administrator')) {

                $check = get_option('clever_plugin_first_activate', false);
                if (!$check) {

                    update_option('woosq_button_position', '0');
                    update_option('_wooscp_button_archive', '0');
                    update_option('woosw_button_position_archive', '0');

                    update_option('clever_plugin_first_activate', true);
                }
            }
        }

        public function add_hook() {

            $shopkit_settings = get_option( 'bt_woo_extras' );
            if ( ! is_array( $shopkit_settings ) ) {
                $shopkit_settings = json_decode( $shopkit_settings, true );
            }

            $wishlist = ( isset( $shopkit_settings['product_wishlist_on_image_hover'] ) && !empty($shopkit_settings['product_wishlist_on_image_hover']) ) ? $shopkit_settings['product_wishlist_on_image_hover'] : '';
            $quickview = ( isset( $shopkit_settings['product_quickview_on_image_hover'] ) && !empty($shopkit_settings['product_quickview_on_image_hover']) ) ? $shopkit_settings['product_quickview_on_image_hover'] : '';
            $compare = ( isset( $shopkit_settings['product_compare_on_image_hover'] ) && !empty($shopkit_settings['product_compare_on_image_hover']) ) ? $shopkit_settings['product_compare_on_image_hover'] : '';


            if (function_exists('woosw_init') && get_option('woosw_button_position_archive') == "0" && !empty($wishlist)) {
                add_action('base_archive_loop_product_action_over_image', [$this, 'wishlist_button'], 5);
            }

            if (function_exists('woosc_init') ) {
                add_filter('woosc_button_position_archive','__return_false');
                if(!empty($compare)) {
                    add_action('base_archive_loop_product_action_over_image', [$this, 'compare_button'], 10);
                }                
            }
            if (function_exists('woosq_init') && get_option('woosq_button_position') == "0" && !empty($quickview) ) {
                add_action('base_archive_loop_product_action_over_image', [$this, 'quickview_button'], 15);
            }

        }

        /**
         * WooCommerce specific scripts & stylesheets
         *
         * @since 1.0.0
         */
        public function action_enqueue_scripts() {

            wp_enqueue_style('tmcore-clever-style',  TMCORE_URL . "assets/css/woocommerce/clever{$this->suffix}.css", array(), TMCORE_VERSION );
            wp_style_add_data('tmcore-clever-style', 'rtl', 'replace');

        }

        public function quickview_button() {
            echo do_shortcode('[woosq]');
        }

        public function compare_button() {
            echo do_shortcode('[woosc]');
        }

        public function wishlist_button() {
            echo do_shortcode('[woosw]');
        }

    }

    return new TemplateMelaCore_WooCommerce_Clever();
endif;
