<?php
/**
 * Woocommerce Product Catalog Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;

Theme_Customizer::add_settings(
	array(
		'info_product_sticky_add_to_cart' => array(
			'control_type' => 'base_title_control',
			'priority'     => 20,
			'section'      => 'product_layout',
			'label'        => esc_html__( 'Sticky Add To Cart', 'templatemela-core' ),
			'settings'     => false,
		),
		'product_sticky_add_to_cart' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'product_layout',
			'priority'     => 20,
			'default'      => webapp()->default( 'product_sticky_add_to_cart' ),
			'label'        => esc_html__( 'Enabled Sticky Add to Cart', 'templatemela-core' ),
			'input_attrs'  => array(
				'help' => esc_html__( 'Adds a Sticky Bar with add to cart when you scroll down the product page.', 'templatemela-core' ),
			),
			'transport'    => 'refresh',
		),
		'product_sticky_add_to_cart_placement' => array(
			'control_type' => 'base_radio_icon_control',
			'section'      => 'product_layout',
			'default'      => webapp()->default( 'product_sticky_add_to_cart_placement' ),
			'label'        => esc_html__( 'Sticky Placement', 'templatemela-core' ),
			'priority'     => 20,
			'context'      => array(
				array(
					'setting'    => 'product_sticky_add_to_cart',
					'operator'   => '=',
					'value'      => true,
				),
			),
			'live_method'     => array(
				array(
					'type'     => 'class',
					'selector' => '#base-sticky-add-to-cart',
					'pattern'  => 'base-sticky-add-to-cart-$',
					'key'      => '',
				),
			),
			'input_attrs'  => array(
				'layout' => array(
					'header' => array(
						'name' => __( 'Top', 'templatemela-core' ),
					),
					'footer' => array(
						'name' => __( 'Bottom', 'templatemela-core' ),
					),
				),
				'responsive' => false,
				'class'      => 'base-two-forced',
			),
		),
		'product_sticky_mobile_add_to_cart' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'product_layout',
			'priority'     => 20,
			'default'      => webapp()->default( 'product_sticky_mobile_add_to_cart' ),
			'label'        => esc_html__( 'Enabled for mobile', 'templatemela-core' ),
			'transport'    => 'refresh',
			'context'      => array(
				array(
					'setting'    => 'product_sticky_add_to_cart',
					'operator'   => '=',
					'value'      => true,
				),
			),
		),
		'product_sticky_mobile_add_to_cart_placement' => array(
			'control_type' => 'base_radio_icon_control',
			'section'      => 'product_layout',
			'default'      => webapp()->default( 'product_sticky_mobile_add_to_cart_placement' ),
			'label'        => esc_html__( 'Mobile Placement', 'templatemela-core' ),
			'priority'     => 20,
			'context'      => array(
				array(
					'setting'    => 'product_sticky_add_to_cart',
					'operator'   => '=',
					'value'      => true,
				),
				array(
					'setting'    => 'product_sticky_mobile_add_to_cart',
					'operator'   => '=',
					'value'      => true,
				),
			),
			'live_method'     => array(
				array(
					'type'     => 'class',
					'selector' => '#base-sticky-mobile-add-to-cart',
					'pattern'  => 'base-sticky-add-to-cart-$',
					'key'      => '',
				),
			),
			'input_attrs'  => array(
				'layout' => array(
					'header' => array(
						'name' => __( 'Top', 'templatemela-core' ),
					),
					'footer' => array(
						'name' => __( 'Bottom', 'templatemela-core' ),
					),
				),
				'responsive' => false,
				'class'      => 'base-two-forced',
			),
		),
	)
);

