<?php
/**
 * Woocommerce Trigger Cart when Product added Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
Theme_Customizer::add_settings(
	array(
		'infinite_posts' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'infinite_scroll',
			'priority'     => 11,
			'default'      => webapp()->default( 'infinite_posts' ),
			'label'        => esc_html__( 'Infinite Scroll for Blog?', 'templatemela-core' ),
			'input_attrs'  => array(
				'help' => esc_html__( 'This will use apply to all post archives.', 'templatemela-core' ),
			),
			'transport'    => 'refresh',
		),
		// 'infinite_single_posts' => array(
		// 	'control_type' => 'base_switch_control',
		// 	'section'      => 'infinite_scroll',
		// 	'priority'     => 11,
		// 	'default'      => webapp()->default( 'infinite_single_posts' ),
		// 	'label'        => esc_html__( 'Infinite Scroll for Single Blog Posts?', 'templatemela-core' ),
		// 	'input_attrs'  => array(
		// 		'help' => esc_html__( 'This will use apply to single posts.', 'templatemela-core' ),
		// 	),
		// 	'transport'    => 'refresh',
		// ),
		'infinite_search' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'infinite_scroll',
			'priority'     => 11,
			'default'      => webapp()->default( 'infinite_search' ),
			'label'        => esc_html__( 'Infinite Scroll for Search?', 'templatemela-core' ),
			'transport'    => 'refresh',
		),
		'infinite_products' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'infinite_scroll',
			'priority'     => 11,
			'default'      => webapp()->default( 'infinite_products' ),
			'label'        => esc_html__( 'Infinite Scroll for Products?', 'templatemela-core' ),
			'transport'    => 'refresh',
		),
		'infinite_pagination_type' => array(
			'control_type' => 'base_select_control',
			'section'      => 'infinite_scroll',
			'priority'     => 11,
			'default'      => webapp()->default( 'infinite_pagination_type' ),
			'label'        => esc_html__( 'Infinite Pagination type for Products', 'templatemela-core' ),
			'input_attrs'  => array(
				'options' => array(
					'load-more' => array(
						'name' => __( 'Load More Button', 'templatemela-core' ),
					),
					'infinite' => array(
						'name' => __( 'Autoload on Scroll', 'templatemela-core' ),
					),
				),
			),
			'transport'    => 'refresh',
		),
		'infinite_custom' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'infinite_scroll',
			'priority'     => 11,
			'default'      => webapp()->default( 'infinite_custom' ),
			'label'        => esc_html__( 'Infinite Scroll for Custom Post Types?', 'templatemela-core' ),
			'input_attrs'  => array(
				'help' => esc_html__( 'This will use apply to all custom post archives.', 'templatemela-core' ),
			),
			'transport'    => 'refresh',
		),
		'infinite_end_of_content' => array(
			'control_type' => 'base_text_control',
			'sanitize'     => 'sanitize_text_field',
			'section'      => 'infinite_scroll',
			'priority'     => 12,
			'label'        => esc_html__( 'End of Content Text', 'templatemela-core' ),
			'default'      => webapp()->default( 'infinite_end_of_content' ),
			'transport'    => 'refresh',
		),
	)
);
