<?php
/**
 * Header HTML2 Options
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;

$settings = array(
	'header_mobile_divider2_border' => array(
		'control_type' => 'base_border_control',
		'section'      => 'header_mobile_divider2',
		'label'        => esc_html__( 'Mobile Divider 2', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_mobile_divider2_border' ),
		'live_method'     => array(
			array(
				'type'     => 'css_border',
				'selector' => '#mobile-header .header-mobile-divider2',
				'pattern'  => '$',
				'property' => 'border-right',
				'pattern'  => '$',
				'key'      => 'border',
			),
			array(
				'type'     => 'css_border',
				'selector' => '#mobile-drawer .header-mobile-divider2',
				'pattern'  => '$',
				'property' => 'border-top',
				'pattern'  => '$',
				'key'      => 'border',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	'header_mobile_divider2_height' => array(
		'control_type' => 'base_range_control',
		'section'      => 'header_mobile_divider2',
		'label'        => esc_html__( 'Mobile Divider Length', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '#mobile-header .header-mobile-divider2',
				'pattern'  => '$',
				'property' => 'height',
				'key'      => 'size',
			),
			array(
				'type'     => 'css',
				'selector' => '#mobile-drawer .header-mobile-divider2',
				'pattern'  => '$',
				'property' => 'width',
				'key'      => 'size',
			),
		),
		'default'      => webapp()->default( 'header_mobile_divider2_height' ),
		'input_attrs'  => array(
			'min'     => array(
				'%'  => 0,
				'px'  => 0,
				'rem' => 0,
			),
			'max'     => array(
				'%'  => 100,
				'px'  => 100,
			),
			'step'    => array(
				'%'  => 1,
				'px'  => 1,
			),
			'units'   => array( '%', 'px' ),
			'responsive' => false,
		),
	),
	'header_mobile_divider2_margin' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_mobile_divider2',
		'priority'     => 10,
		'default'      => webapp()->default( 'header_mobile_divider2_margin' ),
		'label'        => esc_html__( 'Margin', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '#mobile-header .header-mobile-divider2, #mobile-drawer .header-mobile-divider2',
				'property' => 'margin',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	'transparent_header_mobile_divider2_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'transparent_header_design',
		'label'        => esc_html__( 'Mobile Divider 2 Color', 'templatemela-core' ),
		'default'      => webapp()->default( 'transparent_header_mobile_divider2_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.mobile-transparent-header #mobile-header .header-mobile-divider2',
				'property' => 'border-color',
				'pattern'  => '$',
				'key'      => 'color',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
);

Theme_Customizer::add_settings( $settings );

