/* global searchAdvancedConfig */
/**
 * Ajax Search Results.
 */
//alert(searchAdvancedConfig.ajaxURL);
(function($) {
	'use strict';
	window.searchAdvanced = {
		/**
		 * Find the search products and open it.
		 */
		triggerAjaxSearch: function() {
			var search_cat = '';
			if (window.innerWidth <= 1024) {
				var search_text = $('#mobile-header .header-search-advanced .search-field')?.val();
				var search_cat = $('#mobile-header .header-search-advanced .search-select')?.find(":selected")?.val();
			} else {
				var search_text = $('#main-header .header-search-advanced .search-field').val();
				var search_cat = $('#main-header .header-search-advanced .search-select')?.find(":selected")?.val();
				
			}
			//console.log(search_cat);
			// No point if no drawers.
			if ( ! search_text ) {
				return;
			}
			if( search_text.length > 1 && search_text != "" ){
		
				$.ajax({
					url: searchAdvancedConfig.ajaxURL,
					type: 'post',
					data: { action: 'search_data_fetch', keyword: search_text, category: search_cat },
					success: function(data) {
						$('.header-search-advanced .search-results #datafetch').html( data );
						$( '.header-search-advanced .search-results' ).show();
						$( '.header-search-advanced .loader-container' ).hide();
					}
				});
			} else {
				$('.header-search-advanced .search-results #datafetch').html("");
				$( '.header-search-advanced .loader-container' ).hide();
			}
		},

		/**
		 * Close the product search.
		 */
		clearSearch: function() {
			$( '.header-search-advanced .search-results' ).hide();
		},

		/**
		 * Initiate the script to toggle search when product is added.
		 */
		initSearchToggle: function() {
			var searching = null;
			
			$( '.header-search-advanced .search-field' ).on( 'keyup', function() {
				var $field = $( this );
				clearTimeout( searching );
				searching = setTimeout( function() {
					if ( $field.val().length > 2 ) {
						$( '.header-search-advanced .loader-container' ).show();
						window.searchAdvanced.triggerAjaxSearch();
					} else {
						window.searchAdvanced.clearSearch();
						$( '.header-search-advanced .loader-container' ).hide();
					}
				}, 100 );
			} );

			$(".header-search-advanced .search-field").focus(function(){
				if($('.header-search-advanced .search-results #datafetch').children().length > 0) {
					$( '.header-search-advanced .search-results' ).show();
					$( '.header-search-advanced .loader-container' ).hide();
				}
			});
		},

		/**
		 * Close the product search.
		 */
		clearSearchOnCross: function() {
			$( '.header-search-advanced .search-field' ).on("search", function(event) {
				window.searchAdvanced.clearSearch();
				$('#main-header .header-search-advanced .search-field').val = '';
			});
		},

		/**
		 * Close the product search.
		 */
		clearSearchOutside: function() {
			$(document).on("mouseup", function(event) {

				var container = $(".header-search-advanced");

				// if the target of the click isn't the container nor a descendant of the container
				if (!container.is(event.target) && container.has(event.target).length === 0) {
					window.searchAdvanced.clearSearch();
				}
				//window.searchAdvanced.clearSearch();
				//$('#main-header .header-search-advanced .search-field').val = '';
			});
		},

		// Initiate the search when the DOM loads.
		init: function() {
			window.searchAdvanced.initSearchToggle();
			window.searchAdvanced.clearSearchOnCross();
			window.searchAdvanced.clearSearchOutside();
		}
	}
	if ( 'loading' === document.readyState ) {
		// The DOM has not yet been loaded.
		document.addEventListener( 'DOMContentLoaded', window.searchAdvanced.init );
	} else {
		// The DOM has already been loaded.
		window.searchAdvanced.init();
	}
})(jQuery);

