<?php
/**
 * Header HTML2 Options
 *
 * @package TemplateMela
 */

namespace TemplateMela;

use Base\Theme_Customizer;
use function Base\webapp;

$settings = array(
	'header_search_advanced_tabs' => array(
		'control_type' => 'base_tab_control',
		'section'      => 'header_search_advanced',
		'settings'     => false,
		'priority'     => 1,
		'input_attrs'  => array(
			'general' => array(
				'label'  => __( 'General', 'templatemela-core' ),
				'target' => 'header_search_advanced',
			),
			'design' => array(
				'label'  => __( 'Design', 'templatemela-core' ),
				'target' => 'header_search_advanced_design',
			),
			'active' => 'general',
		),
	),
	'header_search_advanced_tabs_design' => array(
		'control_type' => 'base_tab_control',
		'section'      => 'header_search_advanced_design',
		'settings'     => false,
		'priority'     => 1,
		'input_attrs'  => array(
			'general' => array(
				'label'  => __( 'General', 'templatemela-core' ),
				'target' => 'header_search_advanced',
			),
			'design' => array(
				'label'  => __( 'Design', 'templatemela-core' ),
				'target' => 'header_search_advanced_design',
			),
			'active' => 'design',
		),
	),
	'header_search_advanced_width' => array(
		'control_type' => 'base_range_control',
		'section'      => 'header_search_advanced',
		'label'        => esc_html__( 'Search Box Width', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form',
				'property' => 'width',
				'pattern'  => '$',
				'key'      => 'size',
			),
		),
		'default'      => webapp()->default( 'header_search_advanced_width' ),
		'input_attrs'  => array(
			'min'        => array(
				'px'  => 100,
				'em'  => 4,
				'rem' => 4,
			),
			'max'        => array(
				'px'  => 1000,
				'em'  => 12,
				'rem' => 12,
			),
			'step'       => array(
				'px'  => 1,
				'em'  => 0.01,
				'rem' => 0.01,
			),
			'units'      => array( 'px', 'em', 'rem' ),
			'responsive' => true,
		),
	),
	'header_search_advanced_categories' => array(
		'control_type' => 'base_switch_control',
		'section'      => 'header_search_advanced',
		'priority'     => 5,
		'default'      => webapp()->default( 'header_search_advanced_categories' ),
		'label'        => esc_html__( 'Show categories dropdown?', 'templatemela-core' ),
		'transport'    => 'refresh',
	),
	'header_search_advanced_categories_label' => array(
		'control_type' => 'base_text_control',
		'section'      => 'header_search_advanced',
		'priority'     => 5,
		'sanitize'     => 'sanitize_text_field',
		'default'      => webapp()->default( 'header_search_advanced_categories_label' ),
		'label'        => esc_html__( 'Categories Dropdown Label', 'templatemela-core' ),
		'context'      => array(
			array(
				'setting'  => 'header_search_advanced_categories',
				'operator' => '==',
				'value'    => true,
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'html',
				'selector' => '.header-search-advanced .search-select option[value="0"]',
				'pattern'  => '$',
				'key'      => '',
			),
		),
	),
	'header_search_advanced_placeholder' => array(
		'control_type' => 'base_text_control',
		'section'      => 'header_search_advanced',
		'priority'     => 5,
		'sanitize'     => 'sanitize_text_field',
		'default'      => webapp()->default( 'header_search_advanced_placeholder' ),
		'label'        => esc_html__( 'Search Input Placeholder', 'templatemela-core' ),
	),
	'header_search_advanced_label' => array(
		'control_type' => 'base_text_control',
		'section'      => 'header_search_advanced',
		'sanitize'     => 'sanitize_text_field',
		'default'      => webapp()->default( 'header_search_advanced_label' ),
		'label'        => esc_html__( 'Button Label', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'html',
				'selector' => '.header-search-advanced .search-btn-text',
				'pattern'  => '$',
				'key'      => '',
			),
		),
	),
	'header_search_advanced_label_visiblity' => array(
		'control_type' => 'base_check_icon_control',
		'section'      => 'header_search_advanced',
		'default'      => webapp()->default( 'header_search_advanced_label_visiblity' ),
		'label'        => esc_html__( 'Button Label Visibility', 'templatemela-core' ),
		'context'      => array(
			array(
				'setting' => '__current_tab',
				'value'   => 'general',
			),
			array(
				'setting'  => 'header_search_advanced_label',
				'operator' => '!empty',
				'value'    => '',
			),
		),
		'partial'      => array(
			'selector'            => '.header-search-advanced .search-btn-text',
			'container_inclusive' => true,
			'render_callback'     => 'TemplateMela\header_search_advanced',
		),
		'input_attrs'  => array(
			'options' => array(
				'desktop' => array(
					'name' => __( 'Desktop', 'templatemela-core' ),
					'icon' => 'desktop',
				),
				'tablet' => array(
					'name' => __( 'Tablet', 'templatemela-core' ),
					'icon' => 'tablet',
				),
				'mobile' => array(
					'name' => __( 'Mobile', 'templatemela-core' ),
					'icon' => 'smartphone',
				),
			),
		),
	),
	'header_search_advanced_icon' => array(
		'control_type' => 'base_radio_icon_control',
		'section'      => 'header_search_advanced',
		'default'      => webapp()->default( 'header_search_advanced_icon' ),
		'label'        => esc_html__( 'Search Icon', 'templatemela-core' ),
		'partial'      => array(
			'selector'            => '.search-btn-icon',
			'container_inclusive' => true,
			'render_callback'     => 'TemplateMela\search_advanced',
		),
		'input_attrs'  => array(
			'layout' => array(
				'search' => array(
					'icon' => 'search',
				),
				'search2' => array(
					'icon' => 'search2',
				),
			),
			'responsive' => false,
			'class' => 'radio-icon-padding',
		),
	),
	// Search-Box
	'header_search_advanced_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Box Background', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_background' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'header_search_advanced_border' => array(
		'control_type' => 'base_border_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Box Border', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_border' ),
		'live_method'     => array(
			array(
				'type'     => 'css_border',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'pattern'  => '$',
				'property' => 'border',
				'pattern'  => '$',
				'key'      => 'border',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
			'color'      => false,
		),
	),
	'header_search_advanced_border_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Box Border Color', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_border_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'property' => 'border-color',
				'pattern'  => '$',
				'key'      => 'color',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'header_search_advanced_border_radius' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_search_advanced_design',
		'default'      => webapp()->default( 'header_search_advanced_border_radius' ),
		'label'        => esc_html__( 'Box Border Radius', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form',
				'property' => 'border-radius',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	'header_search_advanced_margin' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_search_advanced_design',
		'default'      => webapp()->default( 'header_search_advanced_margin' ),
		'label'        => esc_html__( 'Box Margin', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced',
				'property' => 'margin',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => true,
		),
	),
	// Category-Box
	'header_search_advanced_category_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Category Background', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_category_background' ),
		'live_method'     => array(
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-category-field .search-select',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
			'allowGradient' => true,
		),
	),
	'header_search_advanced_category_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Category Text', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_category_color' ),
		'live_method'     => array(
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-category-field .search-select',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'header_search_advanced_category_typography' => array(
		'control_type' => 'base_typography_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Category Font', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_category_typography' ),
		'live_method'     => array(
			array(
				'type'     => 'css_typography',
				'selector' => '.header-search-advanced form.search-form .search-category-field .search-select',
				'pattern'  => array(
					'desktop' => '$',
					'tablet'  => '$',
					'mobile'  => '$',
				),
				'property' => 'font',
				'key'      => 'typography',
			),
		),
		'input_attrs'  => array(
			'id' => 'header_search_advanced_category_typography',
			'options' => 'no-color',
		),
	),
	// Input
	'header_search_advanced_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Input Text Colors', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_color' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Focus Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'header_search_advanced_typography' => array(
		'control_type' => 'base_typography_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Input Font', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_typography' ),
		'live_method'     => array(
			array(
				'type'     => 'css_typography',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'pattern'  => array(
					'desktop' => '$',
					'tablet'  => '$',
					'mobile'  => '$',
				),
				'property' => 'font',
				'key'      => 'typography',
			),
		),
		'input_attrs'  => array(
			'id' => 'header_search_advanced_typography',
			'options' => 'no-color',
		),
	),
	'header_search_advanced_input_padding' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_search_advanced_design',
		'default'      => webapp()->default( 'header_search_advanced_input_padding' ),
		'label'        => esc_html__( 'Input Padding', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form input.search-field',
				'property' => 'padding',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => true,
		),
	),
	// Button
	'header_search_advanced_buttons_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Button Background', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_buttons_background' ),
		'live_method'     => array(
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-submit',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-submit:hover',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
			'allowGradient' => true,
		),
	),
	'header_search_advanced_buttons_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Button Text', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_buttons_color' ),
		'live_method'     => array(
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-submit',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'global',
				'selector' => '.header-search-advanced form.search-form .search-submit:hover',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Hover Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'header_search_advanced_button_typography' => array(
		'control_type' => 'base_typography_control',
		'section'      => 'header_search_advanced_design',
		'label'        => esc_html__( 'Button Font', 'templatemela-core' ),
		'default'      => webapp()->default( 'header_search_advanced_button_typography' ),
		'live_method'     => array(
			array(
				'type'     => 'css_typography',
				'selector' => '.header-search-advanced form.search-form .search-submit[type=submit]',
				'pattern'  => array(
					'desktop' => '$',
					'tablet'  => '$',
					'mobile'  => '$',
				),
				'property' => 'font',
				'key'      => 'typography',
			),
		),
		'input_attrs'  => array(
			'id' => 'header_search_advanced_button_typography',
			'options' => 'no-color',
		),
	),
	'header_search_advanced_button_padding' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_search_advanced_design',
		'default'      => webapp()->default( 'header_search_advanced_button_padding' ),
		'label'        => esc_html__( 'Button Padding', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form .search-submit[type=submit]',
				'property' => 'padding',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	'header_search_advanced_button_radius' => array(
		'control_type' => 'base_measure_control',
		'section'      => 'header_search_advanced_design',
		'default'      => webapp()->default( 'header_search_advanced_button_radius' ),
		'label'        => esc_html__( 'Button Radius', 'templatemela-core' ),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.header-search-advanced form.search-form .search-submit[type=submit]',
				'property' => 'border-radius',
				'pattern'  => '$',
				'key'      => 'measure',
			),
		),
		'input_attrs'  => array(
			'responsive' => false,
		),
	),
	// Transparent
	'transparent_header_search_advanced_color' => array(
		'control_type' => 'base_color_control',
		'section'      => 'transparent_header_design',
		'label'        => esc_html__( 'Search Box Input Colors', 'templatemela-core' ),
		'default'      => webapp()->default( 'transparent_header_search_advanced_color' ),
		'context'      => array(
			array(
				'setting'  => '__device',
				'operator' => '==',
				'value'    => 'desktop',
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field, .transparent-header .header-search-advanced form.search-form .base-search-icon-wrap',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field:focus, .transparent-header .header-search-advanced form.search-form input.search-submit:hover ~ .base-search-icon-wrap, .transparent-header #main-header .header-search-advanced form.search-form button[type="submit"]:hover ~ .base-search-icon-wrap',
				'property' => 'color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Focus Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'transparent_header_search_advanced_background' => array(
		'control_type' => 'base_color_control',
		'section'      => 'transparent_header_design',
		'label'        => esc_html__( 'Search Box Input Background', 'templatemela-core' ),
		'default'      => webapp()->default( 'transparent_header_search_advanced_background' ),
		'context'      => array(
			array(
				'setting'  => '__device',
				'operator' => '==',
				'value'    => 'desktop',
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field:focus',
				'property' => 'background',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Focus Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
	'transparent_header_search_advanced_border' => array(
		'control_type' => 'base_color_control',
		'section'      => 'transparent_header_design',
		'label'        => esc_html__( 'Search Box Border Color', 'templatemela-core' ),
		'default'      => webapp()->default( 'transparent_header_search_advanced_border' ),
		'context'      => array(
			array(
				'setting'  => '__device',
				'operator' => '==',
				'value'    => 'desktop',
			),
		),
		'live_method'     => array(
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field',
				'property' => 'border-color',
				'pattern'  => '$',
				'key'      => 'color',
			),
			array(
				'type'     => 'css',
				'selector' => '.transparent-header .header-search-advanced form.search-form input.search-field:focus',
				'property' => 'border-color',
				'pattern'  => '$',
				'key'      => 'hover',
			),
		),
		'input_attrs'  => array(
			'colors' => array(
				'color' => array(
					'tooltip' => __( 'Initial Color', 'templatemela-core' ),
					'palette' => true,
				),
				'hover' => array(
					'tooltip' => __( 'Focus Color', 'templatemela-core' ),
					'palette' => true,
				),
			),
		),
	),
);
if ( class_exists( 'woocommerce' ) ) {
	$settings = array_merge(
		$settings,
		array(
			'header_search_advanced_woo' => array(
				'control_type' => 'base_switch_control',
				'section'      => 'header_search_advanced',
				'priority'     => 10,
				'default'      => webapp()->default( 'header_search_advanced_woo' ),
				'label'        => esc_html__( 'Search only Products?', 'templatemela-core' ),
				'transport'    => 'refresh',
			),
		)
	);
}

Theme_Customizer::add_settings( $settings );

