/**
 * Functions for archive pages.
 */
/* global tmCoreShop */
(
	function( $ ) {
		'use strict';

		var $body             = $( 'body' ),
		    $pageSidebars     = $( '.primary-sidebar' ),
		    Helpers           = window.tmcore.Helpers,
		    collapseDuration  = 250,
		    COLLAPSED_CLASS   = 'collapsed',
		    COLLAPSIBLE_CLASS = 'sidebar-widgets-collapsible';

		$( document ).ready( function() {
			
			if ( tmCoreShop.is_collapsable == true ) {
                $('.sidebar-slug-sidebar-woocommerce-shop').addClass( 'sidebar-widgets-collapsible' );
            }
			
			initArchiveSidebarWidgetsCollapsible();
			
			
			$( document.body ).on( 'click', '.tmcore-wp-widget-filter .filter-link', function( evt ) {
				evt.preventDefault();
				var $link = $( this ),
				    $item = $link.parent( 'li' ),
				    $list = $link.closest( 'ul' ),
				    href  = $link.attr( 'href' );

				if ( $list.hasClass( 'single-choice' ) ) {
					if ( $item.hasClass( 'chosen' ) ) {
						return;
					}
					$item.addClass( 'chosen' ).siblings().removeClass( 'chosen' );
				} else {
					$link.parent( 'li' ).toggleClass( 'chosen' );
				}

				var $thisSidebar = $( this ).closest( '.primary-sidebar' );
				if ( $thisSidebar.length > 0 ) {
					$body.removeClass( 'off-sidebar-opened' );
					$thisSidebar.removeClass( 'off-sidebar-active' );
					Helpers.unsetBodyOverflow();
				}
				filterProductsByUrl( href );
			} );

			$( document.body ).on( 'click', '.js-product-filter-link', function( evt ) {
				evt.preventDefault();
				var $link = $( this );
				if ( $link.hasClass( 'disabled' ) ) {
					return;
				}
				var href = $link.attr( 'href' );
				filterProductsByUrl( href );
			} );

			$( document.body ).on( 'change', '.tmcore-wp-widget-product-layered-nav-dropdown', function() {
				var $form         = $( this ).closest( 'form' ),
				    $filter_input = $form.find( '.filter-name' ),
				    slug          = $( this ).val();
				$filter_input.val( slug );
				$form.trigger( 'submit' );
			} );

			$( document.body ).on( 'submit', '.tmcore-wp-widget-product-layered-nav-form', function() {
				var $form       = $( this ),
				    $filterName = $form.find( '.filter-name' ),
				    $queryType  = $form.find( '.filter-query-type' ),
				    filterVal   = $filterName.val(),
				    href        = $form.attr( 'action' );

				href = Helpers.addUrlParam( href, $filterName.attr( 'name' ), filterVal );
				if ( $queryType.length > 0 ) {
					if ( '' === filterVal ) {
						href = Helpers.removeUrlParam( href, $queryType.attr( 'name' ) );
					} else {
						href = Helpers.addUrlParam( href, $queryType.attr( 'name' ), $queryType.val() );
					}
				}
				filterProductsByUrl( href );
				return false;
			} );

			$( document.body ).on( 'click', '.woocommerce-pagination a.page-numbers', function( evt ) {
				evt.preventDefault();
				filterProductsByUrl( $( this ).attr( 'href' ), { scrollTop: 1 } );
			} );

			/* $( document.body ).on( 'click', '.load-more-button', function( evt ) {
				evt.preventDefault();
				filterProductsByUrl( $( this ).attr( 'data-url' ), { loadMore: 1, loadNext: 1 } );
			} ); */

			$( document.body ).on( 'change', '.woocommerce-ordering select.orderby', function( evt ) {
				evt.preventDefault();
				var url = Helpers.addUrlParam( window.location.href, 'orderby', $( this ).val() );
				filterProductsByUrl( url );
				return false;
				
			} );

			$( document.body ).on( 'submit', 'form.woocommerce-ordering', function( evt ) {
				evt.preventDefault();
				return false;
			} );


			$( document.body ).on( 'click', '.tmcore-wp-widget-product-sorting .order-by a', function( evt ) {
				evt.preventDefault();
				var url = Helpers.addUrlParam( window.location.href, 'orderby', $( this ).data( 'order' ) );
				filterProductsByUrl( url );
				
			} );


			
			$('.content-wrap[data-infinite-scroll]').on( 'append.infiniteScroll', function( event, body, path, items, response ) {
				//console.log(`Appended ${items.length} items on ${path}`);
				//console.log($(this).find('.entry').length);
				//console.log(`total ${$(this).find('.entry').length} items `);
				
				// get Infinite Scroll instance
				//let infScroll = $('.content-wrap[data-infinite-scroll]').data('infiniteScroll');
				
				let Showing = $('.woocommerce-result-count .showing').text();
				let resultItems = $('.woocommerce-result-count .result').text();
				let totalShow = Number(Showing) + Number(tmCoreShop.per_page);
				let totalItems =  Number(resultItems);

				if ( totalShow >= totalItems ) {
					totalShow = totalItems;
				}

				//console.log(' Showing ' + Showing);
				//console.log(' totalShow ' + totalShow );
				//console.log(' totalItems ' + totalItems );

				if ( totalShow >= totalItems ) {
					Showing = totalItems;
				} else {
					Showing = totalShow;
				}
				//console.log( infScroll.loadCount + ' &  ' + infScroll.pageIndex );
				//console.log(tmCoreShop.total);
				//console.log(tmCoreShop.per_page);
				//console.log(tmCoreShop.current);
				$('.woocommerce-result-count .showing').text( Showing );

				initCountDownTimer();
				
				$(window).trigger('tmcore_lazy_load'); // Call lazy load script
				$(window).trigger('tmcore_lazy_shimmer'); // Call lazy load shimmer script

				if ( totalShow < totalItems ) {
					$('.products.ajax-load').show();
				} else if ( totalShow == totalItems ) {
					$('.products.ajax-load').hide();
				}

			});


		} );

		function filterProductsByUrl( url, options = {} ) {
			var settings = $.extend( true, {}, {
				loadMore: 0,
				scrollTop: 0,
				loadNext: 0
			}, options );

			url = decodeURIComponent( url );

			if ( ! settings.loadMore ) {
				history.pushState( {}, null, url );
			}

			var $btnLoadMore = $( '.load-more-button' );

			$.ajax( {
				url: url,
				type: 'GET',
				dataType: 'html',
				success: function( response ) {
					var $response = $( response );

					var $gridWrapper = $( '.woo-archive-loop' );

					if ( ! settings.loadMore && ! settings.loadNext ) {
						$gridWrapper.children( '.woo-archive-loop' ).children( '.entry' ).remove();
					}

					var $pagination = $response.find( '.woocommerce-pagination .page-numbers' );
					//console.log( $pagination );

					var $newItems = $response.find( '.woo-archive-loop .entry' );
					
					if ( settings.loadNext || settings.loadMore ) {
						$gridWrapper.append($newItems);
					} else {
					$gridWrapper.html($newItems);
					}

					var fragments = [
						'.woocommerce-result-count',
						'.woocommerce-pagination',
						'.load-more-wrap',
						'#active-filters-bar',
						'.order-by',
						'.orderby',
						'.page-load-status',
					];

					var $filterWidgets = $( '.tmcore-wp-widget-filter' );

					$filterWidgets.each( function() {
						var id = $( this ).attr( 'id' );
						fragments.push( '#' + id );
					} );

					var totalFragments = fragments.length;

					for ( var i = 0; i < totalFragments; i ++ ) {
						var key  = fragments[ i ],
						    $key = $( key );

						if ( $key.length > 0 ) {
							$key.empty();
							var $newElement = $response.find( key );
							if ( $newElement.length > 0 ) {
								$key.replaceWith( $newElement );
							}
						}
					}

					$( document.body ).trigger( 'tmcore_get_product_fragments_loaded' );

					if ( settings.scrollTop ) {
						var offsetTop = $gridWrapper.offset().top;
						offsetTop -= 198; // Header + topbar + filter bar.
						offsetTop = Math.max( 0, offsetTop );

						$( 'html, body' ).animate( { scrollTop: offsetTop }, 300 );
					}

					// Disable collapse if it open before.
					$pageSidebars.each( function() {
						var $thisSidebar = $( this );
						if ( $thisSidebar.hasClass( COLLAPSIBLE_CLASS ) ) {
							$thisSidebar.find( '.widget:not(.' + COLLAPSED_CLASS + ')' ).find( '.widget-content' ).stop().slideDown( collapseDuration );
						}
					} );

					// Update Widget Scrollable size.
					if ( $.fn.perfectScrollbar && ! Helpers.isHandheld() ) {
						$pageSidebars.find( '.widget-scrollable' ).each( function() {
							$( this ).find( '.widget-content-inner' ).perfectScrollbar( 'update' );
						} );
					}

					//var $pagination = $response.find( '.woocommerce-pagination' );
					//console.log( $response );
					if ( $pagination.length > 0 ) {
						
						//if ( $response.find( '.woocommerce-pagination .next.page-numbers' ).length > 0 ) {
						// Reload Infinite Scroll
						reloadScrollInfinite();
						$('.load-more-wrap .shop-load-more-button').attr("style", "display:unset");
						//console.log( ' pages');
						//}
					} else {
						//console.log( ' no pages ');
					}
					//console.log( $pagination.length);
					//console.log( $pagination );

					initCountDownTimer();
					
					$(window).trigger('tmcore_lazy_load'); // Call lazy load script
					$(window).trigger('tmcore_lazy_shimmer'); // Call lazy load shimmer script
					
					
				},
				beforeSend: function() {
					if ( settings.loadMore ) {
						Helpers.setElementHandling( $btnLoadMore );
					} else {
						Helpers.setBodyHandling();
					}
				},
				complete: function() {
					if ( settings.loadMore ) {
						Helpers.unsetElementHandling( $btnLoadMore );
					} else {
						Helpers.setBodyCompleted();
					}
				}
			} );
		}

		// Reload Infinite Scroll
		function reloadScrollInfinite() {

			var infScrollContainer = document.querySelector( '.content-wrap[data-infinite-scroll]' );

			if ( infScrollContainer ) {

				let parsedData = JSON.parse( infScrollContainer.dataset.infiniteScroll );
				var infScroll = new InfiniteScroll( '.content-wrap[data-infinite-scroll]', {
					path: parsedData.path,
					append: parsedData.append,
					hideNav:parsedData.hideNav,
					status: parsedData.status,
				} );
				//infScroll.destroy();

				infScroll.isLoading = false;
				infScroll.canLoad = true;
				infScroll.create();
			}

		}


		
		function initCountDownTimer() {

			var Countdown = function ($countdown, endTime, $) {
				var timeInterval,
					elements = {
						$daysSpan: $countdown.find('.countdown-days'),
						$hoursSpan: $countdown.find('.countdown-hours'),
						$minutesSpan: $countdown.find('.countdown-minutes'),
						$secondsSpan: $countdown.find('.countdown-seconds')
					};
		
				var updateClock = function () {
					var timeRemaining = Countdown.getTimeRemaining(endTime);
		
					$.each(timeRemaining.parts, function (timePart) {
						var $element = elements['$' + timePart + 'Span'],
							partValue = this.toString();
		
						if (1 === partValue.length) {
							partValue = 0 + partValue;
						}
		
						if ($element.length) {
							$element.text(partValue);
						}
					});
		
					if (timeRemaining.total <= 0) {
						clearInterval(timeInterval);
					}
				};
		
				var initializeClock = function () {
					updateClock();
		
					timeInterval = setInterval(updateClock, 1000);
				};
		
				initializeClock();
			};
			Countdown.getTimeRemaining = function (endTime) {
				var timeRemaining = endTime - new Date(),
					seconds = Math.floor((timeRemaining / 1000) % 60),
					minutes = Math.floor((timeRemaining / 1000 / 60) % 60),
					hours = Math.floor((timeRemaining / (1000 * 60 * 60)) % 24),
					days = Math.floor(timeRemaining / (1000 * 60 * 60 * 24));
		
				if (days < 0 || hours < 0 || minutes < 0) {
					seconds = minutes = hours = days = 0;
				}
		
				return {
					total: timeRemaining,
					parts: {
						days: days,
						hours: hours,
						minutes: minutes,
						seconds: seconds
					}
				};
			};

			var $element = $('[data-countdown="true"]');
			//console.log( $element);
			$element.each(function (index, el) {
				//console.log( 'index:' + index );
				//console.log( el );
				var date = new Date($(this).data('date') * 1000);
				new Countdown($(this), date, $);
			});

		}

		function initArchiveSidebarWidgetsCollapsible() {
			if ( 0 >= $pageSidebars.length ) {
				return;
			}

			$pageSidebars.find( '.widget' ).each( function() {
				var $widget = $( this );

				if ( $widget.hasClass( 'widget_block' ) ) { // Fix block group.
					return true;
				}

				// Wrap content with new div.
				$widget.children().not( '.widget-title, .widgettitle, .widget-instance, .widget-content' ).wrapAll( '<div class="widget-content"><div class="widget-content-inner"></div></div>' );

				if ( $widget.hasClass( 'widget-scrollable' ) && $.fn.perfectScrollbar && ! Helpers.isHandheld() ) {
					$widget.find( '.widget-content-inner' ).perfectScrollbar();
				}
			} );

			$pageSidebars.each( function() {
				var $thisSidebar = $( this );
				if ( $thisSidebar.hasClass( COLLAPSIBLE_CLASS ) ) {
					$thisSidebar.on( 'click', '.widget-title, .widgettitle', function( evt ) {
						var $widget = $( this ).closest( '.widget' );
						if ( $widget.hasClass( COLLAPSED_CLASS ) ) {
							$widget.removeClass( COLLAPSED_CLASS );
							$widget.find( '.widget-content' ).stop().slideDown( collapseDuration );
						} else {
							$widget.addClass( COLLAPSED_CLASS );
							$widget.find( '.widget-content' ).stop().slideUp( collapseDuration );
						}
					} );
				}
			} );
		}

	}( jQuery )
);
