<?php
/**
 * Base Update Checker
 * https://templatemela.com
 *
 * Released under the MIT license.
 *
 * @package Base WP Products
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require dirname(__FILE__) . '/inc/InstalledPackage.php';
require dirname(__FILE__) . '/inc/Metadata.php';
require dirname(__FILE__) . '/inc/OAuthSignature.php';
require dirname(__FILE__) . '/inc/Scheduler.php';
require dirname(__FILE__) . '/inc/StateStore.php';
require dirname(__FILE__) . '/inc/Update.php';
require dirname(__FILE__) . '/inc/UpdateChecker.php';
require dirname(__FILE__) . '/inc/UpgraderStatus.php';
require dirname(__FILE__) . '/inc/Utils.php';
// Theme.
require dirname(__FILE__) . '/inc/Theme/UpdateChecker.php';
require dirname(__FILE__) . '/inc/Theme/Update.php';
require dirname(__FILE__) . '/inc/Theme/Package.php';
// Plugin.
require dirname(__FILE__) . '/inc/Plugin/UpdateChecker.php';
require dirname(__FILE__) . '/inc/Plugin/Update.php';
require dirname(__FILE__) . '/inc/Plugin/Ui.php';
require dirname(__FILE__) . '/inc/Plugin/Package.php';
require dirname(__FILE__) . '/inc/Plugin/Info.php';
// Vendor.
require dirname(__FILE__) . '/inc/vendor/BasePucReadmeParser.php';
require dirname(__FILE__) . '/inc/vendor/Parsedown.php';
// Main File.
require dirname(__FILE__) . '/inc/Factory.php';

if ( defined( 'TMTHEME_ID' ) ) {
	$tmc_options = TemplateMelaCore_Settings::get_setting_option( 'tm_core_api_manager' ) ;
	$lkey = ( isset( $tmc_options['tm_core_api_key'] ) ) ? $tmc_options['tm_core_api_key'] : '';
	
	$response = wp_remote_get( 'https://data.templatemela.com/plugins/wp/templatemela-core/?key='.$lkey);
	if ( ( !is_wp_error($response)) && (200 === wp_remote_retrieve_response_code( $response ) ) ) {
	// Load activation API.
	if ( is_multisite() ) {
		$show_local_activation = apply_filters( 'base_activation_individual_multisites', false );
		if ( $show_local_activation ) {
			if ( 'Activated' === get_option( TMTHEME_ID.'_api_manager_activated' ) ) {
				$tmcore_updater = Base_Update_Checker::buildUpdateChecker(
					'https://data.templatemela.com/plugins/wp/templatemela-core/?key='.$lkey,
					TMCORE_PATH . 'templatemela-core.php',
					'templatemela-core'
				);
			}
		} else {
			if ( 'Activated' === get_site_option( TMTHEME_ID.'_api_manager_activated' ) ) {
				$tmcore_updater = Base_Update_Checker::buildUpdateChecker(
					'https://data.templatemela.com/plugins/wp/templatemela-core/?key='.$lkey,
					TMCORE_PATH . 'templatemela-core.php',
					'templatemela-core'
				);
			}
		}
	} elseif ( 'Activated' === get_option( TMTHEME_ID.'_api_manager_activated' ) ) {
		$tmcore_updater = Base_Update_Checker::buildUpdateChecker(
			'https://data.templatemela.com/plugins/wp/templatemela-core/?key='.$lkey,
			TMCORE_PATH . 'templatemela-core.php',
			'templatemela-core'
		);
	}
	}
	
}