<?php
/**
 * Layout functions and definitions.
 * by TemplateMela.
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 */


use function Base\webapp;
 
/*
 * Import Default Layout Styles
 *
 */
function harvest_tools_enqueue_styles() {
    wp_enqueue_style( 'harvest-tools-style',
        TMTHEME_URL . 'layouts/tools/style.css',
        array(),
        TMTHEME_VERSION
    );
    wp_enqueue_script( 'harvest-tools-js',
        TMTHEME_URL . 'layouts/tools/custom.js',
        array(),
        TMTHEME_VERSION
    );
}

add_action(  'wp_enqueue_scripts', 'harvest_tools_enqueue_styles' , 9999 );

/**
 * Setup Layout Theme Defaults
 *
 * @param array  registered option defaults with base theme.
 * @return array
 */
function harvest_layout_change_option_defaults( $defaults ) {
    $new_defaults = '{
        "post_content_style": "unboxed"
    }';
    $new_defaults = json_decode( $new_defaults, true );
    return wp_parse_args( $new_defaults, $defaults );
}
//add_filter( 'base_theme_options_defaults', 'harvest_layout_change_option_defaults', 20 );

/*
 * Set Default Logo
 * Filter the output of logo to fix Googles Error about itemprop logo
 */
add_filter( 'base_custom_logo', 'harvest_set_default_logo', 10, 2 );
function harvest_set_default_logo( $html, $blog_id ) {

	$custom_logo_id = webapp()->option( 'custom_logo' );
    // if logo is uploaded then return
    if ( ! empty($custom_logo_id) ) {
        return $html;
    }
    
    $custom_logo_path = TMTHEME_URL . 'layouts/tools/img/';
	$html = sprintf( '<a href="%1$s" class="custom-logo-link" rel="home" itemprop="url">%2$s</a>',
        esc_url( home_url( '/' ) ),
        '<img decoding="async" width="212" height="60" src="' . $custom_logo_path . 'logo.svg"  class="logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'logo.svg 479w, ' . $custom_logo_path . 'logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'logo.svg">');
        
        if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
            $custom_logo_id = webapp()->option( 'dark_mode_logo' );
            // if dark logo is uploaded then return
            if ( ! empty($custom_logo_id) ) {
                return $html;
            }
            $html .= sprintf( '<a href="%1$s" class="brand" rel="home" itemprop="url">%2$s</a>',
            esc_url( home_url( '/' ) ),
            '<img decoding="async" width="212" height="60" src="' . $custom_logo_path . 'dark-logo.svg"  class="base-dark-mode-logo svg-logo-image logo" alt="' . get_bloginfo( 'name' ) . '" loading="lazy" srcset="' . $custom_logo_path . 'dark-logo.svg 479w, ' . $custom_logo_path . 'dark-logo.svg 200w" sizes="(max-width: 479px) 100vw, 479px" data-src="' . $custom_logo_path . 'dark-logo.svg">');

	    }
    return $html;	
}


// Override default theme icons
add_filter( 'base_svg_icon', 'harvest_override_theme_icons', 10, 4 );
function harvest_override_theme_icons( $output, $icon, $icon_title = '', $base = true, $aria = false ) {
    if ( 'shopping-bag' === $icon ) {
        return '<span class="base-svg-iconset"><svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" class="thebase-svg-icon thebase-shopping-bag-svg" fill="currentColor" viewBox="0 0 488.01 402.54"><defs></defs><path class="cls-1" d="M862.91,447.81h194.33c-7.85-9.46-15.23-18.39-22.64-27.29q-20.76-25-41.55-49.92c-8.21-9.84-7.8-20.49,1.16-27.62a21.12,21.12,0,0,1,29.86,3.44c1,1.3,1.93,2.7,2.86,4.09q31.5,46.82,62.9,93.69c2,3,4.11,3.94,7.67,3.92,23.65-.17,47.3-.24,70.94,0,16.59.18,31.09,13.48,34.22,31.64,2.24,13,2,26.32.48,39.34-1.88,16-12.15,25.78-27,30.82a7.09,7.09,0,0,0-5.15,5.18q-24.4,77.52-49,155c-6.33,20-20.63,30.69-41.54,30.7q-120.44.06-240.87,0c-20.6,0-35.15-10.84-41.32-30.37q-24.51-77.49-49-155c-.93-3-2.25-4.54-5.36-5.55-17.48-5.62-27.54-19.55-27.42-37.91.09-14.47-1.07-29,1.55-43.37,2.69-14.78,9.75-20.54,24.69-20.54,26.64,0,53.29-.07,79.93.13,3.84,0,5.91-1.25,8-4.36q31.71-47.56,63.73-94.94c6.89-10.24,18.08-13.36,28.25-8.07,11.12,5.79,13.82,18.6,5.81,28.23q-30.51,36.69-61.12,73.29C866,444,864.66,445.62,862.91,447.81Zm97.41,110.08q-82.71,0-165.41-.09c-4.27,0-5.42.54-3.89,5.08q23,68.26,45.57,136.68c1.11,3.37,2.5,4.59,6.18,4.58q117.19-.18,234.37,0c3.56,0,5.11-1,6.26-4.46q22.51-68.17,45.35-136.24c1.84-5.53,1.83-5.54-4-5.54Zm-.71-36.76h48.45q77.18,0,154.35.08c3.65,0,4.89-.77,4.75-4.62-.32-8.48-.43-17,0-25.47.28-5.18-1.22-6.52-6.46-6.51q-200.55.22-401.11.12a17.22,17.22,0,0,1-2.49,0c-3.22-.45-4.31.78-4.23,4.11.22,9,.34,18,0,27-.19,4.43,1,5.47,5.45,5.46Q859,521,959.61,521.13Z" transform="translate(-716.3 -338.27)"/></svg></span>';
    }
    if ( 'account' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-account-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 64 64"><title>Account</title><path d="M41.2452,33.0349a16,16,0,1,0-18.49,0A26.0412,26.0412,0,0,0,4,58a2,2,0,0,0,2,2H58a2,2,0,0,0,2-2A26.0412,26.0412,0,0,0,41.2452,33.0349ZM20,20A12,12,0,1,1,32,32,12.0137,12.0137,0,0,1,20,20ZM8.09,56A22.0293,22.0293,0,0,1,30,36h4A22.0293,22.0293,0,0,1,55.91,56Z"></path>
        </svg></span>';
    }
    if ( 'search' === $icon ) {
        return '<span class="base-svg-iconset"><svg class="thebase-svg-icon thebase-search-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Search</title><path d="M16.041 15.856c-0.034 0.026-0.067 0.055-0.099 0.087s-0.060 0.064-0.087 0.099c-1.258 1.213-2.969 1.958-4.855 1.958-1.933 0-3.682-0.782-4.95-2.050s-2.050-3.017-2.050-4.95 0.782-3.682 2.050-4.95 3.017-2.050 4.95-2.050 3.682 0.782 4.95 2.050 2.050 3.017 2.050 4.95c0 1.886-0.745 3.597-1.959 4.856zM21.707 20.293l-3.675-3.675c1.231-1.54 1.968-3.493 1.968-5.618 0-2.485-1.008-4.736-2.636-6.364s-3.879-2.636-6.364-2.636-4.736 1.008-6.364 2.636-2.636 3.879-2.636 6.364 1.008 4.736 2.636 6.364 3.879 2.636 6.364 2.636c2.125 0 4.078-0.737 5.618-1.968l3.675 3.675c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414z"></path>
        </svg></span>';
    }
    if ( 'header-wishlist' === $icon ) {}
    
    return $output;
}


// Extra Footer top Row
function theme_middle_footer_widget ()  {
    echo '<div class="footer_middle_top_row"><div class="site-container">';
        dynamic_sidebar('footer2');
    echo '</div></div>';
}
add_action( 'base_middle_footer', 'theme_middle_footer_widget' );