<?php
/**
 * @package TemplateMela
 */
 
/**
 * Define the demo import files (remote files).
 *
 * To define imports, you just have to add the following code structure,
 * with your own values to your theme (using the 'tmsetup_import_files' filter).
 */
function prefix_tmsetup_import_files() {
	return array(
		array(
			'import_file_name'           => 'Default',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/default/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/default/',
		),
		array(
			'import_file_name'           => 'Furniture',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/furniture/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/furniture/',
		),
		array(
			'import_file_name'           => 'Electronics',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/electronics/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/electronics/',
		),
		array(
			'import_file_name'           => 'Medical',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/medical/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/medical/',
		),
		array(
			'import_file_name'           => 'Tools',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/tools/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/tools/',
		),
		array(
			'import_file_name'           => 'Jewellery',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/jewellery/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/jewellery/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/jewellery/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/jewellery/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/jewellery/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/jewellery/',
		),
		array(
			'import_file_name'           => 'Fashion',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/fashion/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/fashion/',
		),
		array(
			'import_file_name'           => 'Kitchen',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kitchen/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kitchen/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kitchen/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kitchen/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/kitchen/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/kitchen/',
		),
		array(
			'import_file_name'           => 'Homedecor',
			'import_file_url'            => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/homedecor/content.xml',
			'import_widget_file_url'     => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/homedecor/widgets.wie',
			'import_customizer_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/homedecor/customizer.dat',
			'import_rev_slider_file_url' => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/homedecor/slider.zip',
			'import_preview_image_url'   => 'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/demo-data/homedecor/preview.png',
			'import_notice'              => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-theme-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/homedecor/',
		),
	);
}
add_filter( 'tmsetup_import_files', 'prefix_tmsetup_import_files' );


/**
 * Define the demo import files (local files).
 */
function prefix_tmsetup_local_import_files() {
	return array(
		array(
			'import_file_name'             => 'Default',
			'local_import_file'            => TMTHEME_PATH . '/admin/demo-data/default/content.xml',
			'local_import_widget_file'     => TMTHEME_PATH . '/admin/demo-data/default/widgets.wie',
			'local_import_customizer_file' => TMTHEME_PATH . '/admin/demo-data/default/customizer.dat',
			'local_import_rev_slider_file' => TMTHEME_PATH . '/admin/demo-data/default/slider.zip',
			'import_preview_image_url'     => TMTHEME_URL . 'admin/demo-data/default/preview.png',
			'import_notice'                => __( 'After you import this demo, you will have to setup plugins separately.', 'templatemela-plugin-harvest' ),
			'preview_url'                => 'https://wordpressthemes.live/WCG1/WCM24_harvest/default/',
		),
	);
}
//add_filter( 'tmsetup_import_files', 'prefix_tmsetup_local_import_files' );

/**
 * Execute custom code after the whole import has finished.
 */
function prefix_tmsetup_after_import_setup( $selected_import_index ) {

	// Grab the selected import file.
	$selected_import_file = $GLOBALS['wizard']->import_files[ $selected_import_index ];
	if ( isset( $selected_import_file['import_file_name'] ) && 'default' != sanitize_title( strtolower( $selected_import_file['import_file_name'] ) ) ) {
        update_option( 'harvest_selected_layout', sanitize_title( strtolower( $selected_import_file['import_file_name'] ) ) );
    }

	// Assign menus to their locations.
	$main_menu = get_term_by( 'name', 'Primary Navigation', 'nav_menu' );
	$secondary_menu = get_term_by( 'name', 'Secondary Menu', 'nav_menu' );
	$vertical_menu = get_term_by( 'name', 'All Categories', 'nav_menu' );
	$mobile_secondary_menu = get_term_by( 'name', 'All Categories', 'nav_menu' );
	$footer_menu = get_term_by( 'name', 'Footer Navigation', 'nav_menu' );

	set_theme_mod(
		'nav_menu_locations',
		array(
			'primary'  => $main_menu->term_id,
			'secondary' => $secondary_menu->term_id,
			'vertical' => $vertical_menu->term_id,
			'mobile-secondary' => $mobile_secondary_menu->term_id,
			'footer-menu' => $footer_menu->term_id,
		)
	);

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title( 'Home' );
	$blog_page_id  = get_page_by_title( 'Blog' );

	update_option( 'show_on_front', 'page' );
	update_option( 'page_on_front', $front_page_id->ID );
	update_option( 'page_for_posts', $blog_page_id->ID );

	$woocommerce_shop = get_page_by_path( 'shop' );
	$woocommerce_checkout = get_page_by_path( 'checkout' );
	$woocommerce_cart = get_page_by_path( 'cart' );
	$woocommerce_myaccount = get_page_by_path( 'my-account' );

	update_option( 'woocommerce_cart', $woocommerce_cart->ID );
	update_option( 'woocommerce_checkout_page_id', $woocommerce_checkout->ID );
	update_option( 'woocommerce_cart_page_id', $woocommerce_cart->ID );
	update_option( 'woocommerce_myaccount_page_id', $woocommerce_myaccount->ID );
	update_option( 'woocommerce_shop_page_id', $woocommerce_shop->ID );

	$layout = sanitize_title( strtolower( $selected_import_file['import_file_name'] ) );
	if( ! empty( $layout ) &&  'default' != $layout ) {
		require_once TMTHEME_PATH . '/layouts/'.$layout.'/import-settings.php';
	} else {
		require_once TMTHEME_PATH . '/layouts/default/import-settings.php';
	}
	update_option( 'bt_woo_extras', json_encode( $import_settings ) );

	if ( class_exists( '\Elementor\Plugin' ) ) {
		// Default Pages
		$cpt_support = get_option( 'elementor_cpt_support' );
		if ( ! $cpt_support ) {
			$cpt_support = array( 'page', 'post', 'base_element' );
			update_option( 'elementor_cpt_support', $cpt_support );
		} else if ( ! in_array( 'base_element', $cpt_support ) ) {
			$cpt_support[] = 'base_element';
			update_option( 'elementor_cpt_support', $cpt_support );
		}
		// Disable Default Colors
		update_option( 'elementor_disable_color_schemes', 'yes' );
		update_option( 'elementor_disable_typography_schemes', 'yes' );

		update_option( 'elementor_experiment-block_editor_assets_optimize', 'inactive' );
		
		\Elementor\Plugin::$instance->files_manager->clear_cache();

	}
	// compare settings
	update_option('woosc_settings', array('button_icon' => 'left' , 'quick_table_label' => 'yes', 'perfect_scrollbar' => 'no' ) );
	// quick view settings
	update_option('woosq_settings', array('button_icon' => 'left' , 'button_position' => '0', 'perfect_scrollbar' => 'no'));
	// wishlist settings
	update_option('woosw_settings', array('button_icon' => 'left', 'perfect_scrollbar' => 'no'));

	update_option('woosq_button_position', '0');
	update_option('_wooscp_button_archive', '0');
	update_option('woosw_button_position_archive', '0');

}
add_action( 'tmsetup_after_all_import', 'prefix_tmsetup_after_import_setup' );