<?php
/**
 * Base Update Checker
 * https://templatemela.com
 *
 * Released under the MIT license.
 *
 * @package Base WP Products
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

require dirname(__FILE__) . '/inc/InstalledPackage.php';
require dirname(__FILE__) . '/inc/Metadata.php';
require dirname(__FILE__) . '/inc/OAuthSignature.php';
require dirname(__FILE__) . '/inc/Scheduler.php';
require dirname(__FILE__) . '/inc/StateStore.php';
require dirname(__FILE__) . '/inc/Update.php';
require dirname(__FILE__) . '/inc/UpdateChecker.php';
require dirname(__FILE__) . '/inc/UpgraderStatus.php';
require dirname(__FILE__) . '/inc/Utils.php';
// Theme.
require dirname(__FILE__) . '/inc/Theme/UpdateChecker.php';
require dirname(__FILE__) . '/inc/Theme/Update.php';
require dirname(__FILE__) . '/inc/Theme/Package.php';
// Plugin.
require dirname(__FILE__) . '/inc/Plugin/UpdateChecker.php';
require dirname(__FILE__) . '/inc/Plugin/Update.php';
require dirname(__FILE__) . '/inc/Plugin/Ui.php';
require dirname(__FILE__) . '/inc/Plugin/Package.php';
require dirname(__FILE__) . '/inc/Plugin/Info.php';
// Vendor.
require dirname(__FILE__) . '/inc/vendor/BasePucReadmeParser.php';
require dirname(__FILE__) . '/inc/vendor/Parsedown.php';
// Main File.
require dirname(__FILE__) . '/inc/Factory.php';

if ( defined( 'TMTHEME_ID' ) ) {
	if ( class_exists( 'TemplateMelaCore_Settings' ) ) {
		$tmc_options = TemplateMelaCore_Settings::get_setting_option( 'tm_core_api_manager' ) ;
	}
	$lkey = ( isset( $tmc_options['tm_core_api_key'] ) ) ? $tmc_options['tm_core_api_key'] : '';
	// Load activation API.
	if ( is_multisite() ) {
		$show_local_activation = apply_filters( 'templatemela_activation_individual_multisites', false );
		if ( $show_local_activation ) {
			if ( 'Activated' === get_option( TMTHEME_ID.'_api_manager_activated' ) ) {
				$templatemela_plugin_updater = Base_Update_Checker::buildUpdateChecker(
					'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/?key='.$lkey,
					TMTHEME_PATH . '/templatemela-plugin-harvest.php',
					'templatemela-plugin-harvest'
				);
			}
		} else {
			if ( 'Activated' === get_site_option( TMTHEME_ID.'_api_manager_activated' ) ) {
				$templatemela_plugin_updater = Base_Update_Checker::buildUpdateChecker(
					'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/?key='.$lkey,
					TMTHEME_PATH . '/templatemela-plugin-harvest.php',
					'templatemela-plugin-harvest'
				);
			}
		}
	} elseif ( 'Activated' === get_option( TMTHEME_ID.'_api_manager_activated' ) ) {
		$templatemela_plugin_updater = Base_Update_Checker::buildUpdateChecker(
			'https://data.templatemela.com/themes/'.TMTHEME_GROUP_ID.'/'.TMTHEME_ID.'/?key='.$lkey,
			TMTHEME_PATH . '/templatemela-plugin-harvest.php',
			'templatemela-plugin-harvest'
		);
	}
}