<?php
/**
 * Class to build advanced Reviews.
 * Credit to free yith advanced reviews, lots of code based from that.
 *
 * @package Base Shop Kit
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * The Advanced Reviews class.
 */
class Base_Advanced_Reviews {
	/**
	 * Instance of this class
	 *
	 * @var null
	 */
	private static $instance = null;

	private static $review_query = null;
	private static $review_avg_query = null;
	public $review_meta_rating = '_bt_review_rating';
	public $review_meta_product_id = '_bt_review_product_id';
	public $review_meta_imported = '_bt_review_imported';
	public $review_meta_approved = '_bt_review_approved';
	public $review_meta_comment_id = '_bt_review_comment_id';
	public $review_meta_upvotes_count = '_bt_review_upvotes';
	public $review_meta_downvotes_count = '_bt_review_downvotes';
	public $review_meta_votes = '_bt_review_votes';
	public $review_meta_voters = '_bt_review_voters';
	public $review_meta_voter_guests = '_bt_review_voter_guests';
	public $review_meta_featured = '_bt_review_is_featured';
	public $review_meta_stop_reply = '_bt_review_is_reply_blocked';
	public $review_meta_review_user_id = '_bt_review_user_id';
	public $review_meta_review_author = '_bt_review_author';
	public $review_meta_review_author_email = '_bt_review_author_email';
	public $review_meta_review_author_url = '_bt_review_author_url';
	public $review_meta_review_author_ip = '_bt_review_author_IP';
	public $review_meta_review_consent = '_bt_review_consent';

	/**
	 * Instance Control
	 */
	public static function get_instance() {
		if ( is_null( self::$instance ) ) {
			self::$instance = new self();
		}
		return self::$instance;
	}
	/**
	 * Class Constructor.
	 */
	public function __construct() {
		add_action( 'admin_menu', array( $this, 'bt_add_menu_item' ) );
		add_action( 'init', array( $this, 'bt_woo_reviews_post' ), 10 );
		if ( is_admin() ) {
			add_action( 'do_meta_boxes', array( $this, 'bt_woo_remove_revolution_slider_meta_boxes' ), 10 );
		}
		add_action( 'admin_init', array( $this, 'bt_check_import_actions' ) );
		add_action( 'wp_ajax_bt_review_convert', array( $this, 'convert_reviews_callback' ) );

		add_action( 'wp_ajax_nopriv_bt_review_vote', array( $this, 'bt_vote_callback_guest' ) );
		add_action( 'wp_ajax_bt_review_vote', array( $this, 'bt_vote_callback' ) );

		add_action( 'wp_ajax_bt_review_readmore', array( $this, 'bt_review_readmore' ) );
		add_action( 'wp_ajax_nopriv_bt_review_readmore', array( $this, 'bt_review_readmore' ) );

		add_filter( 'comments_template', array( $this, 'bt_reviews_template' ), 99 );
		add_action( 'bt_before_review_list', array( $this, 'bt_reviews_summary' ) );
		add_filter( 'wc_get_template', array( $this, 'bt_wc_get_template' ), 99, 5 );
		add_action( 'comment_post', array( $this, 'bt_submit_review' ) );
		add_filter( 'bt_reviews_review_content', 'wpautop' );
		add_filter( 'cmb2_admin_init', array( $this, 'add_metaboxes' ) );
		add_filter( 'woocommerce_product_tabs', array( $this, 'bt_update_tab_reviews_count' ), 20 );
		// add_filter( 'woocommerce_product_get_rating_html', array( $this, 'bt_get_product_rating_html' ), 99, 2 );

		$shopkit_settings = get_option( 'bt_woo_extras' );
		if ( ! is_array( $shopkit_settings ) ) {
			$shopkit_settings = json_decode( $shopkit_settings, true );
		}
		if ( isset( $shopkit_settings['bt_reviews_multi'] ) && 1 == $shopkit_settings['bt_reviews_multi'] ) {
			add_filter( 'base_woo_advanced_review_arg_default', array( $this, 'bt_add_polylang_support' ), 99, 2 );
			add_filter( 'base_woo_advanced_review_arg_average_query', array( $this, 'bt_add_polylang_average_support' ), 99, 2 );
		}

		add_action( 'admin_action_approve-review', array( $this, 'bt_update_review_attributes' ) );
		add_action( 'admin_action_unapprove-review', array( $this, 'bt_update_review_attributes' ) );
		add_action( 'admin_action_untrash-review', array( $this, 'bt_update_review_attributes' ) );
		add_action( 'admin_action_trash-review', array( $this, 'bt_update_review_attributes' ) );

		add_filter( 'post_class', array( $this, 'bt_add_review_table_class' ), 10, 3 );
		add_filter( 'bt_reviews_row_actions', array( $this, 'bt_add_review_actions' ), 10, 2 );

		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_styles_scripts' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_admin_import_scripts' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'script_enqueue' ), 80 );
	}
	/**
	 * Add Frontend Scripts.
	 */
	public function script_enqueue() {
		if ( is_singular( 'product' ) ) {
			wp_enqueue_style( 'base_reviews_css', TMCORE_WOO_URL . 'lib/reviews/css/bt_woo_reviews.css', false, TMCORE_VERSION );
			global $product;
			wp_register_script( 'bt_woo_reviews', TMCORE_WOO_URL . 'lib/reviews/js/min/bt_woo_reviews-min.js', array( 'jquery' ), TMCORE_VERSION, true );
			$translation_array = array(
				'is_user_logged_in' => is_user_logged_in(),
				'user_id' => get_current_user_id(),
				'product_id' => get_the_ID(),
				'nonce' => wp_create_nonce( 'bt_reviews' ),
				'error' => __( 'An error occurred, please try again later', 'templatemela-core' ),
				'nomoreviews' => __( 'There are no more reviews', 'templatemela-core' ),
				'required_consent_text' => __( 'Please check required consent checkbox', 'templatemela-core' ),
			);
			wp_localize_script( 'bt_woo_reviews', 'bt_product_reviews', $translation_array );
			wp_enqueue_script( 'bt_woo_reviews' );

		}
	}

	public function bt_add_menu_item() {

		$args = apply_filters(
			'bt_wc_product',
			array(
				'page_title' => __( 'Reviews', 'templatemela-core' ),
				'menu_title' => __( 'Reviews', 'templatemela-core' ),
				'capability' => 'edit_products',
				'menu_slug'  => __( 'bt_reviews', 'templatemela-core' ),
				'function'   => array( $this, 'show_reviews_table' ),
				'icon'       => 'dashicons-star-filled',
				'position'   => '26.3',
			)
		);

		extract( $args );
		add_menu_page( $page_title, $menu_title, $capability, $menu_slug, $function, $icon, $position );
	}
	public function show_reviews_table() {
		if ( ! class_exists( 'WP_Posts_List_Table' ) ) {
			require_once( ABSPATH . 'wp-admin/includes/class-wp-posts-list-table.php' );
		}

		require_once( TMCORE_WOO_PATH . '/lib/reviews/bt-admin-reviews-list.php' );

		$product_reviews = new BT_Admin_Reviews_List();
		$product_reviews->bt_prepare_items();

		wc_get_template( 'bt-admin-reviews.php', array( 'product_reviews' => $product_reviews ), TMCORE_WOO_PATH . 'lib/reviews/', TMCORE_WOO_PATH . '/lib/reviews/' );
	}

	// Add Review post type
	public function bt_woo_reviews_post() {
			$reviewlabels = array(
			'name'               => __( 'Reviews', 'templatemela-core' ),
			'singular_name'      => __( 'Review', 'templatemela-core' ),
			'add_new'            => __( 'Add Review', 'templatemela-core' ),
			'add_new_item'       => __( 'Add New Review', 'templatemela-core' ),
			'edit_item'          => __( 'Edit Review', 'templatemela-core' ),
			'new_item'           => __( 'New Review', 'templatemela-core' ),
			'all_items'          => __( 'All Reviews', 'templatemela-core' ),
			'view_item'          => __( 'View Review', 'templatemela-core' ),
			'search_items'       => __( 'Search Review', 'templatemela-core' ),
			'not_found'          => __( 'No Review found', 'templatemela-core' ),
			'not_found_in_trash' => __( 'No Reviews found in Trash', 'templatemela-core' ),
			'parent_item_colon'  => '',
			'menu_name'          => __( 'Reviews', 'templatemela-core' ),
			);

			$reviewargs = array(
				'labels' => $reviewlabels,
				'public' => true,
				'publicly_queryable' => false,
				'show_ui' => true,
				'exclude_from_search' => true,
				'show_in_menu' => false,
				'query_var' => false,
				'rewrite'  => false,
				'has_archive' => false,
				'capability_type' => 'page',
				'hierarchical' => false,
				'menu_position' => null,
				'menu_icon' => 'dashicons-star-filled',
				'supports' => array( 'title', 'editor' ),
			);

			register_post_type( 'bt_reviews', $reviewargs );
	}
	// Remove annoying revslider from it.
	public function bt_woo_remove_revolution_slider_meta_boxes() {
		remove_meta_box( 'mymetabox_revslider_0', 'bt_reviews', 'normal' );
	}

	/**
	 * Create new Review post type when a comment is saved to database
	*/
	public function bt_submit_review( $comment_id ) {
		if ( ! isset( $_POST ) ) {
			return;
		}
		$comment = get_comment( $comment_id );

		if ( get_post_type( $comment->comment_post_ID ) != 'product' ) {
			return;
		}

		$review_title = isset( $_POST['title'] ) ? wp_strip_all_tags( $_POST['title'] ) : '';

		$review_consent = isset( $_POST['consent'] ) ? wp_strip_all_tags( $_POST['consent'] ) : '';

		$post_parent = apply_filters( 'bt_reviews_post_parent', $_POST['comment_parent'] );

		// Create post object
		$review_post = array(
			'post_author'         => $comment->user_id,
			'post_title'          => $review_title,
			'post_content'        => $comment->comment_content,
			'post_status'         => 'publish',
			'post_author'         => get_current_user_id(),
			'post_type'           => 'bt_reviews',
			'post_parent'         => $post_parent,
			'review_comment_id'   => $comment_id,
			'review_user_id'      => $comment->user_id,
			'review_rating'       => ( isset( $_POST['rating'] ) ? $_POST['rating'] : 0 ),
			'review_product_id'   => $comment->comment_post_ID,
			'review_approved'     => $comment->comment_approved,
			'review_author'       => $comment->comment_author,
			'review_author_email' => $comment->comment_author_email,
			'review_author_url'   => $comment->comment_author_url,
			'review_author_IP'    => $comment->comment_author_IP,
			'review_consent'      => $review_consent,
		);

		$review_id = $this->bt_add_review( $review_post );
		update_comment_meta( $comment->comment_ID, $this->review_meta_imported, 1 );

	}

	public function bt_add_review( $args ) {
		// Create post object.
		$defaults = array(
			'post_title'                 => '',
			'post_content'               => '',
			'post_status'                => 'publish',
			'post_author'                => 0,
			'post_type'                  => 'bt_reviews',
			'post_parent'                => 0,
			'review_user_id'             => 0,
			'review_approved'            => 1,
			'review_rating'              => 0,
			'review_product_id'          => 0,
			'review_comment_id'          => 0,
			'review_upvotes'             => 0,
			'review_downvotes'           => 0,
			'review_votes'               => 0,
			'review_voters'              => array(),
			'review_voter_guests'        => array(),
			'review_is_featured'         => 0,
			'review_is_reply_blocked'    => 1,
			'review_author'              => '',
			'review_author_email'        => '',
			'review_author_url'          => '',
			'review_author_IP'           => '',
			'review_consent'            => '',
		);

		$args = wp_parse_args( $args, $defaults );

		$review_id = wp_insert_post( $args );

		if ( 0 != $args['post_parent'] ) {
			update_post_meta( $review_id, $this->review_meta_rating, 0 );
		} else {
			update_post_meta( $review_id, $this->review_meta_rating, $args['review_rating'] );
		}

		update_post_meta( $review_id, $this->review_meta_rating, $args['review_rating'] );
		update_post_meta( $review_id, $this->review_meta_approved, $args['review_approved'] );
		update_post_meta( $review_id, $this->review_meta_product_id, $args['review_product_id'] );
		update_post_meta( $review_id, $this->review_meta_comment_id, $args['review_comment_id'] );

		update_post_meta( $review_id, $this->review_meta_upvotes_count, $args['review_upvotes'] );
		update_post_meta( $review_id, $this->review_meta_downvotes_count, $args['review_downvotes'] );
		update_post_meta( $review_id, $this->review_meta_votes, $args['review_votes'] );
		update_post_meta( $review_id, $this->review_meta_voters, $args['review_voters'] );

		update_post_meta( $review_id, $this->review_meta_featured, $args['review_is_featured'] );
		update_post_meta( $review_id, $this->review_meta_stop_reply, $args['review_is_reply_blocked'] );

		update_post_meta( $review_id, $this->review_meta_review_user_id, $args['review_user_id'] );
		update_post_meta( $review_id, $this->review_meta_review_author, $args['review_author'] );
		update_post_meta( $review_id, $this->review_meta_review_author_email, $args['review_author_email'] );
		update_post_meta( $review_id, $this->review_meta_review_author_url, $args['review_author_url'] );
		update_post_meta( $review_id, $this->review_meta_review_author_ip, $args['review_author_IP'] );
		update_post_meta( $review_id, $this->review_meta_review_consent, $args['review_consent'] );
		return $review_id;
	}
	/**
	 * Ajax Call build post loop
	 */
	public function bt_review_readmore() {
		if ( ! isset( $_POST['wpnonce'] ) || ! wp_verify_nonce( $_POST['wpnonce'], 'bt_reviews' ) ) {
			return false;
		}
		if ( ! isset( $_POST['args'] ) ) {
			return false;
		} else {
			$args = wp_unslash( $_POST['args'] );
		}
		if ( ! isset( $_POST['product_id'] ) ) {
			return false;
		} else {
			$product_id = absint( wp_unslash( $_POST['product_id'] ) );
		}
		if ( ! isset( $_POST['offset'] ) ) {
			return false;
		} else {
			$offset = absint( wp_unslash( $_POST['offset'] ) );
		}
		$args['offset'] = $offset;
		ob_start();
		$this->bt_reviews_list( $product_id, $args );
		$output = ob_get_contents();
		ob_end_clean();

		wp_send_json( array( 'value' => $output ) );
	}

	public function bt_reviews_template( $template ) {

		if ( get_post_type() === 'product' ) {
			return wc_locate_template( 'bt-product-reviews.php', '', TMCORE_WOO_PATH . 'lib/reviews/' );
		}

		return $template;
	}
	/**
	 * Default Query Args
	 */
	public function bt_review_query_args( $product_id ) {
		global $bt_woo_extras;
		if ( isset( $bt_woo_extras['bt_reviews_order'] ) && 'desc' == $bt_woo_extras['bt_reviews_order'] ) {
			$orderby = 'post_date';
			$order   = 'DESC';
		} else if ( isset( $bt_woo_extras['bt_reviews_order'] ) && 'asc' == $bt_woo_extras['bt_reviews_order'] ) {
			$orderby = 'post_date';
			$order   = 'ASC';
		} else {
			$orderby = 'meta_value_num post_date';
			$order   = 'DESC';
		}
		$args = array(
			'numberposts' => -1,
			'offset'      => 0,
			'lang'        => '',
			'orderby'     => $orderby,
			'meta_key'    => '_bt_review_votes',
			'order'       => $order,
			'post_type'   => 'bt_reviews',
			'post_parent' => '0',
			'post_status' => 'publish',
			'meta_query'  => array(
				'relation' => 'AND',
				array(
					'key'     => $this->review_meta_product_id,
					'value'   => $product_id,
					'compare' => '=',
					'type'    => 'numeric',
				),
				array(
					'key'     => $this->review_meta_approved,
					'value'   => 1,
					'compare' => '=',
					'type'    => 'numeric',
				),
			),
		);
		return $args;
	}
	public function bt_get_product_reviews( $product_id = null, $args = null ) {
		if ( is_null( $args ) && ! is_null( $product_id ) ) {
			if ( ! is_null( self::$review_query ) && isset( self::$review_query[ $product_id ] ) && ! empty( self::$review_query[ $product_id ] ) ) {
				return self::$review_query[ $product_id ];
			}
			$defaults = apply_filters( 'base_woo_advanced_review_arg_default', $this->bt_review_query_args( $product_id ), $product_id );
			$args = wp_parse_args( $args, $defaults );
			if ( is_null( self::$review_query ) ) {
				self::$review_query = array();
			}
			self::$review_query[ $product_id ] = get_posts( $args );

			return self::$review_query[ $product_id ];
		}
		$defaults = apply_filters( 'base_woo_advanced_review_arg_default', $this->bt_review_query_args( $product_id ), $product_id );
		$args = wp_parse_args( $args, $defaults );

		if ( is_null( $product_id ) ) {
			unset( $args['meta_query'] );
		}

		return get_posts( $args );
	}
	public function bt_check_unapproved( $product_id = null, $args = null ) {
		$defaults = apply_filters( 'base_woo_advanced_review_arg_unapproved', $this->bt_review_query_args( $product_id ), $product_id );
		$args = wp_parse_args( $args, $defaults );

		if ( is_null( $product_id ) ) {
			unset( $args['meta_query'] );
		}

		return get_posts( $args );
	}
	public function bt_add_polylang_support( $args, $product_id ) {
		if ( function_exists( 'pll_get_post_translations' ) && ! empty( $product_id ) ) {
			$get_all_ids = pll_get_post_translations( $product_id );
			$ids = array();
			foreach ( $get_all_ids as $key => $each_id ) {
				$ids[] = $each_id;
			}
			$args['meta_query'] = array(
				'relation' => 'AND',
				array(
					'key'     => $this->review_meta_approved,
					'value'   => 1,
					'compare' => '=',
					'type'    => 'numeric',
				),
				array(
					'key'     => $this->review_meta_product_id,
					'value'   => $ids,
					'compare' => 'IN',
					'type'    => 'numeric',
				),
			);
		} else if ( class_exists( 'SitePress' ) && ! empty( $product_id ) ) {
			$trid = apply_filters( 'wpml_element_trid', null, $product_id, 'post_product' );
			$get_all_ids = apply_filters( 'wpml_get_element_translations', null, $trid, 'post_product' );
			$ids = array();
			foreach ( $get_all_ids as $key => $each_id ) {
				$ids[] = $each_id->element_id;
			}
			$args['meta_query'] = array(
				'relation' => 'AND',
				array(
					'key'     => $this->review_meta_approved,
					'value'   => 1,
					'compare' => '=',
					'type'    => 'numeric',
				),
				array(
					'key'     => $this->review_meta_product_id,
					'value'   => $ids,
					'compare' => 'IN',
					'type'    => 'numeric',
				),
			);
		}
		return $args;
	}
	public function bt_add_polylang_average_support( $query, $product_id ) {
		if ( function_exists( 'pll_get_post_translations' ) && ! empty( $product_id ) ) {

			$get_all_ids = pll_get_post_translations( $product_id );
			$ids = array();
			foreach ( $get_all_ids as $key => $each_id ) {
				$ids[] = $each_id;
			}
			$ids_format_string = rtrim( str_repeat( '%d,', count( $ids ) ), ',' );
			global $wpdb;
			$query = $wpdb->prepare(
				"
			select avg(meta_value)
			from {$wpdb->prefix}postmeta pm
			where meta_key = '{$this->review_meta_rating}' and post_id in
				(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_product_id}' and meta_value IN ({$ids_format_string}) and post_id IN
					(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_approved}' and meta_value = 1 and post_id IN (select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_rating}' and meta_value > 0)))",
				$ids
			);
		} else if ( class_exists( 'SitePress' ) && ! empty( $product_id ) ) {
			$trid = apply_filters( 'wpml_element_trid', null, $product_id, 'post_product' );
			$get_all_ids = apply_filters( 'wpml_get_element_translations', null, $trid, 'post_product' );
			$ids = array();
			foreach ( $get_all_ids as $key => $each_id ) {
				$ids[] = $each_id->element_id;
			}
			$ids_format_string = rtrim( str_repeat( '%d,', count( $ids ) ), ',' );
			global $wpdb;
			$query = $wpdb->prepare(
				"
			select avg(meta_value)
			from {$wpdb->prefix}postmeta pm
			where meta_key = '{$this->review_meta_rating}' and post_id in
				(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_product_id}' and meta_value IN ({$ids_format_string}) and post_id IN
					(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_approved}' and meta_value = 1 and post_id IN (select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_rating}' and meta_value > 0)))",
				$ids
			);
		}

		return $query;
	}

	public function bt_get_product_reviews_by_rating( $product_id, $rating = 0 ) {
		$args = $this->bt_review_query_args( $product_id );
		if ( $rating > 0 ) {
			$args['meta_query'][] = array(
				'key'     => $this->review_meta_rating,
				'value'   => $rating,
				'compare' => '=',
				'type'    => 'numeric',
			);
		}

		return $this->bt_get_product_reviews( $product_id, $args );
	}
	public function bt_reviews_list( $product_id, $args = null ) {
		$reviews = $this->bt_get_product_reviews( $product_id, $args );

		foreach ( $reviews as $review ) {
			wc_get_template( 'bt-single-review.php', array( 'review' => $review ), '', TMCORE_WOO_PATH . 'lib/reviews/' );
		}
	}
	public function bt_get_meta_rating( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_rating, true );
	}
	public function bt_get_meta_approved( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_approved, true );
	}
	public function bt_get_meta_product_id( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_product_id, true );
	}
	public function bt_get_meta_featured( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_featured, true );
	}
	public function bt_get_meta_votes( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_votes, true );
	}
	public function bt_get_meta_upvotes_count( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_upvotes_count, true );
	}
	public function bt_get_meta_downvotes_count( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_downvotes_count, true );
	}
	public function bt_get_meta_comment_id( $review_id ) {
		return get_post_meta( $review_id, $this->review_meta_comment_id, true );
	}
	function bt_get_meta_author( $review_id ) {
		return array(
			'review_user_id'      => get_post_meta( $review_id, $this->review_meta_review_user_id, true ),
			'review_author'       => get_post_meta( $review_id, $this->review_meta_review_author, true ),
			'review_author_email' => get_post_meta( $review_id, $this->review_meta_review_author_email, true ),
			'review_author_url'   => get_post_meta( $review_id, $this->review_meta_review_author_url, true ),
			'review_author_IP'    => get_post_meta( $review_id, $this->review_meta_review_author_ip, true ),
		);
	}
	public function bt_wc_get_template( $located, $template_name, $args, $template_path, $default_path ) {
		if ( 'single-product/rating.php' != $template_name ) {
			return $located;
		}

		$located = wc_locate_template( 'bt-rating.php', $template_path, $default_path );

		if ( file_exists( $located ) ) {
			return $located;
		}

		return TMCORE_WOO_PATH . 'lib/reviews/bt-rating.php';
	}
	public function bt_get_average_rating( $product_id, $num = 2 ) {
		if ( ! is_null( self::$review_avg_query ) && isset( self::$review_avg_query[ $product_id ] ) && ! empty( self::$review_avg_query[ $product_id ] ) ) {
			return self::$review_avg_query[ $product_id ];
		}
		global $wpdb;
		$query = $wpdb->prepare(
			"
			select avg(meta_value)
			from {$wpdb->prefix}postmeta pm
			where meta_key = '{$this->review_meta_rating}' and post_id in
				(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_product_id}' and meta_value = %d and post_id IN
					(select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_approved}' and meta_value = 1 and post_id IN (select post_id from {$wpdb->prefix}postmeta where meta_key = '{$this->review_meta_rating}' and meta_value > 0)))",
			$product_id
		);

		$query = apply_filters( 'base_woo_advanced_review_arg_average_query', $query, $product_id );

		$count = $wpdb->get_var( $query );

		if ( is_null( self::$review_avg_query ) ) {
			self::$review_avg_query = array();
		}
		self::$review_avg_query[ $product_id ] = ! empty( $count ) ? number_format( $count, $num ) : 0;

		return self::$review_avg_query[ $product_id ];

	}

	public function bt_update_tab_reviews_count( $tabs ) {
		global $product;

		if ( isset( $tabs['reviews'] ) ) {
			$tabs['reviews']['title'] = sprintf( __( 'Reviews(%d)', 'templatemela-core' ), count( $this->bt_get_product_reviews( $product->get_id() ) ) );
		}

		return $tabs;
	}
	public function bt_get_product_rating_html( $rating_html, $rating ) {
		if ( is_product() ) {
			global $product;
			$rating_html = '';
			$rating = $this->bt_get_average_rating( $product->get_id() );

			if ( $rating > 0 ) {

				$rating_html = '<div class="star-rating" title="' . sprintf( __( 'Rated %s out test of 5', 'templatemela-core' ), $rating ) . '">';

				$rating_html .= '<span style="width:' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . __( 'out of 5', 'templatemela-core' ) . '</span>';

				$rating_html .= '</div>';
			}
		}

		return $rating_html;
	}
	public function bt_add_reviews_average_info( $product ) {

		if ( get_option( 'woocommerce_enable_review_rating' ) === 'no' ) {
			return;
		}

		global $product;

		$average = $this->bt_get_average_rating( $product->get_id() );

		$count = count( $this->bt_get_product_reviews( $product->get_id() ) );

		if ( $count > 0 ) {
			echo '<div class="woocommerce-product-rating">
				<div class="star-rating" title="' . sprintf( __( 'Rated %s out of 5', 'templatemela-core' ), $average ) . '">
					<span  style="width:' . ( ( $average / 5 ) * 100 ) . '%"></span>
				</div>
				<span class="bt_review_count">' . sprintf( '%d %s', $count, _n( ' review', ' reviews', $count, 'templatemela-core' ) ) . '</span><span class="review-rating-value"> ' . esc_html( $average ) . ' ' . __( 'out of 5 stars', 'templatemela-core' ) . '</span>
			</div>';
		}
	}

	public function bt_review_stats( $product ) {
		$args = $this->bt_review_query_args( $product->get_id() );
		$args['meta_query'][] = array(
			'key'     => $this->review_meta_rating,
			'value'   => 0,
			'compare' => '!=',
			'type'    => 'numeric',
		);
		$review_stats = array(
			'1'     => count( $this->bt_get_product_reviews_by_rating( $product->get_id(), 1 ) ),
			'2'     => count( $this->bt_get_product_reviews_by_rating( $product->get_id(), 2 ) ),
			'3'     => count( $this->bt_get_product_reviews_by_rating( $product->get_id(), 3 ) ),
			'4'     => count( $this->bt_get_product_reviews_by_rating( $product->get_id(), 4 ) ),
			'5'     => count( $this->bt_get_product_reviews_by_rating( $product->get_id(), 5 ) ),
			'total' => count( $this->bt_get_product_reviews( $product->get_id(), $args ) ),
		);
		return $review_stats;
	}

	public function bt_reviews_summary( $product ) {
		global $bt_woo_extras;
		if ( isset( $bt_woo_extras['bt_review_overview'] ) && 1 == $bt_woo_extras['bt_review_overview'] ) {
			wc_get_template( 'bt-product-reviews-overview.php', array( 'product'   => $product ), '', TMCORE_WOO_PATH . 'lib/reviews/' );
		}
	}

	public function bt_update_review_attributes() {
		if ( ! isset( $_GET['review_id'] ) ) {
			return;
		}

		$review_id = $_GET['review_id'];

		$current_filter = current_filter();

		switch ( $current_filter ) {
			case 'admin_action_approve-review':
				$comment_id = get_post_meta( $review_id, $this->review_meta_comment_id, true );
				update_post_meta( $review_id, $this->review_meta_approved, 1 );
				$comment = get_comment( $comment_id );
				if ( $comment != null ) {
					$status = 'approve';
					wp_set_comment_status( $comment_id, $status );
				}

				break;

			case 'admin_action_unapprove-review':
				update_post_meta( $review_id, $this->review_meta_approved, 0 );
				$comment_id = get_post_meta( $review_id, $this->review_meta_comment_id, true );
				$comment = get_comment( $comment_id );
				if ( $comment != null ) {
					$status = 'hold';
					wp_set_comment_status( $comment_id, $status );
				}

				break;

			case 'admin_action_untrash-review':
				$my_post = array(
					'ID'          => $review_id,
					'post_status' => 'publish',
				);

				wp_update_post( $my_post );

				$approve = get_post_meta( $review_id, $this->bt_reviews->review_meta_approved, true );
				$comment_id = get_post_meta( $review_id, $this->bt_reviews->review_meta_comment_id, true );
				$comment = get_comment( $comment_id );
				if ( $comment != null ) {
					if ( $approve == 1 ) {
						$status = 'approve';
					} else {
						$status = 'hold';
					}
					wp_set_comment_status( $comment_id, $status );
				}

				break;
			case 'admin_action_trash-review':
				$my_post = array(
					'ID'          => $review_id,
					'post_status' => 'trash',
				);

				wp_update_post( $my_post );

				$comment_id = get_post_meta( $review_id, $this->review_meta_comment_id, true );
				$comment = get_comment( $comment_id );
				if ( $comment != null ) {
					$status = 'trash';
					wp_set_comment_status( $comment_id, $status );
				}

				break;
			case 'admin_action_delete-review':
				$comment_id = get_post_meta( $review_id, $this->review_meta_comment_id, true );
				$comment = get_comment( $comment_id );
				if ( $comment != null ) {
					wp_delete_comment( $comment_id, true );
				}
				wp_delete_post( $review_id );

				break;
		}

		wp_redirect( esc_url_raw( remove_query_arg( array( 'action', 'action2' ), $_SERVER['HTTP_REFERER'] ) ) );
	}
	public function bt_add_review_table_class( $classes, $class, $post_id ) {

		if ( 'bt_reviews' != get_post_type( $post_id ) ) {
			return $classes;
		}

		unset( $classes['review-unapproved'] );
		unset( $classes['review-approved'] );

		$approve = get_post_meta( $post_id, $this->review_meta_approved, true );

		if ( 1 == $approve ) {
			$classes[] = 'review-approved';
		} elseif ( 0 == $approve ) {
			$classes[] = 'review-unapproved';
		}

		return apply_filters( 'bt_reviews_table_class', $classes, $post_id );
	}
	/**
	 * Add admin styling.
	 */
	public function enqueue_admin_styles_scripts( $hook ) {
		if ( isset( $hook ) && ! empty( $hook ) && 'toplevel_page_bt_reviews' === $hook ) {
			wp_enqueue_style( 'base_admin_reviews_css', TMCORE_WOO_URL . 'lib/reviews/css/bt_woo_admin_reviews.css', false, TMCORE_VERSION );
		}
	}
	/**
	 * Set a maximum execution time
	 *
	 * @param $seconds time in seconds
	 */
	private function set_time_limit( $seconds ) {
		$check_safe_mode = ini_get( 'safe_mode' );
		if ( ( ! $check_safe_mode ) || ( 'OFF' == strtoupper( $check_safe_mode ) ) ) {
			@set_time_limit( $seconds );
		}
	}

	public function review_action_url( $action, $post_id ) {
		return admin_url( "admin.php?action=$action&post_type=bt_reviews&review_id=$post_id" );
	}

	public function untrash_review_url( $review ) {
		return $this->review_action_url( 'untrash-review', $review->ID );
	}
	public function trash_review_url( $review ) {
		return $this->review_action_url( 'trash-review', $review->ID );
	}
	public function delete_review_url( $review ) {
		return $this->review_action_url( 'delete-review', $review->ID );
	}

	public function approve_review_url( $review ) {
		return $this->review_action_url( 'approve-review', $review->ID );
	}

	public function unapprove_review_url( $review ) {
		return $this->review_action_url( 'unapprove-review', $review->ID );
	}

	public function bt_add_review_actions( $actions, $post ) {

		if ( $post->post_type != 'bt_reviews' ) {
			return $actions;
		}
		$approved = $this->bt_get_meta_approved( $post->ID );

		unset( $actions['view'] );
		unset( $actions['inline hide-if-no-js'] );

		if ( ! $approved ) {
			$actions['approve-review'] = '<a href="' . $this->approve_review_url( $post ) . '" title="' . esc_attr( __( 'Approve review', 'templatemela-core' ) ) . '" rel="permalink">' . __( 'Approve', 'templatemela-core' ) . '</a>';
		} elseif ( $approved ) {
			$actions['unapprove-review'] = '<a href="' . $this->unapprove_review_url( $post ) . '" title="' . esc_attr( __( 'Unapprove review', 'templatemela-core' ) ) . '" rel="permalink">' . __( 'Unapprove', 'templatemela-core' ) . '</a>';
		}

		return apply_filters( 'bt_reviews_review_actions', $actions, $post );
	}
	/**
	 * Read and convert previous reviews into new advanced reviews using custom post type
	 */
	public function bt_import_previous_reviews() {
		global $wpdb;

		$review_converted = 0;
		// Set my lookup args.
		$setup_args = array(
			'post_type' => 'product',
		);
		// Now fetch my reviews.
		$results = get_comments( $setup_args );
		// Bail with a 'no-reviews' string to look for later.
		if ( empty( $results ) ) {
			return $review_converted;
		}
		// Manage parent relationship and update all reviews when import ends
		$review_ids    = array();
		$parent_review = array();

		foreach ( $results as $comment ) {

			// Check if comment_meta exists for previous reviews and is not still imported.
			if ( '1' === get_comment_meta( $comment->comment_ID, $this->review_meta_imported, true ) ) {
				// comment still imported, update only author data.

				// Retrieve review(post) id linked to current comment.
				$args    = array(
					'post_type'  => 'bt_reviews',
					'meta_query' => array(
						array(
							'key'     => $this->review_meta_comment_id,
							'value'   => $comment->comment_ID,
							'compare' => '=',
							'type'    => 'numeric',
						),
					),
				);
				$reviews = get_posts( $args );

				if ( ! empty( $reviews ) ) {
					$review = $reviews[0];

					// Update review meta.
					update_post_meta( $review->ID, $this->review_meta_review_user_id, $comment->user_id );
					update_post_meta( $review->ID, $this->review_meta_review_author, $comment->comment_author );
					update_post_meta( $review->ID, $this->review_meta_review_author_email, $comment->comment_author_email );
					update_post_meta( $review->ID, $this->review_meta_review_author_url, $comment->comment_author_url );
					update_post_meta( $review->ID, $this->review_meta_review_author_ip, $comment->comment_author_IP );
				}
				continue;
			}

			// Set execution time.
			$this->set_time_limit( 30 );

			$val    = get_comment_meta( $comment->comment_ID, 'rating', true );
			$rating = $val ? $val : 0;

			// Create post object.
			$args = array(
				'post_author'             => $comment->user_id,
				'post_date'               => $comment->comment_date,
				'post_date_gmt'           => $comment->comment_date_gmt,
				'post_content'            => $comment->comment_content,
				'post_title'              => '',
				'review_user_id'          => $comment->user_id,
				'review_approved'         => $comment->comment_approved,
				'review_product_id'       => $comment->comment_post_ID,
				'review_comment_id'       => $comment->comment_ID,
				'review_rating'           => $rating,
				'review_is_reply_blocked' => 1,
				'review_voters'           => array(),
				'review_voter_guests'     => array(),
				'review_votes'            => 0,
				'review_upvotes'          => 0,
				'review_downvotes'        => 0,
				'review_author'           => $comment->comment_author,
				'review_author_email'     => $comment->comment_author_email,
				'review_author_url'       => $comment->comment_author_url,
				'review_author_IP'        => $comment->comment_author_IP,
			);

			// Insert the post into the database.
			$review_id = $this->bt_add_review( $args );

			$review_ids[ $comment->comment_ID ] = $review_id;

			// If current comment have parent, store it and update all relationship when the import ends.
			if ( $comment->comment_parent > 0 ) {
				$parent_review[ $review_id ] = $comment->comment_parent;
			}

			// set current comment as imported.
			update_comment_meta( $comment->comment_ID, $this->review_meta_imported, 1 );
			$review_converted ++;
		}

		return $review_converted;
	}
	/**
	 * Build Reviews Metaboxes.
	 */
	public function add_metaboxes() {

		$prefix = '_bt_review_';
		$bt_woo_reviews = new_cmb2_box(
			array(
				'id'            => $prefix . 'reviews',
				'title'         => __( 'Review Settings', 'templatemela-core' ),
				'object_types'  => array( 'bt_reviews' ), // Post type
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Author Name (if not a site user, else shows site user display name)', 'templatemela-core' ),
				'id'            => $prefix . 'author',
				'type'          => 'Text',
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Rating', 'templatemela-core' ),
				'id'            => $prefix . 'rating',
				'type'          => 'select',
				'options'          => array(
					'1'     => __( '1 Star', 'templatemela-core' ),
					'2'     => __( '2 Stars', 'templatemela-core' ),
					'3'     => __( '3 Stars', 'templatemela-core' ),
					'4'     => __( '4 Stars', 'templatemela-core' ),
					'5'     => __( '5 Stars', 'templatemela-core' ),
				),
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Review Approved', 'templatemela-core' ),
				'id'            => $prefix . 'approved',
				'type'          => 'select',
				'options'          => array(
					'0'     => __( 'Not Approved', 'templatemela-core' ),
					'1'     => __( 'Approved', 'templatemela-core' ),
				),
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Up Votes', 'templatemela-core' ),
				'id'            => $prefix . 'upvotes',
				'default'       => '0',
				'type'          => 'text_vote_up',
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Down Votes', 'templatemela-core' ),
				'id'            => $prefix . 'downvotes',
				'default'       => '0',
				'type'          => 'text_vote_down',
			)
		);
		$bt_woo_reviews->add_field(
			array(
				'name'          => __( 'Review is Featured', 'templatemela-core' ),
				'id'            => $prefix . 'is_featured',
				'type'          => 'select',
				'options'          => array(
					'0'     => __( 'False', 'templatemela-core' ),
					'1'     => __( 'True', 'templatemela-core' ),
				),
			)
		);
	}
	/**
	 * Load script for importing.
	 *
	 * @param string $hook the page hook.
	 */
	public function enqueue_admin_import_scripts( $hook ) {
		//'toplevel_page_bt_reviews' === $hook
		if ( isset( $hook ) && ! empty( $hook ) && 'templatemela_page_base-shop-kit-settings' === $hook ) {
			wp_enqueue_script( 'base-admin-reviews-import-js', TMCORE_WOO_URL . 'lib/reviews/js/bt_admin_woo_reviews.js', array( 'jquery' ), TMCORE_VERSION, true );
			wp_localize_script(
				'base-admin-reviews-import-js',
				'baseAdminReviews',
				array(
					'ajax_url'       => admin_url( 'admin-ajax.php' ),
					'ajax_nonce'     => wp_create_nonce( 'base-admin-reviews-ajax-verification' ),
					'reviewButton' => '<div class="convert-info"><a class="button-primary bt-review-convert" style="margin:10px 0;" href="#">' .  __( 'Convert Reviews', 'templatemela-core' ) . '</a><p></p></div>',
				)
			);
		}

	}
	/**
	 * Convert comments to reviews.
	 */
	public function bt_check_import_actions() {
		if ( isset( $_GET['bt-convert-reviews'] ) ) {

			$response = $this->bt_import_previous_reviews();
			add_settings_error( 'update_converts', 'update_converts', sprintf( __( 'Converted %d Reviews', 'templatemela-core' ), $response ), 'updated' );

			wp_redirect( esc_url( remove_query_arg( 'bt-convert-reviews' ) ) );
		}
	}
	/**
	 * Convert comments to reviews.
	 */
	public function convert_reviews_callback() {
		check_ajax_referer( 'base-admin-reviews-ajax-verification', 'security' );
		$review_converted = $this->bt_import_previous_reviews();
		$response         = '';

		if ( $review_converted ) {
			$response = sprintf( __( 'Completed. %d reviews have been processed and converted.', 'templatemela-core' ), $review_converted );
		} else {
			$response = __( 'Completed. No reviews needing to be converted have been found.', 'templatemela-core' );
		}

		wp_send_json( array( 'value' => $response ) );
	}
	/**
	 * Convert comments to reviews.
	 */
	public function bt_vote_callback() {
		if ( ! isset( $_POST['wpnonce'] ) || ! wp_verify_nonce( $_POST['wpnonce'], 'bt_reviews' ) ) {
			return false;
		}
		if ( ! isset( $_POST['comment_id'] ) ) {
			return false;
		} else {
			$review_id = $_POST['comment_id'];
		}
		if ( ! isset( $_POST['user_id'] ) || empty( $_POST['user_id'] ) ) {
			return false;
		} else {
			$user_id = $_POST['user_id'];
		}
		if ( ! isset( $_POST['vote'] ) ) {
			$vote = 'positive';
		} else {
			$vote = $_POST['vote'];
		}
		$vote_users = get_post_meta( $review_id, $this->review_meta_voters, true );
		if ( in_array( $user_id, $vote_users ) ) {
			$same_user = true;
		} else {
			$same_user = false;
		}
		if ( $same_user == false ) {
			if ( $vote == 'positive' ) {
				$upvotes = get_post_meta( $review_id, $this->review_meta_upvotes_count, true );
				$votes = get_post_meta( $review_id, $this->review_meta_votes, true );
				$upvotes++;
				$votes++;
				update_post_meta( $review_id, $this->review_meta_upvotes_count, $upvotes );
				update_post_meta( $review_id, $this->review_meta_votes, $votes );
			} else {
				$downvotes = get_post_meta( $review_id, $this->review_meta_downvotes_count, true );
				$votes = get_post_meta( $review_id, $this->review_meta_votes, true );
				$votes--;
				$downvotes++;
				update_post_meta( $review_id, $this->review_meta_downvotes_count, $downvotes );
				update_post_meta( $review_id, $this->review_meta_votes, $votes );
			}
			$vote_users[] = $user_id;
			update_post_meta( $review_id, $this->review_meta_voters, $vote_users );
			$helpful = get_post_meta( $review_id, $this->review_meta_upvotes_count, true );
			$total = $helpful + get_post_meta( $review_id, $this->review_meta_downvotes_count, true );

			$response = sprintf( __( '%1$d of %2$s found this helpful', 'templatemela-core' ), $helpful, $total );
		} else {
			$response = __( 'You have already voted', 'templatemela-core' );
		}

		wp_send_json( array( 'value' => $response ) );
	}
	public function bt_vote_callback_guest() {
		if ( ! isset( $_POST['wpnonce'] ) || ! wp_verify_nonce( $_POST['wpnonce'], 'bt_reviews' ) ) {
			return false;
		}
		if ( ! isset( $_POST['comment_id'] ) ) {
			return false;
		} else {
			$review_id = $_POST['comment_id'];
		}
		if ( ! isset( $_POST['vote'] ) ) {
			$vote = 'positive';
		} else {
			$vote = $_POST['vote'];
		}
		$vote_ips = get_post_meta( $review_id, $this->review_meta_voter_guests, true );
		if ( empty( $vote_ips ) ) {
			$vote_ips = array();
		}
		$user_ip = $_SERVER['REMOTE_ADDR'];
		if ( in_array( $user_ip, $vote_ips ) ) {
			$same_user = true;
		} else {
			$same_user = false;
		}
		if ( $same_user == false ) {
			if ( $vote == 'positive' ) {
				$upvotes = get_post_meta( $review_id, $this->review_meta_upvotes_count, true );
				$votes = get_post_meta( $review_id, $this->review_meta_votes, true );
				$upvotes++;
				$votes++;
				update_post_meta( $review_id, $this->review_meta_upvotes_count, $upvotes );
				update_post_meta( $review_id, $this->review_meta_votes, $votes );
			} else {
				$downvotes = get_post_meta( $review_id, $this->review_meta_downvotes_count, true );
				$votes = get_post_meta( $review_id, $this->review_meta_votes, true );
				$votes--;
				$downvotes++;
				update_post_meta( $review_id, $this->review_meta_downvotes_count, $downvotes );
				update_post_meta( $review_id, $this->review_meta_votes, $votes );
			}
			$vote_ips[] = $user_ip;
			update_post_meta( $review_id, $this->review_meta_voter_guests, $vote_ips );
			$helpful = get_post_meta( $review_id, $this->review_meta_upvotes_count, true );
			$total = $helpful + get_post_meta( $review_id, $this->review_meta_downvotes_count, true );
			$response = sprintf( __( '%1$d of %2$s found this helpful', 'templatemela-core' ), $helpful, $total );
		} else {
			$response = __( 'You have already voted', 'templatemela-core' );
		}

		wp_send_json( array( 'value' => $response ) );
	}
	public function bt_review_dash() {
		if ( current_user_can( 'publish_shop_orders' ) ) {
			remove_meta_box( 'woocommerce_dashboard_recent_reviews', 'dashboard', 'normal' );
			wp_add_dashboard_widget( 'bt_woocommerce_dashboard_recent_reviews', __( 'WooCommerce Recent Reviews', 'woocommerce' ), array( $this, 'bt_recent_reviews_widget' ) );
		}

	}
	public function bt_recent_reviews_widget() {
		$args = array(
			'numberposts' => 5,
			'offset'      => 0,
			'orderby'     => 'post_date',
			'meta_key'    => '_bt_review_votes',
			'order'       => 'DESC',
			'post_type'   => 'bt_reviews',
			'post_parent' => '0',
			'post_status' => 'publish',
		);
		$reviews = get_posts( $args );

		if ( $reviews ) {
			echo '<ul>';
			foreach ( $reviews as $review ) {

				echo '<li>';
				$author = $this->bt_get_meta_author( $review->ID );
				$user = isset( $author['review_user_id'] ) ? get_userdata( $author['review_user_id'] ) : null;
				echo get_avatar( $user->ID, '32' );

				$rating = $this->bt_get_meta_rating( $review->ID );

				echo '<div class="star-rating" title="' . esc_attr( $rating ) . '">
					<span style="width:' . ( $rating * 20 ) . '%">' . $rating . ' ' . __( 'out of 5', 'templatemela-core' ) . '</span></div>';

				echo '<h4 class="meta">' . esc_html( apply_filters( 'bt_woocommerce_admin_dashboard_recent_reviews', $review->post_title, $review ) ) . ' ' . __( 'reviewed by', 'woocommerce' ) . ' ' . esc_html( $user->display_name ) . '</h4>';
				echo '<blockquote>' . wp_kses_data( $review->post_content ) . ' [...]</blockquote></li>';

			}
			echo '</ul>';
		} else {
			echo '<p>' . __( 'There are no product reviews yet.', 'woocommerce' ) . '</p>';
		}
	}
}
/**
 * Get the reviews class loaded.
 */
function base_reviews_plugin_loaded() {
	$GLOBALS['bt_reviews'] = Base_Advanced_Reviews::get_instance();
}
add_action( 'after_setup_theme', 'base_reviews_plugin_loaded' );