<?php
/**
 * Review Comments Template
 *
 * @package Base Woo Extras
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

global $bt_woo_extras;

$base_reviews = Base_Advanced_Reviews::get_instance();
$rating          = $base_reviews->bt_get_meta_rating( $review->ID );
$approved        = $base_reviews->bt_get_meta_approved( $review->ID );
$product_id      = $base_reviews->bt_get_meta_product_id( $review->ID );
$upvotes         = $base_reviews->bt_get_meta_upvotes_count( $review->ID );
$downvotes       = $base_reviews->bt_get_meta_downvotes_count( $review->ID );
$comment_id      = $base_reviews->bt_get_meta_comment_id( $review->ID );
$totalvotes      = floor( $upvotes + $downvotes );
$review_date     = mysql2date( get_option( 'date_format' ), $review->post_date );
$author          = $base_reviews->bt_get_meta_author( $review->ID );
$user            = isset( $author['review_user_id'] ) ? get_userdata( $author['review_user_id'] ) : null;
if ( isset( $bt_woo_extras['bt_reviews_featured'] ) && 1 == $bt_woo_extras['bt_reviews_featured'] ) {
	$featured = $base_reviews->bt_get_meta_featured( $review->ID );
} else {
	$featured = 0;
}
$reviewclasses = array();
if ( 1 == $featured ) {
	$reviewclasses[] = 'bt-featured-comment';
}
if ( $user ) {
	$author_name = $user->display_name;
} else if ( isset( $author['review_user_id'] ) ) {
	$author_name = $author['review_author'];
} else {
	$author_name = __( 'Anonymous', 'templatemela-core' );
}


?>
<li <?php post_class( $reviewclasses, $review->ID ); ?> id="li-comment-<?php echo esc_attr( $review->ID ); ?>">

	<div id="comment-<?php echo esc_attr( $comment_id ); ?>" class="comment_container">

	<?php
		do_action( 'bt_review_before', $review );
		if ( $user ) {
			echo get_avatar( $user->ID, apply_filters( 'woocommerce_review_gravatar_size', '60' ), '', __( 'Reviewer profile image', 'templatemela-core' ) );
		} else {
			echo get_avatar( $author['review_author_email'], apply_filters( 'woocommerce_review_gravatar_size', '60' ), '', __( 'Reviewer profile image', 'templatemela-core' ) );
		}
		if ( 1 == $featured ) {
			echo '<div class="bt-featured-review" data-toggle="tooltip" data-placement="top" data-original-title="' . __( 'Featured Review', 'templatemela-core' ) . '"><i class="bt-reviews-icon-star-full"></i></div>';
		}
		?>

		<div class="comment-text">

			<?php
			do_action( 'bt_review_before_comment_meta', $review );
			if ( $rating && get_option( 'woocommerce_enable_review_rating' ) === 'yes' ) { ?>

				<div class="star-rating" title="<?php echo sprintf( esc_attr__( 'Rated %d out of 5', 'templatemela-core' ), esc_attr( $rating ) ) ?>">
					<span style="width:<?php echo ( esc_attr( $rating ) / 5 ) * 100; ?>%"><strong><?php echo esc_attr( $rating ); ?></strong> <?php esc_attr_e( 'out of 5', 'templatemela-core' ); ?></span>
				</div>

			<?php }

			do_action( 'bt_review_meta', $review );
			if ( $approved == '0' ) : ?>

				<p class="meta"><em><?php _e( 'Your comment is waiting for approval', 'templatemela-core' ); ?></em></p>

			<?php else : ?>

				<p class="meta">
					<strong><?php echo esc_html($author_name); ?></strong> <?php

					if ( $user && get_option( 'woocommerce_review_rating_verification_label' ) === 'yes' ) {
						if ( wc_customer_bought_product( $user->user_email, $user->ID, $product_id ) ) {
							echo '<em class="verified">(' . __( 'verified owner', 'templatemela-core' ) . ')</em> ';
						}
					}
					?>
					&ndash; <time datetime="<?php echo esc_attr( mysql2date( 'c', $review_date ) ); ?>"><?php echo esc_html( $review_date ); ?></time>
				</p>

			<?php endif; 

			do_action( 'bt_review_before_comment_text', $review );
			do_action( 'bt_review_comment_text', $review );
			echo '<div itemprop="description" class="description">';
				if ( isset( $bt_woo_extras['bt_review_title'] ) && $bt_woo_extras['bt_review_title'] == 1 ) {
					echo '<h5 class="bt_review_title"><b>'.apply_filters( 'bt_reviews_review_title', $review->post_title ).'</b></h5>';
				}
				echo apply_filters( 'bt_reviews_review_content', $review->post_content );
			echo '</div>';
			if ( ! isset( $bt_woo_extras['bt_review_voting'] ) || ( isset( $bt_woo_extras['bt_review_voting'] ) && $bt_woo_extras['bt_review_voting'] != 0 ) ) {
				echo '<div class="bt-review-vote-area">';
					if($totalvotes != 0) {
						echo  '<div class="bt-review-helpful">'.sprintf(__('%d of %s found this helpful', 'templatemela-core'), $upvotes, $totalvotes).'</div>';
					} else {
						echo '<div class="bt-review-helpful"></div>';
					}
					if(!is_user_logged_in() && $bt_woo_extras['vote_loggedin_only'] == 1) {
						$data = 'data-toggle="modal" data-target="#bt-modal-review-login"';
					} else {
						$data = 'data-vote="review"';
					}
					echo  '<div class="bt-review-vote-container">';
						echo '<a href="#" data-comment-id="'.esc_attr($review->ID).'" '.$data.' class="bt-review-vote bt-vote-up" data-toggle="tooltip" data-placement="top" data-original-title="'.__('Upvote if this was helpful.', 'templatemela-core').'"><i class="bt-reviews-icon-thumbs-up"></i></a><a href="#" data-comment-id="'.esc_attr($review->ID).'" '.$data.' class="bt-review-vote bt-vote-down" data-toggle="tooltip" data-placement="top" data-original-title="'.__('Downvote if this was not helpful.', 'templatemela-core').'"><i class="bt-reviews-icon-thumbs-down"></i></a>';
						echo '</div>';
				echo '</div>';
			}

			do_action( 'bt_review_after_comment_text', $review ); ?>

		</div>
		<div class="bt-review-overlay"><div class="bt-ajax-bubbling"><span id="bt-ajax-bubbling_1"></span><span id="bt-ajax-bubbling_2"></span><span id="bt-ajax-bubbling_3"></span></div></div>
		</div>
</li>