<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
add_action( 'after_setup_theme', 'bt_checkout_coupone_plugin_loaded' );

function bt_checkout_coupone_plugin_loaded() {

	class Base_Checkout_Coupon_Modal {

		public function __construct() {
				add_action( 'woocommerce_checkout_order_review', array( $this, 'add_before_order_review' ), 5 );
				add_action( 'woocommerce_review_order_before_order_total', array( $this, 'add_review_table_before_total' ), 10 );
				add_action( 'woocommerce_review_order_after_order_total', array( $this, 'add_review_table_after_total' ), 10 );
				add_action( 'woocommerce_checkout_order_review', array( $this, 'add_between_order_review_payment' ), 15 );
				add_action( 'woocommerce_checkout_order_review', array( $this, 'add_after_payment' ), 40 );
				add_action( 'wp_enqueue_scripts', array( $this, 'modal_checkout_scripts' ), 200 );
				add_action( 'woocommerce_before_checkout_form', array( $this, 'custom_checkout_form' ), 20 );
				// Remove the normal checkout form
				remove_action( 'woocommerce_before_checkout_form', 'woocommerce_checkout_coupon_form', 10 );
		}

		public function add_coupon_field() {
			if ( wc_coupons_enabled() ) {
				global $bt_woo_extras;
				$showcoupon_pre = ( ! empty( $bt_woo_extras['checkout_coupon_pre'] ) ? $bt_woo_extras['checkout_coupon_pre'] : __( 'Have a promo code?', 'templatemela-core' ) );
				$showcoupon_link = ( ! empty( $bt_woo_extras['checkout_coupon_link'] ) ? $bt_woo_extras['checkout_coupon_link'] : __( 'Click here to enter your code.', 'templatemela-core' ) );
					?>
					<p class="coupon_inner_checkout"><?php echo esc_html( $showcoupon_pre ); ?> <a class="coupon-modal-link"><?php echo esc_html( $showcoupon_link ); ?></a></p>
		<?php }
		}
		public function add_before_order_review() {
			global $bt_woo_extras;
			if ( isset( $bt_woo_extras['checkout_coupon_link_placement'] ) && 'before_review' === $bt_woo_extras['checkout_coupon_link_placement'] ) {
				$this->add_coupon_field();
			}
		}
		public function add_review_table_before_total() {
			global $bt_woo_extras;
			if ( isset( $bt_woo_extras['checkout_coupon_link_placement'] ) && 'before_table_total' === $bt_woo_extras['checkout_coupon_link_placement'] ) {
				echo '<tr class="bt-coupon-checkout">';
				echo '<td colspan="2">';
					$this->add_coupon_field();
				echo '</td>';
				echo '</tr>';
			}
		}
		public function add_review_table_after_total() {
			global $bt_woo_extras;
			if ( isset( $bt_woo_extras['checkout_coupon_link_placement'] ) && 'after_table_total' === $bt_woo_extras['checkout_coupon_link_placement'] ) {
				echo '<tr class="bt-coupon-checkout">';
				echo '<td colspan="2">';
					$this->add_coupon_field();
				echo '</td>';
				echo '</tr>';
			}
		}
		public function add_between_order_review_payment() {
			global $bt_woo_extras;
			if ( isset( $bt_woo_extras['checkout_coupon_link_placement'] ) && 'between_review_payment' === $bt_woo_extras['checkout_coupon_link_placement'] ) {
				$this->add_coupon_field();
			}
		}
		public function add_after_payment() {
			global $bt_woo_extras;
			if ( isset( $bt_woo_extras['checkout_coupon_link_placement'] ) && 'after_payment' === $bt_woo_extras['checkout_coupon_link_placement'] ) {
				$this->add_coupon_field();
			}
		}
		public function custom_checkout_form() {
			global $bt_woo_extras;
			$modal_body = ( ! empty(  $bt_woo_extras['checkout_coupon_desc'] ) ? $bt_woo_extras['checkout_coupon_desc'] : __( 'If you have a promo code, please apply it below.', 'templatemela-core' ) );
			$placeholder = ( ! empty(  $bt_woo_extras['checkout_coupon_placeholder'] ) ? $bt_woo_extras['checkout_coupon_placeholder'] : __( 'Promo code', 'templatemela-core' ) );
			$apply = ( ! empty(  $bt_woo_extras['checkout_coupon_apply'] ) ? $bt_woo_extras['checkout_coupon_apply'] : __( 'Apply Code', 'templatemela-core' ) );
			?>
			<div id="base-coupon-modal" class="base-coupone-pro-modal bt-m-animate-in-fadeup bt-m-animate-out-fadeout" aria-hidden="true">
					<div id="bt-coupon-modal-overlay" class="bt-coupon-modal-overlay" tabindex="-1">
						<div class="bt-modal-container bt-modal-height-auto bt-close-position-inside" role="dialog" aria-modal="true">
							<button class="bt-coupon-modal-close" aria-label="Close Modal" data-modal-close="true"><svg viewBox="0 0 24 24" fill="none" stroke="currentColor" xmlns="http://www.w3.org/2000/svg" strokewidth="2" strokelinecap="round" strokelinejoin="round"><line x1="18" y1="6" x2="6" y2="18"></line><line x1="6" y1="6" x2="18" y2="18"></line></svg></button>
							<div id="base-coupon-modal-content" class="bt-modal-content">
								<form class="bt_checkout_coupon woocommerce-form-coupon" method="post">
								<p><?php echo esc_html( $modal_body ); ?></p>

								<p class="form-row form-row-first">
									<input type="text" name="coupon_code" class="input-text" placeholder="<?php echo esc_attr( $placeholder ); ?>" id="coupon_code" value="" />
								</p>

								<p class="form-row form-row-last">
									<button type="submit" class="button" name="apply_coupon" value="<?php echo esc_attr( $apply ); ?>"><?php echo esc_html( $apply ); ?></button>
								</p>

								<div class="clear"></div>
							</form>
							</div>
						</div>
					</div>
				</div>
			<?php
		}

		public function modal_checkout_scripts() {
			 if ( is_checkout() ) {
				wp_enqueue_style( 'base-coupon-modal-css', TMCORE_WOO_URL . 'lib/checkout_coupon/css/bt-coupon-modal.css', false, TMCORE_VERSION );
				wp_enqueue_script( 'base-coupon-modal', TMCORE_WOO_URL . 'lib/checkout_coupon/js/bt-coupon-modal.js', array( 'jquery' ), TMCORE_VERSION, true );
			}
		}

	}
	$GLOBALS['Base_Checkout_Coupon_Modal'] = new Base_Checkout_Coupon_Modal();
}

