/**
 * WordPress dependencies
 */
 const { __ } = wp.i18n;
 const { Fragment } = wp.element;
 const { withFilters } = wp.components;
 const { TabPanel, Panel, PanelBody } = wp.components;
 
 import baseTryParseJSON from './components/common/try-parse';
 export const StartedTab = () => {
	const started = ( baseSettingsParams.started ? baseTryParseJSON( baseSettingsParams.started ) : {} );
	 return (
		<Fragment>
			{ started && (
				<div className="base-desk-help-inner">
					{ started.title && (
						<h2>{ started.title }</h2>
					) }
					{ started.description && (
						<p>{ started.description }</p>
					) }
					{ started.video_url && (
						<div className="video-container">
							<iframe width="560" height="315" src={ started.video_url } frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture"></iframe>
						</div>
					) }
					{ started.link_url && started.link_text && (
						<a href={ started.link_url } className="base-desk-button base-desk-button-second" target="_blank">{ started.link_text }</a>
					) }
				</div>
			) }
		</Fragment>
	);
};
 
 export default withFilters( 'base_settings_started' )( StartedTab );