/**
 * WordPress dependencies
 */
 const { __ } = wp.i18n;
 const { Fragment } = wp.element;
 const { withFilters } = wp.components;
 const { TabPanel, Panel, PanelBody } = wp.components;
 import ChangelogItem from './changelog-item';
 
 export const ChangelogTab = () => {
	 const tabs = [
		 {
			 name: 'avanam',
			 title: __( 'Changelog', 'base-settings' ),
			 className: 'base-changelog-tab',
		 },
		 {
			 name: 'pro',
			 title: __( 'Pro Changelog', 'base-settings' ),
			 className: 'base-pro-changelog-tab',
		 },
	 ];
	 return (
		<Fragment>
			{ baseSettingsParams.changelog && (
				<Fragment>
					{ baseSettingsParams.proChangelog && Array.isArray( baseSettingsParams.proChangelog ) && 0 !== baseSettingsParams.proChangelog.length && (
						<TabPanel
						 	className="base-dashboard-changelog-tab-panel base-settings-dashboard-section-tabs"
							activeClass="active-tab"
							orientation="vertical"
							tabs={ tabs }>
							{
								 ( tab ) => {
									 switch ( tab.name ) {
										 case 'avanam':
											 return (
												 <Panel className="base-changelog-section tab-section">
													 <PanelBody
														 opened={ true }
													 >
														 { baseSettingsParams.changelog.map( ( item, index ) => {
															 return <ChangelogItem
																 item={ item }
																 index={ item }
															 />;
														 } ) }
													 </PanelBody>
												 </Panel>
											 );
 
										 case 'pro':
											 return (
												 <Panel className="pro-changelog-section tab-section">
													 <PanelBody
														 opened={ true }
													 >
														 { baseSettingsParams.proChangelog.map( ( item, index ) => {
															 return <ChangelogItem
																 item={ item }
																 index={ item }
															 />;
														 } ) }
													 </PanelBody>
												 </Panel>
											 );
									 }
								 }
							}
						</TabPanel>
					) }
					{ ( '' == baseSettingsParams.proChangelog || ( Array.isArray( baseSettingsParams.proChangelog ) && ! baseSettingsParams.proChangelog.length ) ) && (
						 <Fragment>
							{ baseSettingsParams.changelog.map( ( item, index ) => {
								 return <ChangelogItem
									 item={ item }
									 index={ item }
								 />;
							} ) }
						</Fragment>
					) }
				</Fragment>
			) }
		</Fragment>
	);
};
 
 export default withFilters( 'base_settings_changelog' )( ChangelogTab );