<?php
if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('TemplateMelaCore_WooCommerce_Dokan')) :


    class TemplateMelaCore_WooCommerce_Dokan {
        
        private $suffix = '';

        private $shopkit_settings = '';

        public function __construct() {
            $this->suffix = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

            $this->shopkit_settings = get_option( 'bt_woo_extras' );
            if ( ! is_array( $this->shopkit_settings ) ) {
                $this->shopkit_settings = json_decode( $this->shopkit_settings, true );
            }

            $this->check_activate();
            $this->add_hook();

            add_action( 'wp_enqueue_scripts', array( $this, 'action_enqueue_scripts' ), 999 );

        }

        private function check_activate() {}

        public function add_hook() {

            $dokan_product_page = ( isset( $this->shopkit_settings['dokan_seller_product_page'] ) && !empty($this->shopkit_settings['dokan_seller_product_page']) ) ? $this->shopkit_settings['dokan_seller_product_page'] : '';
            $dokan_shop_page = ( isset( $this->shopkit_settings['dokan_seller_shop_page'] ) && !empty($this->shopkit_settings['dokan_seller_shop_page']) ) ? $this->shopkit_settings['dokan_seller_shop_page'] : '';
            if ( function_exists('dokan') && !empty($dokan_shop_page)) {
                add_action( 'woocommerce_after_shop_loop_item_title', [$this, 'sold_by'], 50 );
            }
            if ( function_exists('dokan') && !empty($dokan_product_page)) {
                add_action( 'woocommerce_single_product_summary', [$this, 'sold_by'], 50 );
            }
        }

        /**
         * WooCommerce specific scripts & stylesheets
         *
         * @since 1.0.0
         */
        public function action_enqueue_scripts() {

            wp_enqueue_style('tmcore-dokan-style',  TMCORE_URL . "assets/css/woocommerce/dokan{$this->suffix}.css", array(), TMCORE_VERSION );
            wp_style_add_data('tmcore-dokan-style', 'rtl', 'replace');

        }

        public function sold_by(){
            
                global $product;

                $seller = get_post_field( 'post_author', $product->get_id());
                $author  = get_user_by( 'id', $seller );
                $vendor = dokan()->vendor->get($seller);
                $store_info = dokan_get_store_info( $author->ID );
                if ( !empty( $store_info['store_name'] ) ) { ?>
                    <div class="seller">
                        <?php 
                        if (isset( $this->shopkit_settings['bt_sold_by_text'] ) && !empty( $this->shopkit_settings['bt_sold_by_text'] )) {
                            echo esc_html__($this->shopkit_settings['bt_sold_by_text']);
                        } else {
                            echo esc_html__('Sold by:','templatemela-core');
                        }?>
                        <?php printf( '<a href="%s">%s</a>', dokan_get_store_url( $author->ID ), $author->display_name ); ?>
                    </div>
                <?php
                }
            }

    }

    return new TemplateMelaCore_WooCommerce_Dokan();
endif;
