<?php
defined( 'ABSPATH' ) || exit;

if ( ! class_exists( 'TemplateMelaCore_WP_Widget_Product_Highlight_Filter' ) ) {
	class TemplateMelaCore_WP_Widget_Product_Highlight_Filter extends TemplateMelaCore_WC_Widget_Base {

		public function __construct() {
			$this->widget_id          = 'tmcore-wp-widget-product-highlight-filter';
			$this->widget_cssclass    = 'tmcore-wp-widget-product-highlight-filter tmcore-wp-widget-filter';
			$this->widget_name        = sprintf( '%1$s %2$s', '[TMCore]', esc_html__( 'Product Highlight Filter', 'templatemela-core' ) );
			$this->widget_description = esc_html__( 'Display a sorting list to sort products in your store.', 'templatemela-core' );
			$this->settings           = array(
				'title'        => array(
					'type'  => 'text',
					'std'   => esc_html__( 'Highlight', 'templatemela-core' ),
					'label' => esc_html__( 'Title', 'templatemela-core' ),
				),
				'display_type' => array(
					'type'    => 'select',
					'std'     => 'list',
					'label'   => esc_html__( 'List Layout', 'templatemela-core' ),
					'options' => array(
						'list'   => esc_html__( 'List', 'templatemela-core' ),
						'inline' => esc_html__( 'Inline', 'templatemela-core' ),
					),
				),
				'list_style'   => array(
					'type'    => 'select',
					'std'     => 'normal',
					'label'   => esc_html__( 'List Style', 'templatemela-core' ),
					'options' => array(
						'normal' => esc_html__( 'Normal List', 'templatemela-core' ),
						'radio'  => esc_html__( 'Radio List', 'templatemela-core' ),
					),
				),
				'enable_collapsed'  => array(
					'type'  => 'checkbox',
					'std'   => 0,
					'label' => esc_html__( 'Collapsed ?', 'templatemela-core' ),
				),
			);

			parent::__construct();
		}

		public function widget( $args, $instance ) {
			if ( ! is_shop() && ! is_product_taxonomy() ) {
				return;
			}

			if ( ! \TemplateMelaCore\Woo\Product_Query::is_main_query_has_post() ) {
				return;
			}

			$filter_name = 'highlight_filter';
			$selected    = isset( $_GET[ $filter_name ] ) ? wc_clean( $_GET[ $filter_name ] ) : '';

			$options = tmcore_get_product_highlight_filter_options();

			$base_link = remove_query_arg( 'paged', $this->get_current_page_url() );

			$this->widget_start( $args, $instance );

			$display_type = $this->get_value( $instance, 'display_type' );
			$list_style   = $this->get_value( $instance, 'list_style' );

			$class = 'tmcore-product-highlight-filter';
			$class .= ' show-display-' . $display_type;
			$class .= ' list-style-' . $list_style;
			$class .= ' single-choice';
			?>
			<ul class="<?php echo esc_attr( $class ); ?>">
				<?php foreach ( $options as $option_value => $option_label ) : ?>
					<?php
					if ( '' === $option_value ) {
						$link = remove_query_arg( $filter_name, $base_link );
					} else {
						$link = add_query_arg( $filter_name, $option_value, $base_link );
					}

					$item_class = 'filter-item';
					if ( $selected === $option_value ) {
						$item_class .= ' chosen';
					}
					?>
					<li class="<?php echo esc_attr( $item_class ); ?>">
						<a href="<?php echo esc_url( $link ); ?>"
						   class="filter-link"><?php echo esc_html( $option_label ); ?>
						</a>
					</li>
				<?php endforeach; ?>
			</ul>
			<?php
			$this->widget_end( $args, $instance );
		}
	}
}
