<?php
/**
 * Result Count
 *
 * Shows text: Showing x - x of x results.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/result-count.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<p class="woocommerce-result-count">
	<?php
	// phpcs:disable WordPress.Security
	if ( 1 === intval( $total ) ) {
		_e( 'Showing the single result', 'woocommerce' );
	} elseif ( $total <= $per_page || -1 === $per_page ) {
		/* translators: %s: total results */
		printf( 
			esc_html( _n( 'Showing all %s result', 'Showing all %s results', $total, 'templatemela-core' ) ),
			'<span class="result">' . $total . '</span>'
		);
	} else {
		//if ( in_array( $pagination_type, [ 'load-more', 'infinite' ], true ) ) {} else {}
		$first = ( $per_page * $current ) - $per_page + 1;
		$last  = min( $total, $per_page * $current );
		/* translators: 1: first result 2: last result 3: total results */
		printf(
			esc_html( _nx( 'Showing %1$d&ndash;%2$s of %3$s result', 'Showing %1$d&ndash;%2$s of %3$s results', $total, 'with first and last result', 'templatemela-core' ) ),
			$first,
			'<span class="showing">' . $last . '</span>',
			'<span class="result">' . $total . '</span>'
		);
	}
	// phpcs:enable WordPress.Security
	?>
</p>
