<?php
/**
 * The template for displaying product widget entries.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-widget-product.php.
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 */

defined( 'ABSPATH' ) || exit;

/** @var WC_Product $product */
global $product;

if ( ! is_a( $product, 'WC_Product' ) ) {
	return;
}
?>
<li>
	<?php do_action( 'tmcore_woocommerce_widget_product_item_start' ); ?>

	<div class="product-item">
		<div class="thumbnail">
			<a href="<?php echo esc_url( $product->get_permalink() ); ?>">
				<?php echo wp_get_attachment_image( get_post_meta( $product->get_id(), '_thumbnail_id', true ), 'woocommerce_gallery_thumbnail' )?>
			</a>
		</div>
		<div class="info">
			<h6 class="product-title post-title-2-rows">
				<a href="<?php the_permalink(); ?>">
					<?php echo wp_kses_post( $product->get_name() ); ?>
				</a>
			</h6>
			
			<?php if ( ! empty( $template_args['show_rating'] ) ) : ?>
				<?php echo wp_kses_post( wc_get_rating_html( $product->get_average_rating() ) ); ?>
			<?php endif; ?>

			<span class="price"><?php echo $product->get_price_html(); ?></span>

		</div>
	</div>

	<?php do_action( 'tmcore_woocommerce_widget_product_item_end' ); ?>
</li>
