/**
 * File base-sticky-add-to-cart.js.
 * Gets sticky add to cart working.
 */

(function() {
	'use strict';
	window.baseStickyAddToCart = {
		/**
		 * Get element's offset.
		 */
		getOffset: function( el ) {
			if ( el instanceof HTMLElement ) {
				var rect = el.getBoundingClientRect();

				return {
					top: rect.top + window.pageYOffset,
					left: rect.left + window.pageXOffset
				}
			}

			return {
				top: null,
				left: null
			};
		},
		/**
		 * Find the sticky items.
		 */
		stickScrollItem: function( element ) {
			var updateSticky = function( e ) {
				var offsetTop = window.baseStickyAddToCart.getOffset( document.getElementById( 'wrapper' ) ).top,
				scrollOffset = window.baseStickyAddToCart.getOffset( document.querySelector( '.product .single_add_to_cart_button' ) ).top;
				if ( window.scrollY >= scrollOffset ) {
					element.style.top = offsetTop + 'px';
					element.classList.add('item-is-fixed');
					element.classList.add('item-is-stuck');
					element.classList.remove('item-at-start');
				} else {
					if ( element.classList.contains( 'item-is-fixed' ) ) {
						element.classList.remove( 'item-is-fixed' );
						element.classList.remove('item-at-start');
						element.classList.remove('item-is-stuck');
						element.style.top = null;
					}
				}
			}
			window.addEventListener( 'resize', updateSticky, false );
			window.addEventListener( 'scroll', updateSticky, false );
			window.addEventListener( 'load', updateSticky, false );
			updateSticky();
		},
		/**
		 * Find the sticky items.
		 */
		stickScrollFooterItem: function( element ) {
			var updateSticky = function( e ) {
				var scrollOffset = window.baseStickyAddToCart.getOffset( document.querySelector( '.product .single_add_to_cart_button' ) ).top;
				if ( window.scrollY >= scrollOffset ) {
					element.classList.add('item-is-fixed');
					element.classList.add('item-is-stuck');
					element.classList.remove('item-at-start');
				} else {
					if ( element.classList.contains( 'item-is-fixed' ) ) {
						element.classList.remove( 'item-is-fixed' );
						element.classList.remove('item-at-start');
						element.classList.remove('item-is-stuck');
					}
				}
				window.baseStickyAddToCart.scrollItemsVisiblity();
			}
			window.addEventListener( 'resize', updateSticky, false );
			window.addEventListener( 'scroll', updateSticky, false );
			window.addEventListener( 'load', updateSticky, false );
			updateSticky();
		},
		/**
		 * Move sticky items when sticky add to cart visible
		 */
		scrollItemsVisiblity: function() {
			
			var element = document.querySelector( '.base-sticky-add-to-cart-footer' );
			var colorSwitcher = document.querySelector( '.single-product .base-color-palette-fixed-switcher' );
			var scrollUpButton = document.querySelector( ".single-product #bt-scroll-up" );
			if ( element.classList.contains( 'item-is-fixed' ) ) {
				if ( colorSwitcher ) {
					colorSwitcher.classList.add( 'sticky-go-up');
					colorSwitcher.classList.add( 'single' );
				}
				if ( scrollUpButton ) {
					scrollUpButton.classList.add( 'sticky-go-up' );
					scrollUpButton.classList.add( 'single' );
				}
			} else {
				
				if ( colorSwitcher.classList.contains('single') ) {
					colorSwitcher.classList.remove( 'single' );
				}
				if ( colorSwitcher.classList.contains('sticky-go-up') ) {
					colorSwitcher.classList.remove( 'sticky-go-up' );
				}				
				if ( scrollUpButton.classList.contains('single') ) {
					scrollUpButton.classList.remove( 'single' );
				}
				if ( scrollUpButton.classList.contains('sticky-go-up') ) {
					scrollUpButton.classList.remove( 'sticky-go-up' );
				}
			}
		},
		/**
		 * Find the sticky items.
		 */
		initStickyScrollItems: function() {
			var stickyScrollItems = document.querySelectorAll( '.base-sticky-add-to-cart-header' );
			// No point if no drawers.
			if ( ! stickyScrollItems.length ) {
				return;
			}
			for ( let i = 0; i < stickyScrollItems.length; i++ ) {
				window.baseStickyAddToCart.stickScrollItem( stickyScrollItems[ i ] );
			}
		},
		/**
		 * Find the sticky items.
		 */
		initStickyScrollFooterItems: function() {
			var stickyScrollFooterItems = document.querySelectorAll( '.base-sticky-add-to-cart-footer' );
			// No point if no drawers.
			if ( ! stickyScrollFooterItems.length ) {
				return;
			}
			for ( let i = 0; i < stickyScrollFooterItems.length; i++ ) {
				window.baseStickyAddToCart.stickScrollFooterItem( stickyScrollFooterItems[ i ] );
			}
		},
		// Initiate sticky when the DOM loads.
		init: function() {
			window.baseStickyAddToCart.initStickyScrollItems();
			window.baseStickyAddToCart.initStickyScrollFooterItems();
		}
	}
	if ( 'loading' === document.readyState ) {
		// The DOM has not yet been loaded.
		document.addEventListener( 'DOMContentLoaded', window.baseStickyAddToCart.init );
	} else {
		// The DOM has already been loaded.
		window.baseStickyAddToCart.init();
	}
})();