<?php
/**
 * Woocommerce Trigger Cart when Product added Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
ob_start(); ?>
<div class="base-compontent-info-box wp-clearfix">
	<p><?php echo esc_html__( 'You must add or remove a product from your active cart to see your settings for this take place.', 'templatemela-core' ); ?></p>
	<p><?php echo esc_html__( 'Use {cart_difference} placeholder in message to output the amount needed for free shipping.', 'templatemela-core' ); ?></p>

</div>
<?php
$compontent_tabs = ob_get_clean();
Theme_Customizer::add_settings(
	array(
		'cart_pop_show_free_shipping' => array(
			'control_type' => 'base_switch_control',
			'section'      => 'cart',
			'priority'     => 21,
			'default'      => webapp()->default( 'cart_pop_show_free_shipping' ),
			'label'        => esc_html__( 'Show amount left in order to receive free shipping in cart Popout', 'templatemela-core' ),
			'transport'    => 'refresh',
			'context'      => array(
				array(
					'setting'  => 'header_cart_style',
					'operator' => '!=',
					'value'    => 'link',
				),
			),
		),
		'cart_pop_free_shipping_info' => array(
			'control_type' => 'base_blank_control',
			'section'      => 'cart',
			'settings'     => false,
			'priority'     => 21,
			'description'  => $compontent_tabs,
			'context'      => array(
				array(
					'setting'  => 'cart_pop_show_free_shipping',
					'operator' => '=',
					'value'    => true,
				),
			),
		),
		'cart_pop_free_shipping_price' => array(
			'type'         => 'number',
			'section'      => 'cart',
			'sanitize'     => 'sanitize_text_field',
			'priority'     => 21,
			'default'      => webapp()->default( 'cart_pop_free_shipping_price' ),
			'label'        => esc_html__( 'Amount needed for Free Shipping.', 'templatemela-core' ),
			'transport'    => 'refresh',
			'context'      => array(
				array(
					'setting'  => 'cart_pop_show_free_shipping',
					'operator' => '=',
					'value'    => true,
				),
			),
		),
		'cart_pop_free_shipping_message' => array(
			'control_type' => 'base_text_control',
			'section'      => 'cart',
			'sanitize'     => 'sanitize_text_field',
			'priority'     => 21,
			'default'      => webapp()->default( 'cart_pop_free_shipping_message' ),
			'label'        => esc_html__( 'Cart Notice Message', 'templatemela-core' ),
			'transport'    => 'refresh',
			'context'      => array(
				array(
					'setting'  => 'cart_pop_show_free_shipping',
					'operator' => '=',
					'value'    => true,
				),
			),
		),
	)
);
