<?php
/**
 * Functions for dark mode.
 *
 * @package Base
 */

namespace BasePro;

use function Base\webapp;
use function Base\render_custom_logo;
use function is_customize_preview;


/**
 * Output Dark mode Mobile Logo.
 */
function dark_mode_mobile_logo() {
	if ( webapp()->option( 'dark_mode_enable' ) && webapp()->option( 'dark_mode_custom_logo' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		if ( webapp()->option( 'dark_mode_mobile_custom_logo' ) ) {
			render_custom_logo( 'dark_mode_mobile_logo', 'base-dark-mode-logo' );
		} else {
			render_custom_logo( 'dark_mode_logo', 'base-dark-mode-logo' );
		}
	}
}
add_action( 'before_base_mobile_logo_output', 'BasePro\dark_mode_mobile_logo' );

/**
 * Output Darkmode Logo.
 */
function dark_mode_logo() {
	if ( webapp()->option( 'dark_mode_enable' ) && webapp()->option( 'dark_mode_custom_logo' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		render_custom_logo( 'dark_mode_logo', 'base-dark-mode-logo' );
	}
}
add_action( 'before_base_logo_output', 'BasePro\dark_mode_logo' );

/**
 * Output Darkmode Learndash Logo.
* @param string $header_element Focus mode header element markup.
 * @param array  $header         Array of header element details keyed logo_alt, logo_url, text, text_url.
 * @param int    $course_id      Course ID.
 * @param int    $user_id        User ID.
 */
function learndash_focus_dark_mode_logo( $header_element, $header, $course_id, $user_id ) {
	if ( webapp()->option( 'dark_mode_enable' ) && webapp()->option( 'dark_mode_learndash_enable' ) && webapp()->option( 'dark_mode_learndash_lesson_logo' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		ob_start();
		echo '<a class="brand base-dark-mode-logo-link" href="' . esc_url( apply_filters( 'base_logo_url', home_url( '/' ) ) ) . '" rel="home" aria-label="' . esc_attr( get_bloginfo( 'name' ) ) . '">';
		render_custom_logo( 'dark_mode_learndash_lesson_logo', 'base-dark-mode-logo' );
		echo '</a>';
		$darkmode_logo = ob_get_clean();
		$header_element = $header_element . $darkmode_logo;
	}
	return $header_element;
}
add_filter( 'learndash_focus_header_element', 'BasePro\learndash_focus_dark_mode_logo', 20, 4 );
/**
 * Output Header Switch.
 */
function header_color_switcher() {
	if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		echo '<div class="base-color-palette-header-switcher">';
		echo output_color_switcher( webapp()->option( 'header_dark_mode_switch_type' ), webapp()->option( 'header_dark_mode_switch_style' ), webapp()->option( 'header_dark_mode_light_icon' ), webapp()->option( 'header_dark_mode_dark_icon' ), webapp()->option( 'header_dark_mode_light_switch_title' ), webapp()->option( 'header_dark_mode_dark_switch_title' ), webapp()->option( 'header_dark_mode_switch_tooltip' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}
}
add_action( 'base_header_dark_mode', 'BasePro\header_color_switcher' );
/**
 * Output Mobile Switch.
 */
function mobile_color_switcher() {
	if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		echo '<div class="base-color-palette-mobile-switcher">';
		echo output_color_switcher( webapp()->option( 'mobile_dark_mode_switch_type' ), webapp()->option( 'mobile_dark_mode_switch_style' ), webapp()->option( 'mobile_dark_mode_light_icon' ), webapp()->option( 'mobile_dark_mode_dark_icon' ), webapp()->option( 'mobile_dark_mode_light_switch_title' ), webapp()->option( 'mobile_dark_mode_dark_switch_title' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}
}
add_action( 'base_mobile_dark_mode', 'BasePro\mobile_color_switcher' );
/**
 * Output Footer Switch.
 */
function footer_color_switcher() {
	if ( webapp()->option( 'dark_mode_enable' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		echo '<div class="base-color-palette-footer-switcher">';
		echo output_color_switcher( webapp()->option( 'footer_dark_mode_switch_type' ), webapp()->option( 'footer_dark_mode_switch_style' ), webapp()->option( 'footer_dark_mode_light_icon' ), webapp()->option( 'footer_dark_mode_dark_icon' ), webapp()->option( 'footer_dark_mode_light_switch_title' ), webapp()->option( 'footer_dark_mode_dark_switch_title' ), webapp()->option( 'footer_dark_mode_switch_tooltip' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}
}
add_action( 'base_footer_dark_mode', 'BasePro\footer_color_switcher' );
/**
 * Output Fixed Switch.
 */
function fixed_color_switcher() {
	if ( webapp()->option( 'dark_mode_enable' ) && webapp()->option( 'dark_mode_switch_show' ) && apply_filters( 'base_dark_mode_enable', true ) ) {
		echo '<div class="base-color-palette-fixed-switcher kcpf-position-' . esc_attr( webapp()->option( 'dark_mode_switch_position' ) ) . ' vs-lg-' . ( webapp()->sub_option( 'dark_mode_switch_visibility', 'desktop' ) ? 'true' : 'false' ) . ' vs-md-' . ( webapp()->sub_option( 'dark_mode_switch_visibility', 'tablet' ) ? 'true' : 'false' ) . ' vs-sm-' . ( webapp()->sub_option( 'dark_mode_switch_visibility', 'mobile' ) ? 'true' : 'false' ) . '">';
		echo output_color_switcher( webapp()->option( 'dark_mode_switch_type' ), webapp()->option( 'dark_mode_switch_style' ), webapp()->option( 'dark_mode_light_icon' ), webapp()->option( 'dark_mode_dark_icon' ), webapp()->option( 'dark_mode_light_switch_title' ), webapp()->option( 'dark_mode_dark_switch_title' ), webapp()->option( 'dark_mode_switch_tooltip' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}
}
add_action( 'wp_footer', 'BasePro\fixed_color_switcher' );
/**
 * Output Header Switch.
 */
function header_learndash_color_switcher() {
	if ( webapp()->option( 'dark_mode_enable' ) && webapp()->option( 'dark_mode_learndash_enable' ) ) {
		echo '<div class="base-color-palette-header-switcher">';
		echo output_color_switcher( webapp()->option( 'header_dark_mode_switch_type' ), webapp()->option( 'header_dark_mode_switch_style' ), webapp()->option( 'header_dark_mode_light_icon' ), webapp()->option( 'header_dark_mode_dark_icon' ), webapp()->option( 'header_dark_mode_light_switch_title' ), webapp()->option( 'header_dark_mode_dark_switch_title' ), webapp()->option( 'header_dark_mode_switch_tooltip' ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		echo '</div>';
	}
}
add_action( 'learndash-focus-header-usermenu-after', 'BasePro\header_learndash_color_switcher' );
/**
 * Output Switch.
 */
function output_color_switcher( $type = 'icon', $style = 'button', $light_icon = 'sun', $dark_icon = 'moon', $light_text = 'Light', $dark_text = 'Dark', $tooltip = false ) {
	echo '<div class="base-color-palette-switcher kcps-style-' . esc_attr( $style ) . ' kcps-type-' . esc_attr( $type ) . '">';
	echo '<button class="base-color-palette-toggle base-color-toggle" aria-label="' . esc_attr__( 'Change site color palette', 'templatemela-core' ) . '">';
	switch ( $type ) {
		case 'text':
			echo '<span class="base-color-palette-light">';
				echo '<span class="base-color-palette-label">';
					echo esc_html( $light_text );
				echo '</span>';
			echo '</span>';
			echo '<span class="base-color-palette-dark">';
				echo '<span class="base-color-palette-label">';
					echo esc_html( $dark_text );
				echo '</span>';
			echo '</span>';
			break;
		case 'both':
			echo '<span class="base-color-palette-light">';
				echo '<span class="base-color-palette-icon">';
				webapp()->print_icon( $light_icon, $light_text );
				echo '</span>';
				echo '<span class="base-color-palette-label">';
					echo esc_html( $light_text );
				echo '</span>';
			echo '</span>';
			echo '<span class="base-color-palette-dark">';
				echo '<span class="base-color-palette-icon">';
				webapp()->print_icon( $dark_icon, $dark_text );
				echo '</span>';
				echo '<span class="base-color-palette-label">';
					echo esc_html( $dark_text );
				echo '</span>';
			echo '</span>';
			break;
		default:
			echo '<span class="base-color-palette-light"' . ( $tooltip ? 'data-tooltip-drop="' . esc_attr( $light_text ) . '"' : '' ) . '>';
				echo '<span class="base-color-palette-icon">';
				webapp()->print_icon( $light_icon, $light_text );
				echo '</span>';
			echo '</span>';
			echo '<span class="base-color-palette-dark"' . ( $tooltip ? 'data-tooltip-drop="' . esc_attr( $dark_text ) . '"' : '' ) . '>';
				echo '<span class="base-color-palette-icon">';
				webapp()->print_icon( $dark_icon, $dark_text );
				echo '</span>';
			echo '</span>';
			break;
	}
	echo '</button>';
	echo '</div>';
}
