<?php
/**
 * Header Account Options.
 *
 * @package Base Pro
 */

namespace BasePro;

use Base\Theme_Customizer;
use function Base\webapp;
$preview_options = array(
	'' => array(
		'name' => __( 'Default', 'templatemela-core' ),
	),
);
$headers = webapp()->option( 'conditional_headers' );
if ( ! empty( $headers['items'] ) && is_array( $headers['items'] ) ) {
	foreach ( $headers['items'] as $header ) {
		$preview_options[ $header['id'] ] = array(
			'name' => $header['label'],
		);
	}
}
$settings = array(
	'header_conditional_heading' => array(
		'control_type' => 'base_conditional_heading_control',
		'section'      => 'header_layout',
		'settings'     => false,
		'priority'     => 5,
		'label'        => esc_html__( 'Previewing Header:', 'templatemela-core' ),
	),
	'header_conditional_link' => array(
		'control_type' => 'base_focus_button_control',
		'section'      => 'header_layout',
		'settings'     => false,
		'priority'     => 21,
		'label'        => esc_html__( 'Conditional Header', 'templatemela-core' ),
		'input_attrs'  => array(
			'section' => 'base_customizer_conditional_header',
		),
	),
	'current_header_preview' => array(
		'control_type' => 'base_conditional_select_control',
		'section'      => 'conditional_header',
		'transport'    => 'refresh',
		'default'      => webapp()->default( 'current_header_preview' ),
		'label'        => esc_html__( 'Current Previewing Header', 'templatemela-core' ),
		'input_attrs'  => array(
			'options' => $preview_options,
		),
	),
	'conditional_headers' => array(
		'control_type' => 'base_conditional_control',
		'section'      => 'conditional_header',
		'default'      => webapp()->default( 'conditional_headers' ),
		'label'        => esc_html__( 'Conditional Headers', 'templatemela-core' ),
	),
);

Theme_Customizer::add_settings( $settings );
