
/**
 * Functions for Notifications.
 */
/* global tmCoreNotifications */

var tmcNotification_is_pause = false,
    tmcNotification_display,
    tmcNotification_time = 0;

//var tmcore_notification = tmCoreNotifications.tmcore_notification;
//var tmcore_notification_count = tmCoreNotifications.tmcore_notification_count;

/* Document ready */
jQuery(document).ready(function($) {
    "use strict";
    if (
        $('#tmc-notification-tml').length &&
        typeof tmcore_notification !== 'undefined' &&
        tmcore_notification &&
        typeof tmcore_notification_count !== 'undefined' &&
        tmcore_notification_count
    ) {
        
        var itemKey = 0;
        var time_interval = 16000;
        
        //tmcore_popup_display($, tmcore_notification[itemKey]); // ONLY FOR DEBUG
        
        tmcore_popup_display_countdown($, tmcore_notification, itemKey, tmcore_notification_count, time_interval);

        $('body').on('click', '.close-noti', function () {
            clearInterval(tmcNotification_display);
            
            $('.tmc-notification')?.removeClass('tmcore-active');
            if($('.base-color-palette-fixed-switcher')?.hasClass('tmcore-go-up')) {
                $('.base-color-palette-fixed-switcher').removeClass('tmcore-go-up');
            }
            $('body').trigger('tmcore_popup_off');
            
            itemKey = itemKey >= tmcore_notification_count-1 ? 0 : itemKey + 1;
            tmcNotification_time = 0;
            tmcNotification_is_pause = false;
            tmcore_popup_display_countdown($, tmcore_notification, itemKey, tmcore_notification_count, time_interval);
        });

        $('body').on('mouseenter', '.tmc-notification', function() {
            if ($('.tmc-notification').hasClass('tmcore-active')) {
                tmcNotification_is_pause = true;
            }
        }).on('mouseleave', '.tmc-notification', function() {
            if ($('.tmc-notification').hasClass('tmcore-active')) {
                tmcNotification_is_pause = false;
            }
        });
    }
});

/* End Document Ready */
function tmcore_popup_display_countdown($, tmcore_notification, itemKey, tmcore_notification_count, time_interval) {
    if (!tmcNotification_is_pause) {
        tmcNotification_time = 0;
    }
    
    tmcNotification_display = setInterval(function() {
        if (!tmcNotification_is_pause) {
            tmcNotification_time = tmcNotification_time + 100;  
            if (tmcNotification_time >= time_interval/2) {
                $('.tmc-notification').removeClass('tmcore-active');
                if($('.base-color-palette-fixed-switcher')?.hasClass('tmcore-go-up')) {
                    $('.base-color-palette-fixed-switcher').removeClass('tmcore-go-up');
                }                
                $('body').trigger('tmcore_popup_off');
            }
            if (tmcNotification_time >= time_interval) {
                itemKey = itemKey >= tmcore_notification_count-1 ? 0 : itemKey + 1;
                tmcore_popup_display($, tmcore_notification[itemKey]);
                tmcNotification_time = 0;
            }
        }
    }, 100);
}

function tmcore_popup_display($, itemData) {
    if ($('.tmc-notification').length <= 0) {
        $('body').append('<div class="tmc-notification"></div>');
    }
    if (typeof itemData !== 'undefined') {
        var html_content = $('#tmc-notification-tml').html();

        html_content = html_content.replace(/{{product_name}}/g, itemData['product_name']);
        html_content = html_content.replace(/{{product_image}}/g, itemData['product_image']);
        html_content = html_content.replace(/{{product_info}}/g, itemData['product_info']);
        html_content = html_content.replace(/{{product_url}}/g, itemData['product_url']);
        html_content = html_content.replace(/{{time_purchase}}/g, itemData['time_purchase']);
        html_content = html_content.replace(/{{product_data}}/g, itemData['product_data']);

        $('.tmc-notification').html(html_content);
        
        setTimeout(function () {
            $('.tmc-notification').addClass('tmcore-active');
            $('body').trigger('tmcore_popup_on');
            if($('.base-color-palette-fixed-switcher')?.hasClass('kcpf-position-left')) {
                $('.base-color-palette-fixed-switcher').addClass('tmcore-go-up');
            }
        }, 100);
    }
}
