/**
 * Functions for all pages. i.e popups and scrollers
 */
/* global tmCoreShop */
(function() {
	'use strict';
	window.base = {

        initPerfectScrollBar: function() {

            const perfectScrollWidgets = document.querySelector('.widget-area .widget-scrollable .widget-content-inner');
            if ( perfectScrollWidgets ) {
                const ps1 = new PerfectScrollbar(perfectScrollWidgets, {
                    wheelPropagation: true,
                });
            }

            const perfectScrollCompare = document.querySelector('.woosc-quick-table-products');
            if ( perfectScrollCompare ) {
                const ps2 = new PerfectScrollbar(perfectScrollCompare, {
                    wheelPropagation: true,
                });
            }
            
            const perfectScrollExit = document.querySelector('#exit-popup.popup-drawer.exit-popup .exit-product');
            if ( perfectScrollExit ) {
                const ps3 = new PerfectScrollbar(perfectScrollExit, {
                    wheelPropagation: true,
                    useBothWheelAxes: false,
                    suppressScrollX: true
                });
            }

            const perfectScrollWelcome = document.querySelector('#welcome-popup.popup-drawer.welcome-popup .drawer-inner .drawer-content');
            if ( perfectScrollWelcome ) {
                const ps4 = new PerfectScrollbar(perfectScrollWelcome, {
                    wheelPropagation: true,
                    useBothWheelAxes: false,
                    suppressScrollX: true
                });
            }

        },

        initStickyScroll: function() {

            var Helpers = window.tmcore.Helpers;

            /* Scroll Horizontally */
            const stickyContainer = document.querySelectorAll('.sticky-container > .elementor-widget-wrap');
            var scrollingHorizontally = [];
            stickyContainer.forEach(function(postScroll, index) {

                const ps5 = new PerfectScrollbar(postScroll, {
                    useBothWheelAxes: true,
                    wheelPropagation: true,
                });
                
                //Helpers.dragToScrollX(postScroll);

            });
            
            /* Scroll Horizontally */
            const stickyContainer2 = document.querySelectorAll('.sticky-container .row');
            var scrollingHorizontally2 = [];
            stickyContainer2.forEach(function(postScroll2, index2) {
                
                if (postScroll2) {
                
                    const ps6 = new PerfectScrollbar(postScroll2, {
                        useBothWheelAxes: true,
                        wheelPropagation: true,
                    });                    

                    //Helpers.dragToScrollX(postScroll2);

                }
            });

            /* Scroll Horizontally */
            const stickyContainer3 = document.querySelectorAll('.cms-sticky-container > .elementor-container');
            var scrollingHorizontally3 = [];
            stickyContainer3.forEach(function(postScroll3, index3) {
                
                const ps7 = new PerfectScrollbar(postScroll3, {
                    useBothWheelAxes: true,
                    wheelPropagation: true,
                });

                //Helpers.dragToScrollX(postScroll3);
            });


            /* Scroll Horizontally */
            const stickyContainer4 = document.querySelectorAll('.simple-scroll .elementor-widget-wrap');
            var scrollingHorizontally4 = [];
            stickyContainer4.forEach(function(postScroll4, index4) {
                scrollingHorizontally4[index4] = true;
                if (postScroll4) {
                    postScroll4.addEventListener("wheel", (event) => {
                        if (scrollingHorizontally4[index4]) {
                            postScroll4.scrollBy({
                            left: event.deltaY < 0 ? -80 : 80,
                            });
                            event.preventDefault();

                            // check if the user has reached the end of the slider
                            if ( postScroll4.scrollLeft >= postScroll4.scrollWidth - postScroll4.clientWidth ) {
                                scrollingHorizontally4[index4] = false;
                                postScroll4.style.overflowY = "auto";
                            }
                        } else {
                            scrollingHorizontally4[index4] = true;
                            // (scroll the page up/down)
                            return true;
                        }
                    });
                }
            });
            
        }

    }
    if ( 'loading' === document.readyState ) {
        // The DOM has not yet been loaded.
        document.addEventListener( 'DOMContentLoaded', window.base.initPerfectScrollBar );
        document.addEventListener( 'DOMContentLoaded', window.base.initStickyScroll );
    } else {
        // The DOM has already been loaded.
        window.base.initPerfectScrollBar();
        window.base.initStickyScroll();
    }
    /* window.addEventListener('resize', function(){
        window.base.initPerfectScrollBar();
        window.base.initStickyScroll();
    }, true); */

})(window);


(function() {
	'use strict';
	window.base = {

        // Initiate the popup when the DOM loads.
		initWelcomePopup: function() {
            
            var Helpers = window.tmcore.Helpers;
            var popupStatus = ( 'false' == Helpers.getCookie('tmc_welcome_popup_status') ) ? 'false' : 'true';
            var popup = document.querySelector('#welcome-popup');
            
            //Helpers.deleteCookie('tmc_welcome_popup_close_repeat');  // for debug
            //Helpers.deleteCookie('tmc_welcome_popup_status');  // for debug

            if (popupStatus != 'false' ){
                if ( popup ) {
                    var repeat_time = parseFloat(popup.dataset.repeat);
                    if (!repeat_time) {
                        repeat_time = parseFloat(2);
                    }

                    var expire_days = parseFloat(popup.dataset.expire);
                    var coockRepeat = parseFloat( Helpers.getCookie('tmc_welcome_popup_close_repeat' ));
                    coockRepeat = ( Number.isInteger(coockRepeat) ) ? coockRepeat : 0;
                    
                    var checkBox = document.getElementById("welcome_dismiss_show");
                    if (checkBox && checkBox.checked == true){
                        Helpers.setCookie('tmc_welcome_popup_status', 'false' , expire_days );
                    }
                    if( coockRepeat < repeat_time ) {
                        //console.log(coockRepeat);
                        var dataDelay = parseFloat(popup.dataset.delay) * 1000 ;
                        setTimeout(function () {
                            
                            var otherOpen = false;
                            document.querySelectorAll('.popup-drawer').forEach(element => {
                                if( element && element.classList.contains('show-drawer') && element.classList.contains('exit-popup')) {
                                    otherOpen = true;
                                }
                            });
                            if ( !otherOpen ) {
                                //console.log( 'welcome repeat ' + coockRepeat);
                                window?.base?.toggleDrawer( document.querySelector('*[data-toggle-target="' + popup.dataset.drawerTargetString + '"]' ) );

                                coockRepeat  = coockRepeat + 1;
                                Helpers.setCookie('tmc_welcome_popup_close_repeat', coockRepeat , expire_days );
                            }
                        }, dataDelay );
                        
            
                    } else if( coockRepeat > repeat_time ) {
                        Helpers.setCookie('tmc_welcome_popup_status', 'false' , expire_days );
                    }
                }
            }

            // Close modal on outside or close button click.
			document.addEventListener( 'click', function (event) {
				var target = event.target;
				var modal = document.querySelector( '.show-drawer.active .drawer-overlay' );
				if ( target === modal ) {
                    var checkBox = document.getElementById("welcome_dismiss_show");
                    if (checkBox?.checked == true) {
                        //console.log('checkbox coockie set overlay');
                        Helpers.setCookie('tmc_welcome_popup_status', 'false' , expire_days );
                    }
				}
                var closeModal = document.querySelector( '.popup-toggle-close' );
                if ( closeModal && closeModal.contains( event.target ) ) {
                    var checkBox = document.getElementById("welcome_dismiss_show");
                    if (checkBox?.checked == true) {
                        Helpers.setCookie('tmc_welcome_popup_status', 'false' , expire_days );
                    }
				}

			} );

        },

        // Initiate the popup when the DOM loads.
		initExitPopup: function() {
            
            var Helpers = window.tmcore.Helpers;
            var popupStatus = ( 'false' == Helpers.getCookie('tmc_exit_popup_status') ) ? 'false' : 'true';
            var popup = document.querySelector('#exit-popup');

            //Helpers.deleteCookie('tmc_exit_popup_close_repeat');  // for debug
            //Helpers.deleteCookie('tmc_exit_popup_status');  // for debug

            document.addEventListener( 'mouseout', function (event) {

                const shouldShowExitIntent = 
                    !event.toElement && 
                    !event.relatedTarget;

                if ( popupStatus != 'false' && shouldShowExitIntent ){
                    if ( popup ) {
                        if ( !popup.classList.contains('show-drawer') ) {
                            var repeat_time = parseFloat(popup.dataset.repeat);
                            if (!repeat_time) {
                                repeat_time = parseFloat(2);
                            }
        
                            var expire_days = parseFloat(popup.dataset.expire);
                            var coockRepeat = parseFloat( Helpers.getCookie('tmc_exit_popup_close_repeat' ));
                            coockRepeat = ( Number.isInteger(coockRepeat) ) ? coockRepeat : 0;
                            
                            var checkBox = document.getElementById("exit_dismiss_show");
                            if (checkBox?.checked == true){
                                Helpers.setCookie('tmc_exit_popup_status', 'false' , expire_days );
                            }
                            if( coockRepeat < repeat_time ) {
                                //console.log( 'exit repeat ' + coockRepeat);

                                var otherOpen = false;
                                document.querySelectorAll('.popup-drawer').forEach(element => {
                                    if(element && element.classList.contains('show-drawer') && element.classList.contains('welcome-popup')) {
                                        otherOpen = true;
                                    }              
                                });
                                if ( !otherOpen ) { 
                                    window?.base?.toggleDrawer( document.querySelector('*[data-toggle-target="' + popup.dataset.drawerTargetString + '"]' ) );
                                    coockRepeat  = coockRepeat + 1;
                                    Helpers.setCookie('tmc_exit_popup_close_repeat', coockRepeat , expire_days );
                                }
                    
                            } else if( coockRepeat > repeat_time ) {
                                Helpers.setCookie('tmc_exit_popup_status', 'false' , expire_days );
                            }

                        }
                    }
                }

            });

            // Close modal on outside or close button click.
			document.addEventListener( 'click', function (event) {
				var target = event.target;
                var expire_days = parseFloat(popup?.dataset?.expire);
				var modal = document.querySelector( '.show-drawer.active .drawer-overlay' );
				if ( target === modal ) {
                    var checkBox = document.getElementById("exit_dismiss_show");
                    if (checkBox?.checked == true) {
                        //console.log('checkbox coockie set overlay');
                        Helpers.setCookie('tmc_exit_popup_status', 'false' , expire_days );
                    }
				}
                var closeModal = document.querySelector( '.popup-toggle-close' );
                if ( closeModal && closeModal.contains( event.target ) ) {
                    var checkBox = document.getElementById("exit_dismiss_show");
                    if (checkBox?.checked == true) {
                        Helpers.setCookie('tmc_exit_popup_status', 'false' , expire_days );
                    }
				}

			} );
        },

        // Initiate the popup when the DOM loads.
		initCookiePopup: function() {
            
            var Helpers = window.tmcore.Helpers;
            var popupStatus = ( 'false' == Helpers.getCookie('tmc_cookie_popup_status') ) ? 'false' : 'true';
            var popup = document.querySelector('#cookie-popup');
            
            //Helpers.deleteCookie('tmc_cookie_popup_status');  // for debug
            
            if (popupStatus != 'false' ){
                if ( popup ) {
               
                    var dataDelay = parseFloat(popup.dataset.delay) * 1000 ;
                    setTimeout(function () {

                        window?.base?.toggleDrawer( document.querySelector('*[data-toggle-target="' + popup.dataset.drawerTargetString + '"]' ) );
                        var bodyCSS = document.querySelector('body[class*=showing-popup-drawer-]');
                        if(bodyCSS) { bodyCSS.setAttribute("style", "overflow:visible"); }

                    }, dataDelay );
                }
            }

            // Close modal on outside or close button click.
			document.addEventListener( 'click', function (event) {
				
                var target = event.target;
                
                if( target && target.classList.contains( 'popup-toggle-close' )) {
                    if ( popupStatus != 'false' ){
                        if ( popup ) {
                            //console.log('in popup');
                            var expire_days = parseFloat(popup.dataset.expire);
                            Helpers.setCookie('tmc_cookie_popup_status', 'false' , expire_days );
                        }
                    }
				}
			} );

        }

    }
	if ( 'loading' === document.readyState ) {
		// The DOM has not yet been loaded.
		document.addEventListener( 'DOMContentLoaded', window.base.initWelcomePopup );
        document.addEventListener( 'DOMContentLoaded', window.base.initExitPopup );
        document.addEventListener( 'DOMContentLoaded', window.base.initCookiePopup );
	} else {
		// The DOM has already been loaded.
		window.base.initWelcomePopup();
        window.base.initExitPopup();
        window.base.initCookiePopup();
        
	}
})(window);



jQuery(function($){
	"use strict";

    if( $('.mc4wp-response').length ){
        // Mail-Chimp Alert-btn
        $( ".mc4wp-response .mc4wp-alert" ).append( '<span class="close-btn"><span class="base-svg-iconset"><svg class="base-svg-icon base-close-svg" fill="currentColor" version="1.1" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><title>Toggle Menu Close</title><path d="M5.293 6.707l5.293 5.293-5.293 5.293c-0.391 0.391-0.391 1.024 0 1.414s1.024 0.391 1.414 0l5.293-5.293 5.293 5.293c0.391 0.391 1.024 0.391 1.414 0s0.391-1.024 0-1.414l-5.293-5.293 5.293-5.293c0.391-0.391 0.391-1.024 0-1.414s-1.024-0.391-1.414 0l-5.293 5.293-5.293-5.293c-0.391-0.391-1.024-0.391-1.414 0s-0.391 1.024 0 1.414z"></path></svg></span></span>' );

        $(".mc4wp-response .close-btn").click(function() {
            $(".mc4wp-response .mc4wp-alert").remove();
        });
    }
});


jQuery(function($){
	"use strict";

    if( $('img.tmcore-lazy-load').length ){
        $(window).on('scroll tmcore_lazy_load', function(){
            var scroll_top = $(this).scrollTop();
            var window_height = $(this).height();
            $('img.tmcore-lazy-load:not(.loaded)').each(function(){
                if( $(this).data('src') && $(this).offset().top < scroll_top + window_height + 900 ){
                    $(this).attr('src', $(this).data('src')).addClass('loaded');
                }
            });
        });

        setTimeout(function(){
            if( $('img.tmcore-lazy-load').length ) {
                if( $('img.tmcore-lazy-load:first').offset().top < $(window).scrollTop() + $(window).height() + 200 ){
                    $(window).trigger('tmcore_lazy_load');
                }
            }
        }, 50);
    }

    
    if( $('.shimmer').length ){
        $(window).on('scroll tmcore_lazy_shimmer', function(){
            var scroll_top = $(this).scrollTop();
            var window_height = $(this).height();
            $('.shimmer').each(function(){
                if (!$(this).parents('.ajax-load').length) {
                    if( $(this).offset().top < scroll_top + window_height + 900 ){
                        $(this).removeClass('shimmer');
                    }
                }
            });
        });

        setTimeout(function(){
            if( $('.shimmer:first').length ) {
                if( $('.shimmer:first').offset().top < $(window).scrollTop() + $(window).height() + 200 ){
                    $(window).trigger('tmcore_lazy_shimmer');
                }
            }
        }, 50);
    }

    if( $('.shimmercat').length ){
        $(window).on('scroll tmcore_lazy_shimmercat', function(){
            var scroll_top = $(this).scrollTop();
            var window_height = $(this).height();
            $('.shimmercat').each(function(){
                if( $(this).offset().top < scroll_top + window_height + 900 ){
                    $(this).removeClass('shimmercat');
                }
            });
        });

        setTimeout(function(){
            if( $('.shimmercat:first').length ) {
                if( $('.shimmercat:first').offset().top < $(window).scrollTop() + $(window).height() + 200 ){
                    $(window).trigger('tmcore_lazy_shimmercat');
                }
            }
        }, 50);
    }


});