window.addEventListener('elementor/frontend/init', function () {

    elementorFrontend.hooks.addAction('frontend/element_ready/tmcore-testimonials.default',
    async function ($scope) {

        //const { Splide } = await import('@splidejs/splide');

        const id = $scope[0]?.dataset?.id;
        const selector = `[data-id="${id}"] .splide` // Make a string selector from the Elementor IDn

        let brandSlider = document.querySelector(selector);

        if (typeof(brandSlider) != 'undefined' && brandSlider != null ) {

            let sliderSettings = JSON.parse(brandSlider.dataset.settings);
            let scrollIsOne = 1;
            //let sliderAnimSpeed = 400;
            let sliderArrows = true;
            let sliderDots = true;
            let sliderDirection = "ltr";
            let isLoopOrSlide = 'slide';

            if (document.querySelector('html[dir="rtl"]')) {
                sliderDirection = "rtl";
            } else {
                sliderDirection = "ltr";
            }

            if ( sliderSettings['loop'] == true ) {
                isLoopOrSlide = 'loop';
            } else {
                isLoopOrSlide = 'slide';
            }

            if (sliderSettings['navigation'] == 'both') {
                sliderArrows = true;
                sliderDots = true;
            } else if (sliderSettings['navigation'] == 'arrows') {
                sliderArrows = true;
                sliderDots = false;
            } else if (sliderSettings['navigation'] == 'dots') {
                sliderArrows = false;
                sliderDots = true;
            } else {
                sliderArrows = false;
                sliderDots = false;
            }


            var splideCarousel = new Splide( selector, {
                autoplay: sliderSettings['autoplay'] || false,
                type   : isLoopOrSlide,
                perPage: sliderSettings['items'] || 4,
                interval: sliderSettings['autoplayTimeout'] || 7000,
                speed: sliderSettings['autoplay_speed'] || 400,
                arrows: sliderArrows || false,
                pagination: sliderDots || false,
                direction: sliderDirection,
                pauseOnHover: sliderSettings['autoplayHoverPause'] || false,
                drag: true,
                rewind: false,
                rewindByDrag: false,
                //focus  : 0,
                //omitEnd: true,
                breakpoints: {
                    767: {
                        perPage: sliderSettings['items_mobile'] || 2,
                        perMove: scrollIsOne || sliderSettings['items_mobile'],
                        //focus  : 0,
                        //omitEnd: true,
                    },
                    1024: {
                        perPage: sliderSettings['items_tablet'] || 3,
                        perMove: scrollIsOne || sliderSettings['items_tablet'],
                        //focus  : 0,
                        //omitEnd: true,
                    },
                    1366: {
                        perPage: sliderSettings['items_laptop'] || 3,
                        perMove: scrollIsOne || sliderSettings['items_laptop'],
                        //focus  : 0,
                        //omitEnd: true,
                    },
                },
            } );

            splideCarousel.mount();
        }
        
        //const carousel = new Splide(selector)
        //carousel.mount();
    });
});

