window.addEventListener('elementor/frontend/init', function () {

    elementorFrontend.hooks.addAction('frontend/element_ready/tmcore-products.default',
    async function ($scope) {

        const id = $scope[0]?.dataset?.id;
        const selector = `[data-id="${id}"] .splide`; // Make a string selector from the Elementor IDn
        const listWrapSelector = `[data-id="${id}"] .splide ul.products`;
        const listSelector = `[data-id="${id}"] .splide ul.products > li`;

        let wooSlider = document.querySelector(selector);
        let wooSliderListWrap = document.querySelector(listWrapSelector);

        if (typeof(wooSlider) != 'undefined' && wooSlider != null ) {

            /* sliderSettings['loop']: true
            sliderSettings['navigation']: "arrows" */
            
            wooSliderListWrap.classList.remove("grid-cols");
            wooSliderListWrap.classList.add("splide__list");
    
            const list = document.querySelectorAll(listSelector);
            list.forEach(function(slideli, index) {
                slideli.classList.add("splide__slide");
            });

            let sliderSettings = JSON.parse(wooSlider.dataset.settings);
            let scrollIsOne = 1;
            //let sliderAnimSpeed = 400;
            let sliderArrows = true;
            let sliderDots = true;
            let sliderDirection = "ltr";
            let isLoopOrSlide = 'slide';

            //console.log(sliderSettings);

            if (document.querySelector('html[dir="rtl"]')) {
                sliderDirection = "rtl";
            } else {
                sliderDirection = "ltr";
            }

            if (sliderSettings['loop']==true) {
                isLoopOrSlide = 'loop';
            } else {
                isLoopOrSlide = 'slide';
            }

            if (sliderSettings['navigation'] == 'both') {
                sliderArrows = true;
                sliderDots = true;
            } else if (sliderSettings['navigation'] == 'arrows') {
                sliderArrows = true;
                sliderDots = false;
            } else if (sliderSettings['navigation'] == 'dots') {
                sliderArrows = false;
                sliderDots = true;
            } else {
                sliderArrows = false;
                sliderDots = false;
            }

            if (sliderSettings['product_layout'] == 'grid') {
                mobileColumn =  2;
            } else {
                mobileColumn = 1;
            }

            // console.log(sliderSettings);
          
            var splideCarousel = new Splide( selector, {
                autoplay: sliderSettings['autoplay'] || false,
                type   : isLoopOrSlide,
                perPage: sliderSettings['items'] || 4,
                perMove: 1,
                interval: sliderSettings['autoplayTimeout'] || 7000,
				speed: sliderSettings['autoplay_speed'] || 400,
				arrows: sliderArrows || false,
				pagination: sliderDots || false,
				direction: sliderDirection,
                pauseOnHover: sliderSettings['autoplayHoverPause'] || false,
                drag: true,
                rewind: false,
                rewindByDrag: false,
                //focus  : 0,
                //omitEnd: true,
                gap: sliderSettings['gap'],
                grid: {
                    dimensions: [ [ sliderSettings['dimensions'] || 1 , 1 ] ],  //rows and cols
                    gap: {
                        row: sliderSettings['gap'],
                        col: sliderSettings['gap'],
                    }
                },
                breakpoints: {
                    540: {
                        perPage: mobileColumn,
                        perMove: scrollIsOne || mobileColumn,
                        //focus  : 0,
                        //omitEnd: true,
                    },
                    767: {
                        perPage: sliderSettings['items_mobile'] || 3,
                        perMove: scrollIsOne || sliderSettings['items_mobile'],
                        gap: sliderSettings['gap_mobile'],
                        //focus  : 0,
                        //omitEnd: true,
                        grid: {
                            gap: {
                                row: sliderSettings['gap_mobile'],
                                col: sliderSettings['gap_mobile'],
                            }
                        },
                    },
                    1024: {
                        perPage: sliderSettings['items_tablet'] || 3,
                        perMove: scrollIsOne || sliderSettings['items_tablet'],
                        gap: sliderSettings['gap_tablet'],
                        //focus  : 0,
                        //omitEnd: true,
                        grid: {
                            gap: {
                                row: sliderSettings['gap_tablet'],
                                col: sliderSettings['gap_tablet'],
                            }
                        },
                    },
                    1366: {
                        perPage: sliderSettings['items_laptop'] || 3,
                        perMove: scrollIsOne || sliderSettings['items_laptop'],
                        gap: sliderSettings['gap_laptop'],
                        //focus  : 0,
                        //omitEnd: true,
                        grid: {
                            gap: {
                                row: sliderSettings['gap_laptop'],
                                col: sliderSettings['gap_laptop'],
                            }
                        },
                    },
                },
            } );
    
            if(sliderSettings['dimensions'] > 1){
                splideCarousel.mount( window.splide.Extensions );
            } else {
                splideCarousel.mount();
            }
            
        }

    });
});
