<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.2 for plugin TemplateMela Core
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

/**
 * Include the TGM_Plugin_Activation class.
 *
 * Depending on your implementation, you may want to change the include call:
 *
 * Parent Theme:
 * require_once get_template_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Child Theme:
 * require_once get_stylesheet_directory() . '/path/to/class-tgm-plugin-activation.php';
 *
 * Plugin:
 * require_once dirname( __FILE__ ) . '/path/to/class-tgm-plugin-activation.php';
 */
require_once dirname( __FILE__ ) . '/class-tgmpa-plugin-activation.php';

add_action( 'admin_init', 'tmc_register_required_plugins' );
add_action( 'tgmpa_register', 'tmc_register_required_plugins' );

/**
 * Register the required plugins for this theme.
 *
 * In this example, we register five plugins:
 * - one included with the TGMPA library
 * - two from an external source, one from an arbitrary source, one from a GitHub repository
 * - two from the .org repo, where one demonstrates the use of the `is_callable` argument
 *
 * The variables passed to the `tgmpa()` function should be:
 * - an array of plugin arrays;
 * - optionally a configuration array.
 * If you are not changing anything in the configuration array, you can remove the array and remove the
 * variable from the function call: `tgmpa( $plugins );`.
 * In that case, the TGMPA default settings will be used.
 *
 * This function is hooked into `tgmpa_register`, which is fired on the WP `init` action on priority 10.
 */
function tmc_register_required_plugins() {

	$tmc_options = TemplateMelaCore_Settings::get_setting_option( 'tm_core_api_manager' ) ;
	$lkey = ( isset( $tmc_options['tm_core_api_key'] ) ) ? $tmc_options['tm_core_api_key'] : '';

	$free_plugins = array();
	
	$free_plugins = array(
		array(
			'order'         => 10,
			'name'          => esc_html__( 'WooCommerce', 'templatemela-core' ),
			'slug'          => 'woocommerce',
			'required'      => true,
			'preselected'   => true,
			'is_callable'   => true,
		),
		array(
			'order'         => 15,
			'name'          => esc_html__( 'Elementor Page Builder', 'templatemela-core' ),
			'slug'          => 'elementor',
			'required'      => true,
			'preselected'   => true,
			'is_callable'   => true,
		),
		array(
			'order'         => 20,
			'name'      	=> esc_html__( 'Mailchimp Newsletter', 'templatemela-core' ),
			'slug'      	=> 'mailchimp-for-wp',
			'required'  	=> false,
		),
		array(
			'order'         => 25,
			'name'      	=> esc_html__( 'WPC Smart Compare for WooCommerce', 'templatemela-core' ),
			'slug'      	=> 'woo-smart-compare',
			'required'  	=> false,
		),
		array(
			'order'         => 30,
			'name'      	=> esc_html__( 'WPC Smart Quick View for WooCommerce', 'templatemela-core' ),
			'slug'      	=> 'woo-smart-quick-view',
			'required'  	=> false,
		),
		array(
			'order'         => 35,
			'name'      	=> esc_html__( 'WPC Smart Wishlist for WooCommerce', 'templatemela-core' ),
			'slug'      	=> 'woo-smart-wishlist',
			'required'  	=> false,
		),
		array(
			'order'         => 40,
			'name'      	=> esc_html__( 'Contact Form 7', 'templatemela-core' ),
			'slug'      	=> 'contact-form-7',
			'required'      => false,
		),
		array(
			'order'         => 50,
			'name'          => esc_html__( 'Slider Revolution', 'templatemela-core' ),
			'slug'          => 'revslider',
			'desc'          => esc_html__( 'Slider Revolution is a new way to build rich & dynamic slides', 'templatemela-core' ),
			'description'   => esc_html__( 'Slider Revolution is a new way to build rich & dynamic slides', 'templatemela-core' ),
			'source'        => 'https://data.templatemela.com/plugins/wp/download/?plugin=revslider&key=tmcore_'.$lkey,
			'image'         => 'https://data.templatemela.com/plugins/wp/revslider/revslider.png',
			'required'      => false,
			'preselected'   => true,
			'version'       => '6.7.18',
			'is_callable'   => true,
		),
	);

	/*
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	$recommended_plugins = apply_filters( 'tmc_recommended_plugins' , $free_plugins );

	/*
	 * Array of configuration settings. Amend each line as needed.
	 *
	 * TGMPA will start providing localized text strings soon. If you already have translations of our standard
	 * strings available, please help us make TGMPA even better by giving us access to these translations or by
	 * sending in a pull-request with .po file(s) with the translations.
	 *
	 * Only uncomment the strings in the config array if you want to customize the strings.
	 */
	$config = array(
		'id'           => 'templatemela-core',     // Unique ID for hashing notices for multiple instances of TGMPA.
		'default_path' => '',                      // Default absolute path to bundled plugins.
		'menu'         => 'templatemela-install-plugins', // Menu slug.
		'parent_slug'  => 'templatemela',          // Parent menu slug.
		'capability'   => 'edit_theme_options',    // Capability needed to view plugin install page, should be a capability associated with the parent menu used.
		'has_notices'  => false,                   // Show admin notices or not.
		'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
		'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
		'is_automatic' => true,                   // Automatically activate plugins after installation or not.
		'message'      => '
		<div class="install-plugin-message">
			<h1>Install the required and recommended plugins for the <strong>TemplateMela Theme</strong>.</h1>
		</div>',                                   // Message to output right before the plugins table.
	);

	tgmpa( $recommended_plugins, $config );
}
